/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import org.apache.lucene.spatial.util.GeoUtils;

public class GeoRect {
    public final double minLat;
    public final double minLon;
    public final double maxLat;
    public final double maxLon;

    public GeoRect(double minLat, double maxLat, double minLon, double maxLon) {
        GeoUtils.checkLatitude(minLat);
        GeoUtils.checkLatitude(maxLat);
        GeoUtils.checkLongitude(minLon);
        GeoUtils.checkLongitude(maxLon);
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.minLat = minLat;
        this.maxLat = maxLat;
        assert (maxLat >= minLat);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GeoRect(lon=");
        b.append(this.minLon);
        b.append(" TO ");
        b.append(this.maxLon);
        if (this.maxLon < this.minLon) {
            b.append(" (crosses dateline!)");
        }
        b.append(" lat=");
        b.append(this.minLat);
        b.append(" TO ");
        b.append(this.maxLat);
        b.append(")");
        return b.toString();
    }

    public boolean crossesDateline() {
        return this.maxLon < this.minLon;
    }
}

