/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.DistanceStyle;
import org.apache.lucene.geo3d.GeoBaseMembershipShape;
import org.apache.lucene.geo3d.GeoDistanceShape;
import org.apache.lucene.geo3d.GeoPoint;
import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.Vector;

public abstract class GeoBaseDistanceShape
extends GeoBaseMembershipShape
implements GeoDistanceShape {
    public GeoBaseDistanceShape(PlanetModel planetModel) {
        super(planetModel);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.isWithin(point.x, point.y, point.z);
    }

    @Override
    public double computeDistance(DistanceStyle distanceStyle, GeoPoint point) {
        return this.computeDistance(distanceStyle, point.x, point.y, point.z);
    }

    @Override
    public double computeDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (!this.isWithin(x, y, z)) {
            return Double.MAX_VALUE;
        }
        return this.distance(distanceStyle, x, y, z);
    }

    protected abstract double distance(DistanceStyle var1, double var2, double var4, double var6);
}

