/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ReaderUtil;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellChecker
implements Closeable {
    public static final float DEFAULT_ACCURACY = 0.5f;
    public static final String F_WORD = "word";
    private static final Term F_WORD_TERM = new Term("word");
    Directory spellIndex;
    private float bStart = 2.0f;
    private float bEnd = 1.0f;
    private IndexSearcher searcher;
    private final Object searcherLock = new Object();
    private final Object modifyCurrentIndexLock = new Object();
    private volatile boolean closed = false;
    private float accuracy = 0.5f;
    private StringDistance sd;
    private Comparator<SuggestWord> comparator;

    public SpellChecker(Directory spellIndex, StringDistance sd) throws IOException {
        this(spellIndex, sd, SuggestWordQueue.DEFAULT_COMPARATOR);
    }

    public SpellChecker(Directory spellIndex) throws IOException {
        this(spellIndex, new LevensteinDistance());
    }

    public SpellChecker(Directory spellIndex, StringDistance sd, Comparator<SuggestWord> comparator) throws IOException {
        this.setSpellIndex(spellIndex);
        this.setStringDistance(sd);
        this.comparator = comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpellIndex(Directory spellIndexDir) throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            if (!IndexReader.indexExists((Directory)spellIndexDir)) {
                IndexWriter writer = new IndexWriter(spellIndexDir, new IndexWriterConfig(Version.LUCENE_CURRENT, (Analyzer)new WhitespaceAnalyzer(Version.LUCENE_CURRENT)));
                writer.close();
            }
            this.swapSearcher(spellIndexDir);
        }
    }

    public void setComparator(Comparator<SuggestWord> comparator) {
        this.comparator = comparator;
    }

    public Comparator<SuggestWord> getComparator() {
        return this.comparator;
    }

    public void setStringDistance(StringDistance sd) {
        this.sd = sd;
    }

    public StringDistance getStringDistance() {
        return this.sd;
    }

    public void setAccuracy(float acc) {
        this.accuracy = acc;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public String[] suggestSimilar(String word, int numSug) throws IOException {
        return this.suggestSimilar(word, numSug, null, null, false);
    }

    public String[] suggestSimilar(String word, int numSug, float accuracy) throws IOException {
        return this.suggestSimilar(word, numSug, null, null, false, accuracy);
    }

    public String[] suggestSimilar(String word, int numSug, IndexReader ir, String field, boolean morePopular) throws IOException {
        return this.suggestSimilar(word, numSug, ir, field, morePopular, this.accuracy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] suggestSimilar(String word, int numSug, IndexReader ir, String field, boolean morePopular, float accuracy) throws IOException {
        IndexSearcher indexSearcher = this.obtainSearcher();
        try {
            int goalFreq;
            int lengthWord = word.length();
            int freq = ir != null && field != null ? ir.docFreq(new Term(field, word)) : 0;
            int n = goalFreq = morePopular && ir != null && field != null ? freq : 0;
            if (!morePopular && freq > 0) {
                String[] stringArray = new String[]{word};
                return stringArray;
            }
            BooleanQuery query = new BooleanQuery();
            for (int ng = SpellChecker.getMin(lengthWord); ng <= SpellChecker.getMax(lengthWord); ++ng) {
                String key = "gram" + ng;
                String[] grams = SpellChecker.formGrams(word, ng);
                if (grams.length == 0) continue;
                if (this.bStart > 0.0f) {
                    SpellChecker.add(query, "start" + ng, grams[0], this.bStart);
                }
                if (this.bEnd > 0.0f) {
                    SpellChecker.add(query, "end" + ng, grams[grams.length - 1], this.bEnd);
                }
                for (int i = 0; i < grams.length; ++i) {
                    SpellChecker.add(query, key, grams[i]);
                }
            }
            int maxHits = 10 * numSug;
            ScoreDoc[] hits = indexSearcher.search((Query)query, null, (int)maxHits).scoreDocs;
            SuggestWordQueue sugQueue = new SuggestWordQueue(numSug, this.comparator);
            int stop = Math.min(hits.length, maxHits);
            SuggestWord sugWord = new SuggestWord();
            for (int i = 0; i < stop; ++i) {
                sugWord.string = indexSearcher.doc(hits[i].doc).get(F_WORD);
                if (sugWord.string.equals(word)) continue;
                sugWord.score = this.sd.getDistance(word, sugWord.string);
                if (sugWord.score < accuracy) continue;
                if (ir != null && field != null) {
                    sugWord.freq = ir.docFreq(new Term(field, sugWord.string));
                    if (morePopular && goalFreq > sugWord.freq || sugWord.freq < 1) continue;
                }
                sugQueue.insertWithOverflow(sugWord);
                if (sugQueue.size() == numSug) {
                    accuracy = ((SuggestWord)sugQueue.top()).score;
                }
                sugWord = new SuggestWord();
            }
            String[] list = new String[sugQueue.size()];
            for (int i = sugQueue.size() - 1; i >= 0; --i) {
                list[i] = ((SuggestWord)sugQueue.pop()).string;
            }
            String[] stringArray = list;
            return stringArray;
        }
        finally {
            this.releaseSearcher(indexSearcher);
        }
    }

    private static void add(BooleanQuery q, String name, String value, float boost) {
        TermQuery tq = new TermQuery(new Term(name, value));
        tq.setBoost(boost);
        q.add(new BooleanClause((Query)tq, BooleanClause.Occur.SHOULD));
    }

    private static void add(BooleanQuery q, String name, String value) {
        q.add(new BooleanClause((Query)new TermQuery(new Term(name, value)), BooleanClause.Occur.SHOULD));
    }

    private static String[] formGrams(String text, int ng) {
        int len = text.length();
        String[] res = new String[len - ng + 1];
        for (int i = 0; i < len - ng + 1; ++i) {
            res[i] = text.substring(i, i + ng);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIndex() throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            Directory dir = this.spellIndex;
            IndexWriter writer = new IndexWriter(dir, new IndexWriterConfig(Version.LUCENE_CURRENT, (Analyzer)new WhitespaceAnalyzer(Version.LUCENE_CURRENT)).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
            writer.close();
            this.swapSearcher(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exist(String word) throws IOException {
        IndexSearcher indexSearcher = this.obtainSearcher();
        try {
            boolean bl = indexSearcher.docFreq(F_WORD_TERM.createTerm(word)) > 0;
            return bl;
        }
        finally {
            this.releaseSearcher(indexSearcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void indexDictionary(Dictionary dict, int mergeFactor, int ramMB, boolean optimize) throws IOException {
        Object object = this.modifyCurrentIndexLock;
        synchronized (object) {
            this.ensureOpen();
            Directory dir = this.spellIndex;
            IndexWriter writer = new IndexWriter(dir, new IndexWriterConfig(Version.LUCENE_CURRENT, (Analyzer)new WhitespaceAnalyzer(Version.LUCENE_CURRENT)).setRAMBufferSizeMB((double)ramMB));
            ((TieredMergePolicy)writer.getConfig().getMergePolicy()).setMaxMergeAtOnce(mergeFactor);
            IndexSearcher indexSearcher = this.obtainSearcher();
            ArrayList readers = new ArrayList();
            if (this.searcher.maxDoc() > 0) {
                ReaderUtil.gatherSubReaders(readers, (IndexReader)this.searcher.getIndexReader());
            }
            boolean isEmpty = readers.isEmpty();
            try {
                Iterator<String> iter = dict.getWordsIterator();
                block6: while (iter.hasNext()) {
                    String word = iter.next();
                    int len = word.length();
                    if (len < 3) continue;
                    if (!isEmpty) {
                        Term term = F_WORD_TERM.createTerm(word);
                        for (IndexReader ir : readers) {
                            if (ir.docFreq(term) <= 0) continue;
                            continue block6;
                        }
                    }
                    Document doc = SpellChecker.createDocument(word, SpellChecker.getMin(len), SpellChecker.getMax(len));
                    writer.addDocument(doc);
                }
            }
            finally {
                this.releaseSearcher(indexSearcher);
            }
            if (optimize) {
                writer.optimize();
            }
            writer.close();
            this.swapSearcher(dir);
        }
    }

    public final void indexDictionary(Dictionary dict, int mergeFactor, int ramMB) throws IOException {
        this.indexDictionary(dict, mergeFactor, ramMB, true);
    }

    public final void indexDictionary(Dictionary dict) throws IOException {
        this.indexDictionary(dict, 300, 16);
    }

    private static int getMin(int l) {
        if (l > 5) {
            return 3;
        }
        if (l == 5) {
            return 2;
        }
        return 1;
    }

    private static int getMax(int l) {
        if (l > 5) {
            return 4;
        }
        if (l == 5) {
            return 3;
        }
        return 2;
    }

    private static Document createDocument(String text, int ng1, int ng2) {
        Document doc = new Document();
        Field f = new Field(F_WORD, text, Field.Store.YES, Field.Index.NOT_ANALYZED);
        f.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        f.setOmitNorms(true);
        doc.add((Fieldable)f);
        SpellChecker.addGram(text, doc, ng1, ng2);
        return doc;
    }

    private static void addGram(String text, Document doc, int ng1, int ng2) {
        int len = text.length();
        for (int ng = ng1; ng <= ng2; ++ng) {
            String key = "gram" + ng;
            String end = null;
            for (int i = 0; i < len - ng + 1; ++i) {
                String gram = text.substring(i, i + ng);
                Field ngramField = new Field(key, gram, Field.Store.NO, Field.Index.NOT_ANALYZED);
                ngramField.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS);
                doc.add((Fieldable)ngramField);
                if (i == 0) {
                    Field startField = new Field("start" + ng, gram, Field.Store.NO, Field.Index.NOT_ANALYZED);
                    startField.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
                    startField.setOmitNorms(true);
                    doc.add((Fieldable)startField);
                }
                end = gram;
            }
            if (end == null) continue;
            Field endField = new Field("end" + ng, end, Field.Store.NO, Field.Index.NOT_ANALYZED);
            endField.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            endField.setOmitNorms(true);
            doc.add((Fieldable)endField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher obtainSearcher() {
        Object object = this.searcherLock;
        synchronized (object) {
            this.ensureOpen();
            this.searcher.getIndexReader().incRef();
            return this.searcher;
        }
    }

    private void releaseSearcher(IndexSearcher aSearcher) throws IOException {
        aSearcher.getIndexReader().decRef();
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("Spellchecker has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.searcherLock;
        synchronized (object) {
            this.ensureOpen();
            this.closed = true;
            if (this.searcher != null) {
                this.searcher.close();
            }
            this.searcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapSearcher(Directory dir) throws IOException {
        IndexSearcher indexSearcher = this.createSearcher(dir);
        Object object = this.searcherLock;
        synchronized (object) {
            if (this.closed) {
                indexSearcher.close();
                throw new AlreadyClosedException("Spellchecker has been closed");
            }
            if (this.searcher != null) {
                this.searcher.close();
            }
            this.searcher = indexSearcher;
            this.spellIndex = dir;
        }
    }

    IndexSearcher createSearcher(Directory dir) throws IOException {
        return new IndexSearcher(dir, true);
    }

    boolean isClosed() {
        return this.closed;
    }
}

