/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.search.suggest.fst.Sort;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedTermFreqIteratorWrapper
implements TermFreqIterator {
    private final TermFreqIterator source;
    private File tempInput;
    private File tempSorted;
    private final Sort.ByteSequencesReader reader;
    private boolean done = false;
    private long weight;
    private final BytesRef scratch = new BytesRef();
    private final Comparator<BytesRef> comparator;

    public SortedTermFreqIteratorWrapper(TermFreqIterator source, Comparator<BytesRef> comparator) throws IOException {
        this(source, comparator, false);
    }

    public SortedTermFreqIteratorWrapper(TermFreqIterator source, Comparator<BytesRef> comparator, boolean compareRawBytes) throws IOException {
        this.source = source;
        this.comparator = comparator;
        this.reader = this.sort(compareRawBytes ? comparator : new BytesOnlyComparator(this.comparator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesRef next() throws IOException {
        boolean success = false;
        if (this.done) {
            return null;
        }
        try {
            ByteArrayDataInput input = new ByteArrayDataInput();
            if (this.reader.read(this.scratch)) {
                this.weight = this.decode(this.scratch, input);
                success = true;
                BytesRef bytesRef = this.scratch;
                return bytesRef;
            }
            this.close();
            this.done = true;
            success = true;
            BytesRef bytesRef = null;
            return bytesRef;
        }
        finally {
            if (!success) {
                this.done = true;
                this.close();
            }
        }
    }

    public Comparator<BytesRef> getComparator() {
        return this.comparator;
    }

    @Override
    public long weight() {
        return this.weight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sort.ByteSequencesReader sort(Comparator<BytesRef> comparator) throws IOException {
        Sort.ByteSequencesReader byteSequencesReader;
        block12: {
            Sort.ByteSequencesWriter writer;
            block11: {
                String prefix = this.getClass().getSimpleName();
                File directory = Sort.defaultTempDir();
                this.tempInput = File.createTempFile(prefix, ".input", directory);
                this.tempSorted = File.createTempFile(prefix, ".sorted", directory);
                writer = new Sort.ByteSequencesWriter(this.tempInput);
                boolean success = false;
                try {
                    BytesRef spare;
                    byte[] buffer = new byte[]{};
                    ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
                    while ((spare = this.source.next()) != null) {
                        this.encode(writer, output, buffer, spare, this.source.weight());
                    }
                    writer.close();
                    new Sort(comparator).sort(this.tempInput, this.tempSorted);
                    Sort.ByteSequencesReader reader = new Sort.ByteSequencesReader(this.tempSorted);
                    success = true;
                    byteSequencesReader = reader;
                    if (!success) break block11;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{writer});
                    } else {
                        try {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer});
                        }
                        finally {
                            this.close();
                        }
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{writer});
                break block12;
            }
            try {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer});
            }
            finally {
                this.close();
            }
        }
        return byteSequencesReader;
    }

    private void close() throws IOException {
        if (this.tempInput != null) {
            this.tempInput.delete();
        }
        if (this.tempSorted != null) {
            this.tempSorted.delete();
        }
        IOUtils.close((Closeable[])new Closeable[]{this.reader});
    }

    protected void encode(Sort.ByteSequencesWriter writer, ByteArrayDataOutput output, byte[] buffer, BytesRef spare, long weight) throws IOException {
        if (spare.length + 8 >= buffer.length) {
            buffer = ArrayUtil.grow((byte[])buffer, (int)(spare.length + 8));
        }
        output.reset(buffer);
        output.writeBytes(spare.bytes, spare.offset, spare.length);
        output.writeLong(weight);
        writer.write(buffer, 0, output.getPosition());
    }

    protected long decode(BytesRef scratch, ByteArrayDataInput tmpInput) {
        tmpInput.reset(scratch.bytes);
        tmpInput.skipBytes(scratch.length - 8);
        scratch.length -= 8;
        return tmpInput.readLong();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BytesOnlyComparator
    implements Comparator<BytesRef> {
        final Comparator<BytesRef> other;
        private final BytesRef leftScratch = new BytesRef();
        private final BytesRef rightScratch = new BytesRef();

        public BytesOnlyComparator(Comparator<BytesRef> other) {
            this.other = other;
        }

        @Override
        public int compare(BytesRef left, BytesRef right) {
            this.wrap(this.leftScratch, left);
            this.wrap(this.rightScratch, right);
            return this.other.compare(this.leftScratch, this.rightScratch);
        }

        private void wrap(BytesRef wrapper, BytesRef source) {
            wrapper.bytes = source.bytes;
            wrapper.offset = source.offset;
            wrapper.length = source.length - 8;
        }
    }
}

