/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.TermFreqIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.StringHelper;

public class LuceneDictionary
implements Dictionary {
    private IndexReader reader;
    private String field;

    public LuceneDictionary(IndexReader reader, String field) {
        this.reader = reader;
        this.field = StringHelper.intern((String)field);
    }

    public final BytesRefIterator getWordsIterator() throws IOException {
        return new TermIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class TermIterator
    implements TermFreqIterator {
        private final BytesRef spare = new BytesRef();
        private final TermEnum termsEnum;
        private long freq;
        private final Comparator<BytesRef> comp;

        TermIterator() throws IOException {
            this.termsEnum = LuceneDictionary.this.reader.terms(new Term(LuceneDictionary.this.field, ""));
            Term term = this.termsEnum.term();
            this.comp = term == null || term.field() != LuceneDictionary.this.field ? null : BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        @Override
        public long weight() {
            return this.freq;
        }

        public BytesRef next() throws IOException {
            if (this.termsEnum != null) {
                Term actualTerm = this.termsEnum.term();
                if (actualTerm == null || actualTerm.field() != LuceneDictionary.this.field) {
                    return null;
                }
                this.freq = this.termsEnum.docFreq();
                this.spare.copyChars((CharSequence)actualTerm.text());
                this.termsEnum.next();
                return this.spare;
            }
            return null;
        }

        public Comparator<BytesRef> getComparator() {
            return this.comp;
        }
    }
}

