/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SorterTemplate;

public final class BytesRefList {
    private final ByteBlockPool pool;
    private int[] offsets = new int[1];
    private int lastElement = 0;
    private int currentOffset = 0;
    private final Counter bytesUsed = Counter.newCounter((boolean)false);

    public BytesRefList() {
        this.pool = new ByteBlockPool((ByteBlockPool.Allocator)new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed));
        this.pool.nextBuffer();
        this.bytesUsed.addAndGet((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 4));
    }

    public void clear() {
        this.lastElement = 0;
        this.currentOffset = 0;
        Arrays.fill(this.offsets, 0);
        this.pool.reset();
    }

    public int append(BytesRef bytes) {
        if (this.lastElement >= this.offsets.length) {
            int oldLen = this.offsets.length;
            this.offsets = ArrayUtil.grow((int[])this.offsets, (int)(this.offsets.length + 1));
            this.bytesUsed.addAndGet((long)((this.offsets.length - oldLen) * 4));
        }
        this.pool.copy(bytes);
        this.offsets[this.lastElement++] = this.currentOffset;
        this.currentOffset += bytes.length;
        return this.lastElement;
    }

    public int size() {
        return this.lastElement;
    }

    public BytesRef get(BytesRef spare, int ord) {
        if (this.lastElement > ord) {
            spare.offset = this.offsets[ord];
            spare.length = ord == this.lastElement - 1 ? this.currentOffset - spare.offset : this.offsets[ord + 1] - spare.offset;
            this.pool.copyFrom(spare);
            return spare;
        }
        throw new IndexOutOfBoundsException("index " + ord + " must be less than the size: " + this.lastElement);
    }

    public long bytesUsed() {
        return this.bytesUsed.get();
    }

    private int[] sort(final Comparator<BytesRef> comp) {
        final int[] orderedEntries = new int[this.size()];
        for (int i = 0; i < orderedEntries.length; ++i) {
            orderedEntries[i] = i;
        }
        new SorterTemplate(){
            private final BytesRef pivot = new BytesRef();
            private final BytesRef scratch1 = new BytesRef();
            private final BytesRef scratch2 = new BytesRef();

            protected void swap(int i, int j) {
                int o = orderedEntries[i];
                orderedEntries[i] = orderedEntries[j];
                orderedEntries[j] = o;
            }

            protected int compare(int i, int j) {
                int ord1 = orderedEntries[i];
                int ord2 = orderedEntries[j];
                return comp.compare(BytesRefList.this.get(this.scratch1, ord1), BytesRefList.this.get(this.scratch2, ord2));
            }

            protected void setPivot(int i) {
                int ord = orderedEntries[i];
                BytesRefList.this.get(this.pivot, ord);
            }

            protected int comparePivot(int j) {
                int ord = orderedEntries[j];
                return comp.compare(this.pivot, BytesRefList.this.get(this.scratch2, ord));
            }
        }.quickSort(0, this.size() - 1);
        return orderedEntries;
    }

    public BytesRefIterator iterator() {
        return this.iterator(null);
    }

    public BytesRefIterator iterator(final Comparator<BytesRef> comp) {
        final BytesRef spare = new BytesRef();
        final int size = this.size();
        final int[] ords = comp == null ? null : this.sort(comp);
        return new BytesRefIterator(){
            int pos = 0;

            public BytesRef next() throws IOException {
                if (this.pos < size) {
                    int n;
                    if (ords == null) {
                        int n2 = this.pos;
                        n = n2;
                        this.pos = n2 + 1;
                    } else {
                        n = ords[this.pos++];
                    }
                    return BytesRefList.this.get(spare, n);
                }
                return null;
            }

            public Comparator<BytesRef> getComparator() {
                return comp;
            }
        };
    }
}

