/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.document;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.suggest.analyzing.FSTUtil;
import org.apache.lucene.search.suggest.document.TopSuggestDocsCollector;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

final class NRTSuggester
implements Accountable {
    private final FST<PairOutputs.Pair<Long, BytesRef>> fst;
    private final int maxAnalyzedPathsPerOutput;
    private final int payloadSep;
    private final int endByte;
    private static final long MAX_TOP_N_QUEUE_SIZE = 1000L;

    private NRTSuggester(FST<PairOutputs.Pair<Long, BytesRef>> fst, int maxAnalyzedPathsPerOutput, int payloadSep, int endByte) {
        this.fst = fst;
        this.maxAnalyzedPathsPerOutput = maxAnalyzedPathsPerOutput;
        this.payloadSep = payloadSep;
        this.endByte = endByte;
    }

    public long ramBytesUsed() {
        return this.fst == null ? 0L : this.fst.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    private static Comparator<PairOutputs.Pair<Long, BytesRef>> getComparator() {
        return new Comparator<PairOutputs.Pair<Long, BytesRef>>(){

            @Override
            public int compare(PairOutputs.Pair<Long, BytesRef> o1, PairOutputs.Pair<Long, BytesRef> o2) {
                return Long.compare((Long)o1.output1, (Long)o2.output1);
            }
        };
    }

    public void lookup(LeafReader reader, Automaton automaton, int num, DocIdSet filter, final TopSuggestDocsCollector collector) {
        Bits filterDocs;
        try {
            if (filter != null) {
                if (filter.iterator() == null) {
                    return;
                }
                if (filter.bits() == null) {
                    throw new IllegalArgumentException("DocIDSet does not provide random access interface");
                }
                filterDocs = filter.bits();
            } else {
                filterDocs = null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int queueSize = this.getMaxTopNSearcherQueueSize(num, reader, filterDocs != null);
        if (queueSize == -1) {
            return;
        }
        final Bits liveDocs = reader.getLiveDocs();
        try {
            List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths = FSTUtil.intersectPrefixPaths(automaton, this.fst);
            Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>> searcher = new Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>>(this.fst, num, queueSize, NRTSuggester.getComparator()){
                private final CharsRefBuilder spare;
                {
                    super(x0, x1, x2, x3);
                    this.spare = new CharsRefBuilder();
                }

                protected boolean acceptResult(IntsRef input, PairOutputs.Pair<Long, BytesRef> output) {
                    int payloadSepIndex = PayLoadProcessor.parseSurfaceForm((BytesRef)output.output2, NRTSuggester.this.payloadSep, this.spare);
                    int docID = PayLoadProcessor.parseDocID((BytesRef)output.output2, payloadSepIndex);
                    if (filterDocs == null && liveDocs != null && !liveDocs.get(docID)) {
                        return false;
                    }
                    if (filterDocs != null && !filterDocs.get(docID)) {
                        return false;
                    }
                    try {
                        collector.collect(docID, (CharSequence)this.spare.toCharsRef(), NRTSuggester.decode((Long)output.output1));
                        return true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            for (FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>> path : prefixPaths) {
                searcher.addStartPaths(path.fstNode, path.output, false, path.input);
            }
            try {
                Util.TopResults search = searcher.search();
            }
            catch (CollectionTerminatedException e) {}
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }

    private int getMaxTopNSearcherQueueSize(int num, LeafReader reader, boolean filterEnabled) {
        double liveDocsRatio = NRTSuggester.calculateLiveDocRatio(reader.numDocs(), reader.maxDoc());
        if (liveDocsRatio == -1.0) {
            return -1;
        }
        long maxQueueSize = num * this.maxAnalyzedPathsPerOutput;
        assert (liveDocsRatio <= 1.0);
        maxQueueSize = (long)((double)maxQueueSize / liveDocsRatio);
        if (filterEnabled) {
            maxQueueSize += (long)(reader.numDocs() / 2);
        }
        return (int)Math.min(1000L, maxQueueSize);
    }

    private static double calculateLiveDocRatio(int numDocs, int maxDocs) {
        return numDocs > 0 ? (double)numDocs / (double)maxDocs : -1.0;
    }

    public static NRTSuggester load(IndexInput input) throws IOException {
        FST fst = new FST((DataInput)input, (Outputs)new PairOutputs((Outputs)PositiveIntOutputs.getSingleton(), (Outputs)ByteSequenceOutputs.getSingleton()));
        int maxAnalyzedPathsPerOutput = input.readVInt();
        int endByte = input.readVInt();
        int payloadSep = input.readVInt();
        return new NRTSuggester((FST<PairOutputs.Pair<Long, BytesRef>>)fst, maxAnalyzedPathsPerOutput, payloadSep, endByte);
    }

    static long encode(long input) {
        if (input < 0L) {
            throw new UnsupportedOperationException("cannot encode value: " + input);
        }
        return Long.MAX_VALUE - input;
    }

    static long decode(long output) {
        return Long.MAX_VALUE - output;
    }

    static final class PayLoadProcessor {
        private static final int MAX_DOC_ID_LEN_WITH_SEP = 6;

        PayLoadProcessor() {
        }

        static int parseSurfaceForm(BytesRef output, int payloadSep, CharsRefBuilder spare) {
            int surfaceFormLen = -1;
            for (int i = 0; i < output.length; ++i) {
                if (output.bytes[output.offset + i] != payloadSep) continue;
                surfaceFormLen = i;
                break;
            }
            assert (surfaceFormLen != -1) : "no payloadSep found, unable to determine surface form";
            spare.copyUTF8Bytes(output.bytes, output.offset, surfaceFormLen);
            return surfaceFormLen;
        }

        static int parseDocID(BytesRef output, int payloadSepIndex) {
            assert (payloadSepIndex != -1) : "payload sep index can not be -1";
            ByteArrayDataInput input = new ByteArrayDataInput(output.bytes, payloadSepIndex + output.offset + 1, output.length - (payloadSepIndex + output.offset));
            return input.readVInt();
        }

        static BytesRef make(BytesRef surface, int docID, int payloadSep) throws IOException {
            int len = surface.length + 6;
            byte[] buffer = new byte[len];
            ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
            output.writeBytes(surface.bytes, surface.length - surface.offset);
            output.writeByte((byte)payloadSep);
            output.writeVInt(docID);
            return new BytesRef(buffer, 0, output.getPosition());
        }
    }
}

