/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.tests.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.tests.index.ForceMergePolicy;
import org.apache.lucene.tests.index.MismatchedCodecReader;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.Version;
import org.junit.Before;

public abstract class BaseKnnVectorsFormatTestCase
extends BaseIndexFileFormatTestCase {
    private VectorEncoding vectorEncoding;
    private VectorSimilarityFunction similarityFunction;

    @Before
    public void init() {
        this.vectorEncoding = this.randomVectorEncoding();
        this.similarityFunction = this.randomSimilarity();
    }

    @Override
    protected void addRandomFields(Document doc) {
        switch (this.vectorEncoding) {
            case BYTE: {
                doc.add((IndexableField)new KnnByteVectorField("v2", BaseKnnVectorsFormatTestCase.randomVector8(30), this.similarityFunction));
                break;
            }
            case FLOAT32: {
                doc.add((IndexableField)new KnnFloatVectorField("v2", BaseKnnVectorsFormatTestCase.randomNormalizedVector(30), this.similarityFunction));
            }
        }
    }

    @Override
    protected boolean mergeIsStable() {
        return false;
    }

    private int getVectorsMaxDimensions(String fieldName) {
        return Codec.getDefault().knnVectorsFormat().getMaxDimensions(fieldName);
    }

    public void testFieldConstructor() {
        float[] v = new float[1];
        KnnFloatVectorField field = new KnnFloatVectorField("f", v);
        BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)field.fieldType().vectorDimension());
        BaseKnnVectorsFormatTestCase.assertEquals((Object)VectorSimilarityFunction.EUCLIDEAN, (Object)field.fieldType().vectorSimilarityFunction());
        BaseKnnVectorsFormatTestCase.assertSame((Object)v, (Object)field.vectorValue());
    }

    public void testFieldConstructorExceptions() {
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> new KnnFloatVectorField(null, new float[1]));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> new KnnFloatVectorField("f", null));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> new KnnFloatVectorField("f", new float[1], (VectorSimilarityFunction)null));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> new KnnFloatVectorField("f", new float[0]));
    }

    public void testFieldSetValue() {
        KnnFloatVectorField field = new KnnFloatVectorField("f", new float[1]);
        float[] v1 = new float[1];
        field.setVectorValue(v1);
        BaseKnnVectorsFormatTestCase.assertSame((Object)v1, (Object)field.vectorValue());
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> field.setVectorValue(new float[2]));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> field.setVectorValue(null));
    }

    public void testIllegalDimChangeTwoDocs() throws Exception {
        String errMsg;
        IllegalArgumentException expected;
        Document doc2;
        Document doc;
        IndexWriter w;
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
            try {
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                doc2 = new Document();
                doc2.add((IndexableField)new KnnFloatVectorField("f", new float[6], VectorSimilarityFunction.DOT_PRODUCT));
                expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc2));
                errMsg = "Inconsistency of field data structures across documents for field [f] of doc [1]. vector dimension: expected '4', but it has '6'.";
                BaseKnnVectorsFormatTestCase.assertEquals((Object)errMsg, (Object)expected.getMessage());
            }
            finally {
                w.close();
            }
        }
        dir = BaseKnnVectorsFormatTestCase.newDirectory();
        try {
            w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
            try {
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                w.commit();
                doc2 = new Document();
                doc2.add((IndexableField)new KnnFloatVectorField("f", new float[6], VectorSimilarityFunction.DOT_PRODUCT));
                expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc2));
                errMsg = "cannot change field \"f\" from vector dimension=4, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=6, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT";
                BaseKnnVectorsFormatTestCase.assertEquals((Object)errMsg, (Object)expected.getMessage());
            }
            finally {
                w.close();
            }
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    public void testIllegalSimilarityFunctionChange() throws Exception {
        String errMsg;
        IllegalArgumentException expected;
        Document doc2;
        Document doc;
        IndexWriter w;
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
            try {
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                doc2 = new Document();
                doc2.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc2));
                errMsg = "Inconsistency of field data structures across documents for field [f] of doc [1]. vector similarity function: expected 'DOT_PRODUCT', but it has 'EUCLIDEAN'.";
                BaseKnnVectorsFormatTestCase.assertEquals((Object)errMsg, (Object)expected.getMessage());
            }
            finally {
                w.close();
            }
        }
        dir = BaseKnnVectorsFormatTestCase.newDirectory();
        try {
            w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
            try {
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                w.commit();
                doc2 = new Document();
                doc2.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc2));
                errMsg = "cannot change field \"f\" from vector dimension=4, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=4, vector encoding=FLOAT32, vector similarity function=EUCLIDEAN";
                BaseKnnVectorsFormatTestCase.assertEquals((Object)errMsg, (Object)expected.getMessage());
            }
            finally {
                w.close();
            }
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
    }

    public void testIllegalDimChangeTwoWriters() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc2 = new Document();
                doc2.add((IndexableField)new KnnFloatVectorField("f", new float[2], VectorSimilarityFunction.DOT_PRODUCT));
                IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w2.addDocument((Iterable)doc2));
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=4, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=2, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
            }
        }
    }

    public void testMergingWithDifferentKnnFields() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            IndexWriterConfig iwc = new IndexWriterConfig();
            Codec codec = this.getCodec();
            KnnVectorsFormat knnVectorsFormat = codec.knnVectorsFormat();
            if (knnVectorsFormat instanceof PerFieldKnnVectorsFormat) {
                PerFieldKnnVectorsFormat perFieldKnnVectorsFormat = (PerFieldKnnVectorsFormat)knnVectorsFormat;
                final KnnVectorsFormat format = perFieldKnnVectorsFormat.getKnnVectorsFormatForField("field");
                iwc.setCodec((Codec)new FilterCodec(this, codec.getName(), codec){

                    public KnnVectorsFormat knnVectorsFormat() {
                        return format;
                    }
                });
            }
            TestMergeScheduler mergeScheduler = new TestMergeScheduler();
            iwc.setMergeScheduler((MergeScheduler)mergeScheduler);
            iwc.setMergePolicy((MergePolicy)new ForceMergePolicy(iwc.getMergePolicy()));
            try (IndexWriter writer = new IndexWriter((Directory)dir, iwc);){
                Document doc;
                int i;
                for (i = 0; i < 10; ++i) {
                    doc = new Document();
                    doc.add((IndexableField)new KnnFloatVectorField("field", new float[]{i, i + 1, i + 2, i + 3}));
                    writer.addDocument((Iterable)doc);
                }
                writer.commit();
                for (i = 0; i < 10; ++i) {
                    doc = new Document();
                    doc.add((IndexableField)new KnnFloatVectorField("otherVector", new float[]{i, i, i, i}));
                    writer.addDocument((Iterable)doc);
                }
                writer.commit();
                writer.forceMerge(1);
                BaseKnnVectorsFormatTestCase.assertNull((Object)mergeScheduler.ex.get());
            }
        }
    }

    public void testMergingWithDifferentByteKnnFields() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            IndexWriterConfig iwc = new IndexWriterConfig();
            Codec codec = this.getCodec();
            KnnVectorsFormat knnVectorsFormat = codec.knnVectorsFormat();
            if (knnVectorsFormat instanceof PerFieldKnnVectorsFormat) {
                PerFieldKnnVectorsFormat perFieldKnnVectorsFormat = (PerFieldKnnVectorsFormat)knnVectorsFormat;
                final KnnVectorsFormat format = perFieldKnnVectorsFormat.getKnnVectorsFormatForField("field");
                iwc.setCodec((Codec)new FilterCodec(this, codec.getName(), codec){

                    public KnnVectorsFormat knnVectorsFormat() {
                        return format;
                    }
                });
            }
            TestMergeScheduler mergeScheduler = new TestMergeScheduler();
            iwc.setMergeScheduler((MergeScheduler)mergeScheduler);
            iwc.setMergePolicy((MergePolicy)new ForceMergePolicy(iwc.getMergePolicy()));
            try (IndexWriter writer = new IndexWriter((Directory)dir, iwc);){
                Document doc;
                int i;
                for (i = 0; i < 10; ++i) {
                    doc = new Document();
                    doc.add((IndexableField)new KnnByteVectorField("field", new byte[]{(byte)i, (byte)i, (byte)i, (byte)i}));
                    writer.addDocument((Iterable)doc);
                }
                writer.commit();
                for (i = 0; i < 10; ++i) {
                    doc = new Document();
                    doc.add((IndexableField)new KnnByteVectorField("otherVector", new byte[]{(byte)i, (byte)i, (byte)i, (byte)i}));
                    writer.addDocument((Iterable)doc);
                }
                writer.commit();
                writer.forceMerge(1);
                BaseKnnVectorsFormatTestCase.assertNull((Object)mergeScheduler.ex.get());
            }
        }
    }

    public void testWriterRamEstimate() throws Exception {
        FieldInfos fieldInfos = new FieldInfos(new FieldInfo[0]);
        BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
        Codec codec = Codec.getDefault();
        SegmentInfo si = new SegmentInfo((Directory)dir, Version.LATEST, Version.LATEST, "0", 10000, false, false, codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap(), null);
        SegmentWriteState state = new SegmentWriteState(InfoStream.getDefault(), (Directory)dir, si, fieldInfos, null, BaseKnnVectorsFormatTestCase.newIOContext(BaseKnnVectorsFormatTestCase.random()));
        KnnVectorsFormat format = codec.knnVectorsFormat();
        try (KnnVectorsWriter writer = format.fieldsWriter(state);){
            long ramBytesUsed = writer.ramBytesUsed();
            int dim = BaseKnnVectorsFormatTestCase.random().nextInt(64) + 1;
            if (dim % 2 == 1) {
                ++dim;
            }
            int numDocs = BaseKnnVectorsFormatTestCase.atLeast(100);
            KnnFieldVectorsWriter fieldWriter = writer.addField(new FieldInfo("fieldA", 0, false, false, false, IndexOptions.NONE, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Map.of(), 0, 0, 0, dim, VectorEncoding.FLOAT32, VectorSimilarityFunction.DOT_PRODUCT, false, false));
            for (int i = 0; i < numDocs; ++i) {
                fieldWriter.addValue(i, (Object)BaseKnnVectorsFormatTestCase.randomVector(dim));
            }
            long ramBytesUsed2 = writer.ramBytesUsed();
            BaseKnnVectorsFormatTestCase.assertTrue((ramBytesUsed2 > ramBytesUsed ? 1 : 0) != 0);
            BaseKnnVectorsFormatTestCase.assertTrue((ramBytesUsed2 > (long)dim * (long)numDocs * 4L ? 1 : 0) != 0);
        }
        dir.close();
    }

    public void testIllegalSimilarityFunctionChangeTwoWriters() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc2 = new Document();
                doc2.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w2.addDocument((Iterable)doc2));
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=4, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=4, vector encoding=FLOAT32, vector similarity function=EUCLIDEAN", (Object)expected.getMessage());
            }
        }
    }

    public void testAddIndexesDirectory0() throws Exception {
        String fieldName = "field";
        Document doc = new Document();
        doc.add((IndexableField)new KnnFloatVectorField(fieldName, new float[4], VectorSimilarityFunction.DOT_PRODUCT));
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                w2.addIndexes(new Directory[]{dir});
                w2.forceMerge(1);
                try (DirectoryReader reader = DirectoryReader.open((IndexWriter)w2);){
                    LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                    FloatVectorValues vectorValues = r.getFloatVectorValues(fieldName);
                    KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
                    BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)iterator.nextDoc());
                    BaseKnnVectorsFormatTestCase.assertEquals((float)0.0f, (float)vectorValues.vectorValue(0)[0], (float)0.0f);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)iterator.nextDoc());
                }
            }
        }
    }

    public void testAddIndexesDirectory1() throws Exception {
        String fieldName = "field";
        Document doc = new Document();
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                w.addDocument((Iterable)doc);
            }
            doc.add((IndexableField)new KnnFloatVectorField(fieldName, new float[4], VectorSimilarityFunction.DOT_PRODUCT));
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                w2.addDocument((Iterable)doc);
                w2.addIndexes(new Directory[]{dir});
                w2.forceMerge(1);
                try (DirectoryReader reader = DirectoryReader.open((IndexWriter)w2);){
                    LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                    FloatVectorValues vectorValues = r.getFloatVectorValues(fieldName);
                    KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
                    BaseKnnVectorsFormatTestCase.assertNotEquals((long)Integer.MAX_VALUE, (long)iterator.nextDoc());
                    BaseKnnVectorsFormatTestCase.assertEquals((float)0.0f, (float)vectorValues.vectorValue(iterator.index())[0], (float)0.0f);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)iterator.nextDoc());
                }
            }
        }
    }

    public void testAddIndexesDirectory01() throws Exception {
        String fieldName = "field";
        float[] vector = new float[2];
        Document doc = new Document();
        doc.add((IndexableField)new KnnFloatVectorField(fieldName, vector, VectorSimilarityFunction.DOT_PRODUCT));
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                vector[0] = 1.0f;
                vector[1] = 1.0f;
                w2.addDocument((Iterable)doc);
                w2.addIndexes(new Directory[]{dir});
                w2.forceMerge(1);
                try (DirectoryReader reader = DirectoryReader.open((IndexWriter)w2);){
                    LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                    FloatVectorValues vectorValues = r.getFloatVectorValues(fieldName);
                    KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
                    BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)iterator.nextDoc());
                    float value = vectorValues.vectorValue(0)[0];
                    BaseKnnVectorsFormatTestCase.assertTrue((value == 0.0f || value == 1.0f ? 1 : 0) != 0);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)iterator.nextDoc());
                    BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)(value += vectorValues.vectorValue(1)[0]), (float)0.0f);
                }
            }
        }
    }

    public void testIllegalDimChangeViaAddIndexesDirectory() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[6], VectorSimilarityFunction.DOT_PRODUCT));
                w2.addDocument((Iterable)doc);
                IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> BaseKnnVectorsFormatTestCase.lambda$testIllegalDimChangeViaAddIndexesDirectory$12(w2, (Directory)dir));
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=6, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=4, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
            }
        }
    }

    public void testIllegalSimilarityFunctionChangeViaAddIndexesDirectory() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                w2.addDocument((Iterable)doc);
                IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> BaseKnnVectorsFormatTestCase.lambda$testIllegalSimilarityFunctionChangeViaAddIndexesDirectory$13(w2, (Directory)dir));
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=4, vector encoding=FLOAT32, vector similarity function=EUCLIDEAN to inconsistent vector dimension=4, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
            }
        }
    }

    public void testIllegalDimChangeViaAddIndexesCodecReader() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[6], VectorSimilarityFunction.DOT_PRODUCT));
                w2.addDocument((Iterable)doc);
                try (DirectoryReader r = DirectoryReader.open((Directory)dir);){
                    IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w2.addIndexes(new CodecReader[]{(CodecReader)BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)r)}));
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=6, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=4, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
                }
            }
        }
    }

    public void testIllegalSimilarityFunctionChangeViaAddIndexesCodecReader() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                w2.addDocument((Iterable)doc);
                try (DirectoryReader r = DirectoryReader.open((Directory)dir);){
                    IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w2.addIndexes(new CodecReader[]{(CodecReader)BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)r)}));
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=4, vector encoding=FLOAT32, vector similarity function=EUCLIDEAN to inconsistent vector dimension=4, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
                }
            }
        }
    }

    public void testIllegalDimChangeViaAddIndexesSlowCodecReader() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[6], VectorSimilarityFunction.DOT_PRODUCT));
                w2.addDocument((Iterable)doc);
                try (DirectoryReader r = DirectoryReader.open((Directory)dir);){
                    IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> TestUtil.addIndexesSlowly(w2, r));
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=6, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT to inconsistent vector dimension=4, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
                }
            }
        }
    }

    public void testIllegalSimilarityFunctionChangeViaAddIndexesSlowCodecReader() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            try (IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.EUCLIDEAN));
                w2.addDocument((Iterable)doc);
                try (DirectoryReader r = DirectoryReader.open((Directory)dir);){
                    IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> TestUtil.addIndexesSlowly(w2, r));
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot change field \"f\" from vector dimension=4, vector encoding=FLOAT32, vector similarity function=EUCLIDEAN to inconsistent vector dimension=4, vector encoding=FLOAT32, vector similarity function=DOT_PRODUCT", (Object)expected.getMessage());
                }
            }
        }
    }

    public void testIllegalMultipleValues() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
            doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
            IllegalArgumentException expected = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc));
            BaseKnnVectorsFormatTestCase.assertEquals((Object)"VectorValuesField \"f\" appears more than once in this document (only one value is allowed per field)", (Object)expected.getMessage());
        }
    }

    public void testIllegalDimensionTooLarge() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            doc.add((IndexableField)new KnnFloatVectorField("f", new float[this.getVectorsMaxDimensions("f") + 1], VectorSimilarityFunction.DOT_PRODUCT));
            Exception exc = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc));
            BaseKnnVectorsFormatTestCase.assertTrue((boolean)exc.getMessage().contains("vector's dimensions must be <= [" + this.getVectorsMaxDimensions("f") + "]"));
            Document doc2 = new Document();
            doc2.add((IndexableField)new KnnFloatVectorField("f", new float[2], VectorSimilarityFunction.DOT_PRODUCT));
            w.addDocument((Iterable)doc2);
            Document doc3 = new Document();
            doc3.add((IndexableField)new KnnFloatVectorField("f", new float[this.getVectorsMaxDimensions("f") + 1], VectorSimilarityFunction.DOT_PRODUCT));
            exc = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc3));
            BaseKnnVectorsFormatTestCase.assertTrue((exc.getMessage().contains("Inconsistency of field data structures across documents for field [f]") || exc.getMessage().contains("vector's dimensions must be <= [" + this.getVectorsMaxDimensions("f") + "]") ? 1 : 0) != 0);
            w.flush();
            Document doc4 = new Document();
            doc4.add((IndexableField)new KnnFloatVectorField("f", new float[this.getVectorsMaxDimensions("f") + 1], VectorSimilarityFunction.DOT_PRODUCT));
            exc = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> w.addDocument((Iterable)doc4));
            BaseKnnVectorsFormatTestCase.assertTrue((boolean)exc.getMessage().contains("vector's dimensions must be <= [" + this.getVectorsMaxDimensions("f") + "]"));
        }
    }

    public void testIllegalEmptyVector() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            Exception e = BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> doc.add((IndexableField)new KnnFloatVectorField("f", new float[0], VectorSimilarityFunction.EUCLIDEAN)));
            BaseKnnVectorsFormatTestCase.assertEquals((Object)"cannot index an empty vector", (Object)e.getMessage());
            Document doc2 = new Document();
            doc2.add((IndexableField)new KnnFloatVectorField("f", new float[2], VectorSimilarityFunction.EUCLIDEAN));
            w.addDocument((Iterable)doc2);
        }
    }

    public void testDifferentCodecs1() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
            iwc.setCodec(Codec.forName((String)"SimpleText"));
            try (IndexWriter w = new IndexWriter((Directory)dir, iwc);){
                Document doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                w.forceMerge(1);
            }
        }
    }

    public void testDifferentCodecs2() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        iwc.setCodec(Codec.forName((String)"SimpleText"));
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            Document doc;
            try (IndexWriter w = new IndexWriter((Directory)dir, iwc);){
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
            }
            w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
            try {
                doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("f", new float[4], VectorSimilarityFunction.DOT_PRODUCT));
                w.addDocument((Iterable)doc);
                w.forceMerge(1);
            }
            finally {
                w.close();
            }
        }
    }

    public void testInvalidKnnVectorFieldUsage() {
        KnnFloatVectorField field = new KnnFloatVectorField("field", new float[2], VectorSimilarityFunction.EUCLIDEAN);
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> field.setIntValue(14));
        BaseKnnVectorsFormatTestCase.expectThrows(IllegalArgumentException.class, () -> field.setVectorValue(new float[1]));
        BaseKnnVectorsFormatTestCase.assertNull((Object)field.numericValue());
    }

    public void testDeleteAllVectorDocs() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
            doc.add((IndexableField)new KnnFloatVectorField("v", new float[]{2.0f, 3.0f, 5.0f, 6.0f}, VectorSimilarityFunction.DOT_PRODUCT));
            w.addDocument((Iterable)doc);
            w.addDocument((Iterable)new Document());
            w.commit();
            try (DirectoryReader r = DirectoryReader.open((IndexWriter)w);){
                FloatVectorValues values = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)r).getFloatVectorValues("v");
                BaseKnnVectorsFormatTestCase.assertNotNull((Object)values);
                BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)values.size());
            }
            w.deleteDocuments(new Term[]{new Term("id", "0")});
            w.forceMerge(1);
            r = DirectoryReader.open((IndexWriter)w);
            try {
                LeafReader leafReader = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)r);
                FloatVectorValues values = leafReader.getFloatVectorValues("v");
                BaseKnnVectorsFormatTestCase.assertNotNull((Object)values);
                BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)values.size());
                TopDocs results = leafReader.searchNearestVectors("v", BaseKnnVectorsFormatTestCase.randomNormalizedVector(4), 1, leafReader.getLiveDocs(), Integer.MAX_VALUE);
                BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)results.scoreDocs.length);
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
    }

    public void testKnnVectorFieldMissingFromOneSegment() throws Exception {
        try (FSDirectory dir = FSDirectory.open((Path)BaseKnnVectorsFormatTestCase.createTempDir());
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc = new Document();
            doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
            doc.add((IndexableField)new KnnFloatVectorField("v0", new float[]{2.0f, 3.0f, 5.0f, 6.0f}, VectorSimilarityFunction.DOT_PRODUCT));
            w.addDocument((Iterable)doc);
            w.commit();
            doc = new Document();
            doc.add((IndexableField)new KnnFloatVectorField("v1", new float[]{2.0f, 3.0f, 5.0f, 6.0f}, VectorSimilarityFunction.DOT_PRODUCT));
            w.addDocument((Iterable)doc);
            w.forceMerge(1);
        }
    }

    public void testSparseVectors() throws Exception {
        int numDocs = BaseKnnVectorsFormatTestCase.atLeast(1000);
        int numFields = TestUtil.nextInt(BaseKnnVectorsFormatTestCase.random(), 1, 10);
        int[] fieldDocCounts = new int[numFields];
        double[] fieldTotals = new double[numFields];
        int[] fieldDims = new int[numFields];
        VectorSimilarityFunction[] fieldSimilarityFunctions = new VectorSimilarityFunction[numFields];
        VectorEncoding[] fieldVectorEncodings = new VectorEncoding[numFields];
        for (int i = 0; i < numFields; ++i) {
            fieldDims[i] = BaseKnnVectorsFormatTestCase.random().nextInt(20) + 1;
            if (fieldDims[i] % 2 != 0) {
                int n = i;
                fieldDims[n] = fieldDims[n] + 1;
            }
            fieldSimilarityFunctions[i] = this.randomSimilarity();
            fieldVectorEncodings[i] = this.randomVectorEncoding();
        }
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             RandomIndexWriter w = new RandomIndexWriter(BaseKnnVectorsFormatTestCase.random(), (Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            for (int i = 0; i < numDocs; ++i) {
                Document doc = new Document();
                for (int field = 0; field < numFields; ++field) {
                    String fieldName = "int" + field;
                    if (BaseKnnVectorsFormatTestCase.random().nextInt(100) != 17) continue;
                    switch (fieldVectorEncodings[field]) {
                        case BYTE: {
                            byte[] b = BaseKnnVectorsFormatTestCase.randomVector8(fieldDims[field]);
                            doc.add((IndexableField)new KnnByteVectorField(fieldName, b, fieldSimilarityFunctions[field]));
                            int n = field;
                            fieldTotals[n] = fieldTotals[n] + (double)b[0];
                            break;
                        }
                        case FLOAT32: {
                            float[] v = BaseKnnVectorsFormatTestCase.randomNormalizedVector(fieldDims[field]);
                            doc.add((IndexableField)new KnnFloatVectorField(fieldName, v, fieldSimilarityFunctions[field]));
                            int n = field;
                            fieldTotals[n] = fieldTotals[n] + (double)v[0];
                        }
                    }
                    int n = field;
                    fieldDocCounts[n] = fieldDocCounts[n] + 1;
                }
                w.addDocument(doc);
            }
            try (DirectoryReader r = w.getReader();){
                for (int field = 0; field < numFields; ++field) {
                    int docCount = 0;
                    double checksum = 0.0;
                    String fieldName = "int" + field;
                    switch (fieldVectorEncodings[field]) {
                        case BYTE: {
                            KnnVectorValues.DocIndexIterator iterator;
                            for (LeafReaderContext ctx : r.leaves()) {
                                ByteVectorValues byteVectorValues = ctx.reader().getByteVectorValues(fieldName);
                                if (byteVectorValues == null) continue;
                                docCount += byteVectorValues.size();
                                iterator = byteVectorValues.iterator();
                                while (iterator.nextDoc() != Integer.MAX_VALUE) {
                                    checksum += (double)byteVectorValues.vectorValue(iterator.index())[0];
                                }
                            }
                            break;
                        }
                        case FLOAT32: {
                            KnnVectorValues.DocIndexIterator iterator;
                            for (LeafReaderContext ctx : r.leaves()) {
                                FloatVectorValues vectorValues = ctx.reader().getFloatVectorValues(fieldName);
                                if (vectorValues == null) continue;
                                docCount += vectorValues.size();
                                iterator = vectorValues.iterator();
                                while (iterator.nextDoc() != Integer.MAX_VALUE) {
                                    checksum += (double)vectorValues.vectorValue(iterator.index())[0];
                                }
                            }
                            break;
                        }
                    }
                    BaseKnnVectorsFormatTestCase.assertEquals((long)fieldDocCounts[field], (long)docCount);
                    double delta = fieldVectorEncodings[field] == VectorEncoding.BYTE ? (double)numDocs * 0.01 : 1.0E-5;
                    BaseKnnVectorsFormatTestCase.assertEquals((double)fieldTotals[field], (double)checksum, (double)delta);
                }
            }
        }
    }

    public void testFloatVectorScorerIteration() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        if (BaseKnnVectorsFormatTestCase.random().nextBoolean()) {
            iwc.setIndexSort(new Sort(new SortField[]{new SortField("sortkey", SortField.Type.INT)}));
        }
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            int numDoc = BaseKnnVectorsFormatTestCase.atLeast(100);
            int dimension = BaseKnnVectorsFormatTestCase.atLeast(10);
            if (dimension % 2 != 0) {
                ++dimension;
            }
            float[][] values = new float[numDoc][];
            for (int i = 0; i < numDoc; ++i) {
                if (BaseKnnVectorsFormatTestCase.random().nextInt(7) != 3) {
                    values[i] = BaseKnnVectorsFormatTestCase.randomNormalizedVector(dimension);
                }
                this.add(iw, fieldName, i, values[i], this.similarityFunction);
                if (BaseKnnVectorsFormatTestCase.random().nextInt(10) == 2) {
                    iw.deleteDocuments(new Term[]{new Term("id", Integer.toString(BaseKnnVectorsFormatTestCase.random().nextInt(i + 1)))});
                }
                if (BaseKnnVectorsFormatTestCase.random().nextInt(10) != 3) continue;
                iw.commit();
            }
            float[] vectorToScore = BaseKnnVectorsFormatTestCase.randomNormalizedVector(dimension);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                for (LeafReaderContext ctx : reader.leaves()) {
                    FloatVectorValues vectorValues = ctx.reader().getFloatVectorValues(fieldName);
                    if (vectorValues == null) continue;
                    if (vectorValues.size() == 0) {
                        BaseKnnVectorsFormatTestCase.assertNull((Object)vectorValues.scorer(vectorToScore));
                        continue;
                    }
                    VectorScorer scorer = vectorValues.scorer(vectorToScore);
                    BaseKnnVectorsFormatTestCase.assertNotNull((Object)scorer);
                    DocIdSetIterator iterator = scorer.iterator();
                    BaseKnnVectorsFormatTestCase.assertSame((Object)iterator, (Object)scorer.iterator());
                    BaseKnnVectorsFormatTestCase.assertNotSame((Object)iterator, (Object)scorer);
                    KnnVectorValues.DocIndexIterator valuesIterator = vectorValues.iterator();
                    while (iterator.nextDoc() != Integer.MAX_VALUE && valuesIterator.nextDoc() != Integer.MAX_VALUE) {
                        float score = scorer.score();
                        BaseKnnVectorsFormatTestCase.assertTrue((score >= 0.0f ? 1 : 0) != 0);
                        BaseKnnVectorsFormatTestCase.assertEquals((long)iterator.docID(), (long)valuesIterator.docID());
                    }
                    VectorScorer newScorer = vectorValues.scorer(vectorToScore);
                    BaseKnnVectorsFormatTestCase.assertNotNull((Object)newScorer);
                    BaseKnnVectorsFormatTestCase.assertNotSame((Object)scorer, (Object)newScorer);
                    BaseKnnVectorsFormatTestCase.assertNotSame((Object)iterator, (Object)newScorer.iterator());
                }
            }
        }
    }

    public void testByteVectorScorerIteration() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        if (BaseKnnVectorsFormatTestCase.random().nextBoolean()) {
            iwc.setIndexSort(new Sort(new SortField[]{new SortField("sortkey", SortField.Type.INT)}));
        }
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            int numDoc = BaseKnnVectorsFormatTestCase.atLeast(100);
            int dimension = BaseKnnVectorsFormatTestCase.atLeast(10);
            if (dimension % 2 != 0) {
                ++dimension;
            }
            byte[][] values = new byte[numDoc][];
            for (int i = 0; i < numDoc; ++i) {
                if (BaseKnnVectorsFormatTestCase.random().nextInt(7) != 3) {
                    values[i] = BaseKnnVectorsFormatTestCase.randomVector8(dimension);
                }
                this.add(iw, fieldName, i, values[i], this.similarityFunction);
                if (BaseKnnVectorsFormatTestCase.random().nextInt(10) == 2) {
                    iw.deleteDocuments(new Term[]{new Term("id", Integer.toString(BaseKnnVectorsFormatTestCase.random().nextInt(i + 1)))});
                }
                if (BaseKnnVectorsFormatTestCase.random().nextInt(10) != 3) continue;
                iw.commit();
            }
            byte[] vectorToScore = BaseKnnVectorsFormatTestCase.randomVector8(dimension);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                for (LeafReaderContext ctx : reader.leaves()) {
                    ByteVectorValues vectorValues = ctx.reader().getByteVectorValues(fieldName);
                    if (vectorValues == null) continue;
                    if (vectorValues.size() == 0) {
                        BaseKnnVectorsFormatTestCase.assertNull((Object)vectorValues.scorer(vectorToScore));
                        continue;
                    }
                    VectorScorer scorer = vectorValues.scorer(vectorToScore);
                    BaseKnnVectorsFormatTestCase.assertNotNull((Object)scorer);
                    DocIdSetIterator iterator = scorer.iterator();
                    BaseKnnVectorsFormatTestCase.assertSame((Object)iterator, (Object)scorer.iterator());
                    BaseKnnVectorsFormatTestCase.assertNotSame((Object)iterator, (Object)scorer);
                    KnnVectorValues.DocIndexIterator valuesIterator = vectorValues.iterator();
                    while (iterator.nextDoc() != Integer.MAX_VALUE && valuesIterator.nextDoc() != Integer.MAX_VALUE) {
                        float score = scorer.score();
                        BaseKnnVectorsFormatTestCase.assertTrue((score >= 0.0f ? 1 : 0) != 0);
                        BaseKnnVectorsFormatTestCase.assertEquals((long)iterator.docID(), (long)valuesIterator.docID());
                    }
                    VectorScorer newScorer = vectorValues.scorer(vectorToScore);
                    BaseKnnVectorsFormatTestCase.assertNotNull((Object)newScorer);
                    BaseKnnVectorsFormatTestCase.assertNotSame((Object)scorer, (Object)newScorer);
                    BaseKnnVectorsFormatTestCase.assertNotSame((Object)iterator, (Object)newScorer.iterator());
                }
            }
        }
    }

    public void testEmptyFloatVectorData() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc1 = new Document();
            doc1.add((IndexableField)new StringField("id", "0", Field.Store.NO));
            doc1.add((IndexableField)new KnnFloatVectorField("v", new float[]{2.0f, 3.0f, 5.0f, 6.0f}, VectorSimilarityFunction.DOT_PRODUCT));
            w.addDocument((Iterable)doc1);
            Document doc2 = new Document();
            doc2.add((IndexableField)new StringField("id", "1", Field.Store.NO));
            w.addDocument((Iterable)doc2);
            w.deleteDocuments(new Term[]{new Term("id", Integer.toString(0))});
            w.commit();
            w.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)w);){
                LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                FloatVectorValues values = r.getFloatVectorValues("v");
                BaseKnnVectorsFormatTestCase.assertNotNull((Object)values);
                BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)values.size());
                BaseKnnVectorsFormatTestCase.assertNull((Object)values.scorer(new float[]{2.0f, 3.0f, 5.0f, 6.0f}));
            }
        }
    }

    public void testEmptyByteVectorData() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            Document doc1 = new Document();
            doc1.add((IndexableField)new StringField("id", "0", Field.Store.NO));
            doc1.add((IndexableField)new KnnByteVectorField("v", new byte[]{2, 3, 5, 6}, VectorSimilarityFunction.DOT_PRODUCT));
            w.addDocument((Iterable)doc1);
            Document doc2 = new Document();
            doc2.add((IndexableField)new StringField("id", "1", Field.Store.NO));
            w.addDocument((Iterable)doc2);
            w.deleteDocuments(new Term[]{new Term("id", Integer.toString(0))});
            w.commit();
            w.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)w);){
                LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                ByteVectorValues values = r.getByteVectorValues("v");
                BaseKnnVectorsFormatTestCase.assertNotNull((Object)values);
                BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)values.size());
                BaseKnnVectorsFormatTestCase.assertNull((Object)values.scorer(new byte[]{2, 3, 5, 6}));
            }
        }
    }

    protected VectorSimilarityFunction randomSimilarity() {
        return VectorSimilarityFunction.values()[BaseKnnVectorsFormatTestCase.random().nextInt(VectorSimilarityFunction.values().length)];
    }

    protected VectorEncoding randomVectorEncoding() {
        return VectorEncoding.values()[BaseKnnVectorsFormatTestCase.random().nextInt(VectorEncoding.values().length)];
    }

    public void testIndexedValueNotAliased() throws Exception {
        String fieldName = "field";
        float[] v = new float[]{0.0f, 0.0f};
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig().setMergePolicy(NoMergePolicy.INSTANCE).setMaxBufferedDocs(3).setRAMBufferSizeMB(-1.0));){
            Document doc1 = new Document();
            doc1.add((IndexableField)new KnnFloatVectorField(fieldName, v, VectorSimilarityFunction.EUCLIDEAN));
            v[0] = 1.0f;
            Document doc2 = new Document();
            doc2.add((IndexableField)new KnnFloatVectorField(fieldName, v, VectorSimilarityFunction.EUCLIDEAN));
            iw.addDocument((Iterable)doc1);
            iw.addDocument((Iterable)doc2);
            v[0] = 2.0f;
            Document doc3 = new Document();
            doc3.add((IndexableField)new KnnFloatVectorField(fieldName, v, VectorSimilarityFunction.EUCLIDEAN));
            iw.addDocument((Iterable)doc3);
            iw.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                FloatVectorValues vectorValues = r.getFloatVectorValues(fieldName);
                BaseKnnVectorsFormatTestCase.assertEquals((long)3L, (long)vectorValues.size());
                KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
                iterator.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)iterator.index());
                BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vectorValues.vectorValue(0)[0], (float)0.0f);
                iterator.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)iterator.index());
                BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vectorValues.vectorValue(1)[0], (float)0.0f);
                iterator.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)iterator.index());
                BaseKnnVectorsFormatTestCase.assertEquals((float)2.0f, (float)vectorValues.vectorValue(2)[0], (float)0.0f);
            }
        }
    }

    public void testSortedIndex() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        iwc.setIndexSort(new Sort(new SortField[]{new SortField("sortkey", SortField.Type.INT)}));
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            this.add(iw, fieldName, 1, 1, new float[]{-1.0f, 0.0f});
            this.add(iw, fieldName, 4, 4, new float[]{0.0f, 1.0f});
            this.add(iw, fieldName, 3, 3, (float[])null);
            this.add(iw, fieldName, 2, 2, new float[]{1.0f, 0.0f});
            iw.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                LeafReader leaf = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                StoredFields storedFields = leaf.storedFields();
                FloatVectorValues vectorValues = leaf.getFloatVectorValues(fieldName);
                BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)vectorValues.dimension());
                BaseKnnVectorsFormatTestCase.assertEquals((long)3L, (long)vectorValues.size());
                KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"1", (Object)storedFields.document(iterator.nextDoc()).get("id"));
                BaseKnnVectorsFormatTestCase.assertEquals((float)-1.0f, (float)vectorValues.vectorValue(0)[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"2", (Object)storedFields.document(iterator.nextDoc()).get("id"));
                BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vectorValues.vectorValue(1)[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"4", (Object)storedFields.document(iterator.nextDoc()).get("id"));
                BaseKnnVectorsFormatTestCase.assertEquals((float)0.0f, (float)vectorValues.vectorValue(2)[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)iterator.nextDoc());
            }
        }
    }

    public void testSortedIndexBytes() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        iwc.setIndexSort(new Sort(new SortField[]{new SortField("sortkey", SortField.Type.INT)}));
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            this.add(iw, fieldName, 1, 1, new byte[]{-1, 0});
            this.add(iw, fieldName, 4, 4, new byte[]{0, 1});
            this.add(iw, fieldName, 3, 3, (byte[])null);
            this.add(iw, fieldName, 2, 2, new byte[]{1, 0});
            iw.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                LeafReader leaf = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                StoredFields storedFields = leaf.storedFields();
                ByteVectorValues vectorValues = leaf.getByteVectorValues(fieldName);
                BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)vectorValues.dimension());
                BaseKnnVectorsFormatTestCase.assertEquals((long)3L, (long)vectorValues.size());
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"1", (Object)storedFields.document(vectorValues.iterator().nextDoc()).get("id"));
                BaseKnnVectorsFormatTestCase.assertEquals((float)-1.0f, (float)vectorValues.vectorValue(0)[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"2", (Object)storedFields.document(vectorValues.iterator().nextDoc()).get("id"));
                BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vectorValues.vectorValue(1)[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((Object)"4", (Object)storedFields.document(vectorValues.iterator().nextDoc()).get("id"));
                BaseKnnVectorsFormatTestCase.assertEquals((float)0.0f, (float)vectorValues.vectorValue(2)[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)vectorValues.iterator().nextDoc());
            }
        }
    }

    public void testIndexMultipleKnnVectorFields() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig().setMergePolicy((MergePolicy)BaseKnnVectorsFormatTestCase.newLogMergePolicy()));){
            Document doc = new Document();
            float[] v = new float[]{1.0f, 2.0f};
            doc.add((IndexableField)new KnnFloatVectorField("field1", v, VectorSimilarityFunction.EUCLIDEAN));
            doc.add((IndexableField)new KnnFloatVectorField("field2", new float[]{1.0f, 2.0f, 3.0f, 4.0f}, VectorSimilarityFunction.EUCLIDEAN));
            iw.addDocument((Iterable)doc);
            v[0] = 2.0f;
            iw.addDocument((Iterable)doc);
            doc = new Document();
            doc.add((IndexableField)new KnnFloatVectorField("field3", new float[]{1.0f, 2.0f, 3.0f, 4.0f}, VectorSimilarityFunction.DOT_PRODUCT));
            iw.addDocument((Iterable)doc);
            iw.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                LeafReader leaf = ((LeafReaderContext)reader.leaves().get(0)).reader();
                FloatVectorValues vectorValues = leaf.getFloatVectorValues("field1");
                BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)vectorValues.dimension());
                BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)vectorValues.size());
                KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
                iterator.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vectorValues.vectorValue(0)[0], (float)0.0f);
                iterator.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)2.0f, (float)vectorValues.vectorValue(1)[0], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)iterator.nextDoc());
                FloatVectorValues vectorValues2 = leaf.getFloatVectorValues("field2");
                KnnVectorValues.DocIndexIterator it2 = vectorValues2.iterator();
                BaseKnnVectorsFormatTestCase.assertEquals((long)4L, (long)vectorValues2.dimension());
                BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)vectorValues2.size());
                it2.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)2.0f, (float)vectorValues2.vectorValue(0)[1], (float)0.0f);
                it2.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((float)2.0f, (float)vectorValues2.vectorValue(1)[1], (float)0.0f);
                BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)it2.nextDoc());
                FloatVectorValues vectorValues3 = leaf.getFloatVectorValues("field3");
                BaseKnnVectorsFormatTestCase.assertEquals((long)4L, (long)vectorValues3.dimension());
                BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)vectorValues3.size());
                KnnVectorValues.DocIndexIterator it3 = vectorValues3.iterator();
                it3.nextDoc();
                BaseKnnVectorsFormatTestCase.assertEquals((double)1.0, (double)vectorValues3.vectorValue(0)[0], (double)0.1);
                BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)it3.nextDoc());
            }
        }
    }

    public void testRandom() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        if (BaseKnnVectorsFormatTestCase.random().nextBoolean()) {
            iwc.setIndexSort(new Sort(new SortField[]{new SortField("sortkey", SortField.Type.INT)}));
        }
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            int numDoc = BaseKnnVectorsFormatTestCase.atLeast(100);
            int dimension = BaseKnnVectorsFormatTestCase.atLeast(10);
            if (dimension % 2 != 0) {
                ++dimension;
            }
            float[] scratch = new float[dimension];
            int numValues = 0;
            float[][] values = new float[numDoc][];
            for (int i = 0; i < numDoc; ++i) {
                if (BaseKnnVectorsFormatTestCase.random().nextInt(7) != 3) {
                    values[i] = BaseKnnVectorsFormatTestCase.randomNormalizedVector(dimension);
                    ++numValues;
                }
                if (BaseKnnVectorsFormatTestCase.random().nextBoolean() && values[i] != null) {
                    System.arraycopy(values[i], 0, scratch, 0, scratch.length);
                    this.add(iw, fieldName, i, scratch, this.similarityFunction);
                } else {
                    this.add(iw, fieldName, i, values[i], this.similarityFunction);
                }
                if (BaseKnnVectorsFormatTestCase.random().nextInt(10) == 2) {
                    int idToDelete = BaseKnnVectorsFormatTestCase.random().nextInt(i + 1);
                    iw.deleteDocuments(new Term[]{new Term("id", Integer.toString(idToDelete))});
                    if (values[idToDelete] != null) {
                        values[idToDelete] = null;
                        --numValues;
                    }
                }
                if (BaseKnnVectorsFormatTestCase.random().nextInt(10) != 3) continue;
                iw.commit();
            }
            int numDeletes = 0;
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                int valueCount = 0;
                int totalSize = 0;
                for (LeafReaderContext ctx : reader.leaves()) {
                    int docId;
                    FloatVectorValues vectorValues = ctx.reader().getFloatVectorValues(fieldName);
                    if (vectorValues == null) continue;
                    totalSize += vectorValues.size();
                    StoredFields storedFields = ctx.reader().storedFields();
                    KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
                    while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
                        float[] v = vectorValues.vectorValue(iterator.index());
                        BaseKnnVectorsFormatTestCase.assertEquals((long)dimension, (long)v.length);
                        String idString = storedFields.document(docId).getField("id").stringValue();
                        int id = Integer.parseInt(idString);
                        if (ctx.reader().getLiveDocs() == null || ctx.reader().getLiveDocs().get(docId)) {
                            BaseKnnVectorsFormatTestCase.assertArrayEquals((String)(idString + " " + docId), (float[])values[id], (float[])v, (float)0.0f);
                            ++valueCount;
                            continue;
                        }
                        ++numDeletes;
                        BaseKnnVectorsFormatTestCase.assertNull((Object)values[id]);
                    }
                }
                BaseKnnVectorsFormatTestCase.assertEquals((long)numValues, (long)valueCount);
                BaseKnnVectorsFormatTestCase.assertEquals((long)numValues, (long)(totalSize - numDeletes));
            }
        }
    }

    public void testRandomBytes() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        if (BaseKnnVectorsFormatTestCase.random().nextBoolean()) {
            iwc.setIndexSort(new Sort(new SortField[]{new SortField("sortkey", SortField.Type.INT)}));
        }
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            int numDoc = BaseKnnVectorsFormatTestCase.atLeast(100);
            int dimension = BaseKnnVectorsFormatTestCase.atLeast(10);
            if (dimension % 2 != 0) {
                ++dimension;
            }
            byte[] scratch = new byte[dimension];
            int numValues = 0;
            BytesRef[] values = new BytesRef[numDoc];
            for (int i = 0; i < numDoc; ++i) {
                if (BaseKnnVectorsFormatTestCase.random().nextInt(7) != 3) {
                    values[i] = new BytesRef(BaseKnnVectorsFormatTestCase.randomVector8(dimension));
                    ++numValues;
                }
                if (BaseKnnVectorsFormatTestCase.random().nextBoolean() && values[i] != null) {
                    System.arraycopy(values[i].bytes, 0, scratch, 0, dimension);
                    this.add(iw, fieldName, i, scratch, this.similarityFunction);
                } else {
                    BytesRef value = values[i];
                    this.add(iw, fieldName, i, value == null ? null : value.bytes, this.similarityFunction);
                }
                if (BaseKnnVectorsFormatTestCase.random().nextInt(10) == 2) {
                    int idToDelete = BaseKnnVectorsFormatTestCase.random().nextInt(i + 1);
                    iw.deleteDocuments(new Term[]{new Term("id", Integer.toString(idToDelete))});
                    if (values[idToDelete] != null) {
                        values[idToDelete] = null;
                        --numValues;
                    }
                }
                if (BaseKnnVectorsFormatTestCase.random().nextInt(10) != 3) continue;
                iw.commit();
            }
            int numDeletes = 0;
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                int valueCount = 0;
                int totalSize = 0;
                for (LeafReaderContext ctx : reader.leaves()) {
                    int docId;
                    ByteVectorValues vectorValues = ctx.reader().getByteVectorValues(fieldName);
                    if (vectorValues == null) continue;
                    totalSize += vectorValues.size();
                    StoredFields storedFields = ctx.reader().storedFields();
                    KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
                    while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
                        byte[] v = vectorValues.vectorValue(iterator.index());
                        BaseKnnVectorsFormatTestCase.assertEquals((long)dimension, (long)v.length);
                        String idString = storedFields.document(docId).getField("id").stringValue();
                        int id = Integer.parseInt(idString);
                        if (ctx.reader().getLiveDocs() == null || ctx.reader().getLiveDocs().get(docId)) {
                            BaseKnnVectorsFormatTestCase.assertEquals((String)idString, (long)0L, (long)values[id].compareTo(new BytesRef(v)));
                            ++valueCount;
                            continue;
                        }
                        ++numDeletes;
                        BaseKnnVectorsFormatTestCase.assertNull((Object)values[id]);
                    }
                }
                BaseKnnVectorsFormatTestCase.assertEquals((long)numValues, (long)valueCount);
                BaseKnnVectorsFormatTestCase.assertEquals((long)numValues, (long)(totalSize - numDeletes));
            }
        }
    }

    public void testSearchWithVisitedLimit() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            int i;
            int numDoc = 300;
            int dimension = 10;
            for (i = 0; i < numDoc; ++i) {
                float[] value = BaseKnnVectorsFormatTestCase.random().nextInt(7) != 3 ? BaseKnnVectorsFormatTestCase.randomNormalizedVector(dimension) : null;
                this.add(iw, fieldName, i, value, VectorSimilarityFunction.EUCLIDEAN);
            }
            iw.forceMerge(1);
            for (i = 0; i < 30; ++i) {
                int idToDelete = BaseKnnVectorsFormatTestCase.random().nextInt(numDoc);
                iw.deleteDocuments(new Term[]{new Term("id", Integer.toString(idToDelete))});
            }
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                for (LeafReaderContext ctx : reader.leaves()) {
                    Bits liveDocs = ctx.reader().getLiveDocs();
                    FloatVectorValues vectorValues = ctx.reader().getFloatVectorValues(fieldName);
                    if (vectorValues == null) continue;
                    int k = 5 + BaseKnnVectorsFormatTestCase.random().nextInt(45);
                    int visitedLimit = k + BaseKnnVectorsFormatTestCase.random().nextInt(5);
                    TopDocs results = ctx.reader().searchNearestVectors(fieldName, BaseKnnVectorsFormatTestCase.randomNormalizedVector(dimension), k, liveDocs, visitedLimit);
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO, (Object)results.totalHits.relation());
                    BaseKnnVectorsFormatTestCase.assertEquals((long)visitedLimit, (long)results.totalHits.value());
                    k = vectorValues.size();
                    visitedLimit = k + 30;
                    results = ctx.reader().searchNearestVectors(fieldName, BaseKnnVectorsFormatTestCase.randomNormalizedVector(dimension), k, liveDocs, visitedLimit);
                    BaseKnnVectorsFormatTestCase.assertEquals((Object)TotalHits.Relation.EQUAL_TO, (Object)results.totalHits.relation());
                    BaseKnnVectorsFormatTestCase.assertTrue((results.totalHits.value() <= (long)visitedLimit ? 1 : 0) != 0);
                }
            }
        }
    }

    public void testRandomWithUpdatesAndGraph() throws Exception {
        IndexWriterConfig iwc = BaseKnnVectorsFormatTestCase.newIndexWriterConfig();
        String fieldName = "field";
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter iw = new IndexWriter((Directory)dir, iwc);){
            int numDoc = BaseKnnVectorsFormatTestCase.atLeast(100);
            int dimension = BaseKnnVectorsFormatTestCase.atLeast(10);
            if (dimension % 2 != 0) {
                ++dimension;
            }
            float[][] id2value = new float[numDoc][];
            for (int i = 0; i < numDoc; ++i) {
                int id = BaseKnnVectorsFormatTestCase.random().nextInt(numDoc);
                float[] value = BaseKnnVectorsFormatTestCase.random().nextInt(7) != 3 ? BaseKnnVectorsFormatTestCase.randomNormalizedVector(dimension) : null;
                id2value[id] = value;
                this.add(iw, fieldName, id, value, VectorSimilarityFunction.EUCLIDEAN);
            }
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)iw);){
                for (LeafReaderContext ctx : reader.leaves()) {
                    int docId;
                    Bits liveDocs = ctx.reader().getLiveDocs();
                    FloatVectorValues vectorValues = ctx.reader().getFloatVectorValues(fieldName);
                    if (vectorValues == null) continue;
                    StoredFields storedFields = ctx.reader().storedFields();
                    int numLiveDocsWithVectors = 0;
                    KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
                    while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
                        float[] v = vectorValues.vectorValue(iterator.index());
                        BaseKnnVectorsFormatTestCase.assertEquals((long)dimension, (long)v.length);
                        String idString = storedFields.document(docId).getField("id").stringValue();
                        int id = Integer.parseInt(idString);
                        if (liveDocs == null || liveDocs.get(docId)) {
                            BaseKnnVectorsFormatTestCase.assertArrayEquals((String)("values differ for id=" + idString + ", docid=" + docId + " leaf=" + ctx.ord), (float[])id2value[id], (float[])v, (float)0.0f);
                            ++numLiveDocsWithVectors;
                            continue;
                        }
                        if (id2value[id] == null) continue;
                        BaseKnnVectorsFormatTestCase.assertFalse((boolean)Arrays.equals(id2value[id], v));
                    }
                    if (numLiveDocsWithVectors == 0) continue;
                    int size = ctx.reader().getFloatVectorValues(fieldName).size();
                    int k = BaseKnnVectorsFormatTestCase.random().nextInt(size / 10 + 1) + 1;
                    if (k > numLiveDocsWithVectors) {
                        k = numLiveDocsWithVectors;
                    }
                    TopDocs results = ctx.reader().searchNearestVectors(fieldName, BaseKnnVectorsFormatTestCase.randomNormalizedVector(dimension), k, liveDocs, Integer.MAX_VALUE);
                    BaseKnnVectorsFormatTestCase.assertEquals((long)Math.min(k, size), (long)results.scoreDocs.length);
                    for (int i = 0; i < k - 1; ++i) {
                        BaseKnnVectorsFormatTestCase.assertTrue((results.scoreDocs[i].score >= results.scoreDocs[i + 1].score ? 1 : 0) != 0);
                    }
                }
            }
        }
    }

    private void add(IndexWriter iw, String field, int id, float[] vector, VectorSimilarityFunction similarityFunction) throws IOException {
        this.add(iw, field, id, BaseKnnVectorsFormatTestCase.random().nextInt(100), vector, similarityFunction);
    }

    private void add(IndexWriter iw, String field, int id, byte[] vector, VectorSimilarityFunction similarity) throws IOException {
        this.add(iw, field, id, BaseKnnVectorsFormatTestCase.random().nextInt(100), vector, similarity);
    }

    private void add(IndexWriter iw, String field, int id, int sortKey, byte[] vector) throws IOException {
        this.add(iw, field, id, sortKey, vector, VectorSimilarityFunction.EUCLIDEAN);
    }

    private void add(IndexWriter iw, String field, int id, int sortKey, byte[] vector, VectorSimilarityFunction similarityFunction) throws IOException {
        Document doc = new Document();
        if (vector != null) {
            doc.add((IndexableField)new KnnByteVectorField(field, vector, similarityFunction));
        }
        doc.add((IndexableField)new NumericDocValuesField("sortkey", (long)sortKey));
        String idString = Integer.toString(id);
        doc.add((IndexableField)new StringField("id", idString, Field.Store.YES));
        Term idTerm = new Term("id", idString);
        iw.updateDocument(idTerm, (Iterable)doc);
    }

    private void add(IndexWriter iw, String field, int id, int sortkey, float[] vector) throws IOException {
        this.add(iw, field, id, sortkey, vector, VectorSimilarityFunction.EUCLIDEAN);
    }

    private void add(IndexWriter iw, String field, int id, int sortkey, float[] vector, VectorSimilarityFunction similarityFunction) throws IOException {
        Document doc = new Document();
        if (vector != null) {
            doc.add((IndexableField)new KnnFloatVectorField(field, vector, similarityFunction));
        }
        doc.add((IndexableField)new NumericDocValuesField("sortkey", (long)sortkey));
        String idString = Integer.toString(id);
        doc.add((IndexableField)new StringField("id", idString, Field.Store.YES));
        Term idTerm = new Term("id", idString);
        iw.updateDocument(idTerm, (Iterable)doc);
    }

    public static float[] randomVector(int dim) {
        assert (dim > 0);
        float[] v = new float[dim];
        double squareSum = 0.0;
        while (squareSum == 0.0) {
            squareSum = 0.0;
            for (int i = 0; i < dim; ++i) {
                v[i] = BaseKnnVectorsFormatTestCase.random().nextFloat();
                squareSum += (double)(v[i] * v[i]);
            }
        }
        return v;
    }

    public static float[] randomNormalizedVector(int dim) {
        float[] v = BaseKnnVectorsFormatTestCase.randomVector(dim);
        VectorUtil.l2normalize((float[])v);
        return v;
    }

    public static byte[] randomVector8(int dim) {
        assert (dim > 0);
        float[] v = BaseKnnVectorsFormatTestCase.randomNormalizedVector(dim);
        byte[] b = new byte[dim];
        for (int i = 0; i < dim; ++i) {
            b[i] = (byte)(v[i] * 127.0f);
        }
        return b;
    }

    public void testCheckIndexIncludesVectors() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();){
            try (IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
                Document doc = new Document();
                doc.add((IndexableField)new KnnFloatVectorField("v1", BaseKnnVectorsFormatTestCase.randomNormalizedVector(4), VectorSimilarityFunction.EUCLIDEAN));
                w.addDocument((Iterable)doc);
                doc.add((IndexableField)new KnnFloatVectorField("v2", BaseKnnVectorsFormatTestCase.randomNormalizedVector(4), VectorSimilarityFunction.EUCLIDEAN));
                w.addDocument((Iterable)doc);
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            CheckIndex.Status status = TestUtil.checkIndex((Directory)dir, 2, true, true, output);
            BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)status.segmentInfos.size());
            CheckIndex.Status.SegmentInfoStatus segStatus = (CheckIndex.Status.SegmentInfoStatus)status.segmentInfos.get(0);
            BaseKnnVectorsFormatTestCase.assertEquals((long)3L, (long)segStatus.vectorValuesStatus.totalVectorValues);
            BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)segStatus.vectorValuesStatus.totalKnnVectorFields);
            BaseKnnVectorsFormatTestCase.assertTrue((boolean)output.toString(StandardCharsets.UTF_8).contains("test: vectors..."));
        }
    }

    public void testSimilarityFunctionIdentifiers() {
        BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)VectorSimilarityFunction.EUCLIDEAN.ordinal());
        BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)VectorSimilarityFunction.DOT_PRODUCT.ordinal());
        BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)VectorSimilarityFunction.COSINE.ordinal());
        BaseKnnVectorsFormatTestCase.assertEquals((long)3L, (long)VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT.ordinal());
        BaseKnnVectorsFormatTestCase.assertEquals((long)4L, (long)VectorSimilarityFunction.values().length);
    }

    public void testVectorEncodingOrdinals() {
        BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)VectorEncoding.BYTE.ordinal());
        BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)VectorEncoding.FLOAT32.ordinal());
        BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)VectorEncoding.values().length);
    }

    public void testAdvance() throws Exception {
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             IndexWriter w = new IndexWriter((Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            int numdocs = BaseKnnVectorsFormatTestCase.atLeast(1500);
            String fieldName = "field";
            for (int i = 0; i < numdocs; ++i) {
                Document doc = new Document();
                if (BaseKnnVectorsFormatTestCase.random().nextInt(4) == 3) {
                    doc.add((IndexableField)new KnnFloatVectorField(fieldName, new float[4], VectorSimilarityFunction.EUCLIDEAN));
                }
                w.addDocument((Iterable)doc);
            }
            w.forceMerge(1);
            try (DirectoryReader reader = DirectoryReader.open((IndexWriter)w);){
                LeafReader r = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
                FloatVectorValues vectorValues = r.getFloatVectorValues(fieldName);
                int[] vectorDocs = new int[vectorValues.size() + 1];
                int cur = -1;
                KnnVectorValues.DocIndexIterator iterator = vectorValues.iterator();
                while (++cur < vectorValues.size() + 1) {
                    vectorDocs[cur] = iterator.nextDoc();
                    if (cur == 0) continue;
                    BaseKnnVectorsFormatTestCase.assertTrue((vectorDocs[cur] > vectorDocs[cur - 1] ? 1 : 0) != 0);
                }
                vectorValues = r.getFloatVectorValues(fieldName);
                KnnVectorValues.DocIndexIterator iter = vectorValues.iterator();
                cur = -1;
                for (int i = 0; i < numdocs; ++i) {
                    if (BaseKnnVectorsFormatTestCase.random().nextInt(4) != 3) continue;
                    while (vectorDocs[++cur] < i) {
                    }
                    BaseKnnVectorsFormatTestCase.assertEquals((long)vectorDocs[cur], (long)iter.advance(i));
                    BaseKnnVectorsFormatTestCase.assertEquals((long)vectorDocs[cur], (long)iter.docID());
                    if (iter.docID() == Integer.MAX_VALUE) {
                        break;
                    }
                    i = iter.docID();
                }
            }
        }
    }

    public void testVectorValuesReportCorrectDocs() throws Exception {
        int numDocs = BaseKnnVectorsFormatTestCase.atLeast(1000);
        int dim = BaseKnnVectorsFormatTestCase.random().nextInt(20) + 1;
        if (dim % 2 != 0) {
            ++dim;
        }
        double fieldValuesCheckSum = 0.0;
        int fieldDocCount = 0;
        long fieldSumDocIDs = 0L;
        try (BaseDirectoryWrapper dir = BaseKnnVectorsFormatTestCase.newDirectory();
             RandomIndexWriter w = new RandomIndexWriter(BaseKnnVectorsFormatTestCase.random(), (Directory)dir, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());){
            for (int i = 0; i < numDocs; ++i) {
                Document doc = new Document();
                int docID = BaseKnnVectorsFormatTestCase.random().nextInt(numDocs);
                doc.add((IndexableField)new StoredField("id", docID));
                if (BaseKnnVectorsFormatTestCase.random().nextInt(4) == 3) {
                    switch (this.vectorEncoding) {
                        case BYTE: {
                            byte[] b = BaseKnnVectorsFormatTestCase.randomVector8(dim);
                            fieldValuesCheckSum += (double)b[0];
                            doc.add((IndexableField)new KnnByteVectorField("knn_vector", b, this.similarityFunction));
                            break;
                        }
                        case FLOAT32: {
                            float[] v = BaseKnnVectorsFormatTestCase.randomNormalizedVector(dim);
                            fieldValuesCheckSum += (double)v[0];
                            doc.add((IndexableField)new KnnFloatVectorField("knn_vector", v, this.similarityFunction));
                        }
                    }
                    ++fieldDocCount;
                    fieldSumDocIDs += (long)docID;
                }
                w.addDocument(doc);
            }
            if (BaseKnnVectorsFormatTestCase.random().nextBoolean()) {
                w.forceMerge(1);
            }
            try (DirectoryReader r = w.getReader();){
                double checksum = 0.0;
                int docCount = 0;
                long sumDocIds = 0L;
                long sumOrdToDocIds = 0L;
                switch (this.vectorEncoding) {
                    case BYTE: {
                        for (LeafReaderContext ctx : r.leaves()) {
                            Document doc;
                            int ord;
                            ByteVectorValues byteVectorValues = ctx.reader().getByteVectorValues("knn_vector");
                            if (byteVectorValues == null) continue;
                            docCount += byteVectorValues.size();
                            StoredFields storedFields = ctx.reader().storedFields();
                            KnnVectorValues.DocIndexIterator iter = byteVectorValues.iterator();
                            iter.nextDoc();
                            while (iter.docID() != Integer.MAX_VALUE) {
                                ord = iter.index();
                                checksum += (double)byteVectorValues.vectorValue(ord)[0];
                                doc = storedFields.document(iter.docID(), Set.of("id"));
                                sumDocIds += (long)Integer.parseInt(doc.get("id"));
                                iter.nextDoc();
                            }
                            for (ord = 0; ord < byteVectorValues.size(); ++ord) {
                                doc = storedFields.document(byteVectorValues.ordToDoc(ord), Set.of("id"));
                                sumOrdToDocIds += (long)Integer.parseInt(doc.get("id"));
                            }
                        }
                        break;
                    }
                    case FLOAT32: {
                        for (LeafReaderContext ctx : r.leaves()) {
                            Document doc;
                            int ord;
                            FloatVectorValues vectorValues = ctx.reader().getFloatVectorValues("knn_vector");
                            if (vectorValues == null) continue;
                            docCount += vectorValues.size();
                            StoredFields storedFields = ctx.reader().storedFields();
                            KnnVectorValues.DocIndexIterator iter = vectorValues.iterator();
                            iter.nextDoc();
                            while (iter.docID() != Integer.MAX_VALUE) {
                                ord = iter.index();
                                checksum += (double)vectorValues.vectorValue(ord)[0];
                                doc = storedFields.document(iter.docID(), Set.of("id"));
                                sumDocIds += (long)Integer.parseInt(doc.get("id"));
                                iter.nextDoc();
                            }
                            for (ord = 0; ord < vectorValues.size(); ++ord) {
                                doc = storedFields.document(vectorValues.ordToDoc(ord), Set.of("id"));
                                sumOrdToDocIds += (long)Integer.parseInt(doc.get("id"));
                            }
                        }
                        break;
                    }
                }
                BaseKnnVectorsFormatTestCase.assertEquals((String)("encoding=" + String.valueOf(this.vectorEncoding)), (double)fieldValuesCheckSum, (double)checksum, (double)(this.vectorEncoding == VectorEncoding.BYTE ? (double)numDocs * 0.2 : 1.0E-5));
                BaseKnnVectorsFormatTestCase.assertEquals((long)fieldDocCount, (long)docCount);
                BaseKnnVectorsFormatTestCase.assertEquals((long)fieldSumDocIDs, (long)sumDocIds);
                BaseKnnVectorsFormatTestCase.assertEquals((long)fieldSumDocIDs, (long)sumOrdToDocIds);
            }
        }
    }

    public void testMismatchedFields() throws Exception {
        BaseDirectoryWrapper dir1 = BaseKnnVectorsFormatTestCase.newDirectory();
        IndexWriter w1 = new IndexWriter((Directory)dir1, BaseKnnVectorsFormatTestCase.newIndexWriterConfig());
        Document doc = new Document();
        doc.add((IndexableField)new KnnFloatVectorField("float", new float[]{1.0f, 2.0f}));
        doc.add((IndexableField)new KnnByteVectorField("byte", new byte[]{42}));
        w1.addDocument((Iterable)doc);
        BaseDirectoryWrapper dir2 = BaseKnnVectorsFormatTestCase.newDirectory();
        IndexWriter w2 = new IndexWriter((Directory)dir2, BaseKnnVectorsFormatTestCase.newIndexWriterConfig().setMergeScheduler((MergeScheduler)new SerialMergeScheduler()));
        w2.addDocument((Iterable)doc);
        w2.commit();
        DirectoryReader reader = DirectoryReader.open((IndexWriter)w1);
        w1.close();
        w2.addIndexes(new CodecReader[]{new MismatchedCodecReader((CodecReader)BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader), BaseKnnVectorsFormatTestCase.random())});
        reader.close();
        w2.forceMerge(1);
        reader = DirectoryReader.open((IndexWriter)w2);
        w2.close();
        LeafReader leafReader = BaseKnnVectorsFormatTestCase.getOnlyLeafReader((IndexReader)reader);
        ByteVectorValues byteVectors = leafReader.getByteVectorValues("byte");
        BaseKnnVectorsFormatTestCase.assertNotNull((Object)byteVectors);
        KnnVectorValues.DocIndexIterator iter = byteVectors.iterator();
        BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)iter.nextDoc());
        BaseKnnVectorsFormatTestCase.assertArrayEquals((byte[])new byte[]{42}, (byte[])byteVectors.vectorValue(0));
        BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)iter.nextDoc());
        BaseKnnVectorsFormatTestCase.assertArrayEquals((byte[])new byte[]{42}, (byte[])byteVectors.vectorValue(1));
        BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)iter.nextDoc());
        FloatVectorValues floatVectors = leafReader.getFloatVectorValues("float");
        BaseKnnVectorsFormatTestCase.assertNotNull((Object)floatVectors);
        iter = floatVectors.iterator();
        BaseKnnVectorsFormatTestCase.assertEquals((long)0L, (long)iter.nextDoc());
        float[] vector = floatVectors.vectorValue(0);
        BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)vector.length);
        BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vector[0], (float)0.0f);
        BaseKnnVectorsFormatTestCase.assertEquals((float)2.0f, (float)vector[1], (float)0.0f);
        BaseKnnVectorsFormatTestCase.assertEquals((long)1L, (long)iter.nextDoc());
        vector = floatVectors.vectorValue(1);
        BaseKnnVectorsFormatTestCase.assertEquals((long)2L, (long)vector.length);
        BaseKnnVectorsFormatTestCase.assertEquals((float)1.0f, (float)vector[0], (float)0.0f);
        BaseKnnVectorsFormatTestCase.assertEquals((float)2.0f, (float)vector[1], (float)0.0f);
        BaseKnnVectorsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)iter.nextDoc());
        IOUtils.close((Closeable[])new Closeable[]{reader, w2, dir1, dir2});
    }

    private static /* synthetic */ void lambda$testIllegalSimilarityFunctionChangeViaAddIndexesDirectory$13(IndexWriter w2, Directory dir) throws Throwable {
        w2.addIndexes(new Directory[]{dir});
    }

    private static /* synthetic */ void lambda$testIllegalDimChangeViaAddIndexesDirectory$12(IndexWriter w2, Directory dir) throws Throwable {
        w2.addIndexes(new Directory[]{dir});
    }

    private static final class TestMergeScheduler
    extends MergeScheduler {
        AtomicReference<Exception> ex = new AtomicReference();

        private TestMergeScheduler() {
        }

        public void merge(MergeScheduler.MergeSource mergeSource, MergeTrigger trigger) throws IOException {
            MergePolicy.OneMerge merge;
            while ((merge = mergeSource.getNextMerge()) != null) {
                try {
                    mergeSource.merge(merge);
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    this.ex.set(e);
                    break;
                }
            }
        }

        public void close() {
        }
    }
}

