/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.asserting.AssertingPostingsFormat;
import org.apache.lucene.codecs.block.BlockPostingsFormat;
import org.apache.lucene.codecs.bloom.TestBloomFilteredLucene40Postings;
import org.apache.lucene.codecs.lucene40.Lucene40Codec;
import org.apache.lucene.codecs.lucene40.Lucene40PostingsFormat;
import org.apache.lucene.codecs.lucene40ords.Lucene40WithOrds;
import org.apache.lucene.codecs.memory.DirectPostingsFormat;
import org.apache.lucene.codecs.memory.MemoryPostingsFormat;
import org.apache.lucene.codecs.mockintblock.MockFixedIntBlockPostingsFormat;
import org.apache.lucene.codecs.mockintblock.MockVariableIntBlockPostingsFormat;
import org.apache.lucene.codecs.mockrandom.MockRandomPostingsFormat;
import org.apache.lucene.codecs.mocksep.MockSepPostingsFormat;
import org.apache.lucene.codecs.nestedpulsing.NestedPulsingPostingsFormat;
import org.apache.lucene.codecs.pulsing.Pulsing40PostingsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextPostingsFormat;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;

public class RandomCodec
extends Lucene40Codec {
    private List<PostingsFormat> formats = new ArrayList<PostingsFormat>();
    public Set<String> formatNames = new HashSet<String>();
    private Map<String, PostingsFormat> previousMappings = Collections.synchronizedMap(new HashMap());
    private final int perFieldSeed;

    public PostingsFormat getPostingsFormatForField(String name) {
        PostingsFormat codec = this.previousMappings.get(name);
        if (codec == null) {
            codec = this.formats.get(Math.abs(this.perFieldSeed ^ name.hashCode()) % this.formats.size());
            if (codec instanceof SimpleTextPostingsFormat && this.perFieldSeed % 5 != 0) {
                codec = this.formats.get(Math.abs(this.perFieldSeed ^ name.toUpperCase(Locale.ROOT).hashCode()) % this.formats.size());
            }
            this.previousMappings.put(name, codec);
            assert (this.previousMappings.size() < 10000) : "test went insane";
        }
        return codec;
    }

    public RandomCodec(Random random, Set<String> avoidCodecs) {
        this.perFieldSeed = random.nextInt();
        int minItemsPerBlock = _TestUtil.nextInt(random, 2, 100);
        int maxItemsPerBlock = 2 * Math.max(2, minItemsPerBlock - 1) + random.nextInt(100);
        int lowFreqCutoff = _TestUtil.nextInt(random, 2, 100);
        this.add(avoidCodecs, new PostingsFormat[]{new Lucene40PostingsFormat(minItemsPerBlock, maxItemsPerBlock), new BlockPostingsFormat(minItemsPerBlock, maxItemsPerBlock), new DirectPostingsFormat(LuceneTestCase.rarely(random) ? 1 : (LuceneTestCase.rarely(random) ? Integer.MAX_VALUE : maxItemsPerBlock), LuceneTestCase.rarely(random) ? 1 : (LuceneTestCase.rarely(random) ? Integer.MAX_VALUE : lowFreqCutoff)), new Pulsing40PostingsFormat(1 + random.nextInt(20), minItemsPerBlock, maxItemsPerBlock), new Pulsing40PostingsFormat(1 + random.nextInt(20), minItemsPerBlock, maxItemsPerBlock), new TestBloomFilteredLucene40Postings(), new MockSepPostingsFormat(), new MockFixedIntBlockPostingsFormat(_TestUtil.nextInt(random, 1, 2000)), new MockVariableIntBlockPostingsFormat(_TestUtil.nextInt(random, 1, 127)), new MockRandomPostingsFormat(random), new NestedPulsingPostingsFormat(), new Lucene40WithOrds(), new SimpleTextPostingsFormat(), new AssertingPostingsFormat(), new MemoryPostingsFormat(true, random.nextFloat()), new MemoryPostingsFormat(false, random.nextFloat())});
        Collections.shuffle(this.formats, random);
        this.formats = this.formats.subList(0, 4);
    }

    public RandomCodec(Random random) {
        this(random, Collections.emptySet());
    }

    private final void add(Set<String> avoidCodecs, PostingsFormat ... postings) {
        for (PostingsFormat p : postings) {
            if (avoidCodecs.contains(p.getName())) continue;
            this.formats.add(p);
            this.formatNames.add(p.getName());
        }
    }

    public String toString() {
        return super.toString() + ": " + this.previousMappings.toString();
    }
}

