/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

final class PreFlexRWTermVectorsWriter
extends TermVectorsWriter {
    private final Directory directory;
    private final String segment;
    private IndexOutput tvx = null;
    private IndexOutput tvd = null;
    private IndexOutput tvf = null;
    private long[] fps = new long[10];
    private int fieldCount = 0;
    private int numVectorFields = 0;
    private String lastFieldName;
    private final BytesRef lastTerm = new BytesRef(10);
    private int[] offsetStartBuffer = new int[10];
    private int[] offsetEndBuffer = new int[10];
    private int offsetIndex = 0;
    private int offsetFreq = 0;
    private boolean positions = false;
    private boolean offsets = false;
    int lastPosition = 0;
    int lastOffset = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreFlexRWTermVectorsWriter(Directory directory, String segment, IOContext context) throws IOException {
        this.directory = directory;
        this.segment = segment;
        boolean success = false;
        try {
            this.tvx = directory.createOutput(IndexFileNames.segmentFileName((String)segment, (String)"", (String)"tvx"), context);
            this.tvx.writeInt(4);
            this.tvd = directory.createOutput(IndexFileNames.segmentFileName((String)segment, (String)"", (String)"tvd"), context);
            this.tvd.writeInt(4);
            this.tvf = directory.createOutput(IndexFileNames.segmentFileName((String)segment, (String)"", (String)"tvf"), context);
            this.tvf.writeInt(4);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    public void startDocument(int numVectorFields) throws IOException {
        this.lastFieldName = null;
        this.numVectorFields = numVectorFields;
        this.tvx.writeLong(this.tvd.getFilePointer());
        this.tvx.writeLong(this.tvf.getFilePointer());
        this.tvd.writeVInt(numVectorFields);
        this.fieldCount = 0;
        this.fps = ArrayUtil.grow((long[])this.fps, (int)numVectorFields);
    }

    public void startField(FieldInfo info, int numTerms, boolean positions, boolean offsets, boolean payloads) throws IOException {
        assert (this.lastFieldName == null || info.name.compareTo(this.lastFieldName) > 0) : "fieldName=" + info.name + " lastFieldName=" + this.lastFieldName;
        this.lastFieldName = info.name;
        if (payloads) {
            throw new UnsupportedOperationException("3.x codec does not support payloads on vectors!");
        }
        this.positions = positions;
        this.offsets = offsets;
        this.lastTerm.length = 0;
        this.fps[this.fieldCount++] = this.tvf.getFilePointer();
        this.tvd.writeVInt(info.number);
        this.tvf.writeVInt(numTerms);
        byte bits = 0;
        if (positions) {
            bits = (byte)(bits | 1);
        }
        if (offsets) {
            bits = (byte)(bits | 2);
        }
        this.tvf.writeByte(bits);
        assert (this.fieldCount <= this.numVectorFields);
        if (this.fieldCount == this.numVectorFields) {
            for (int i = 1; i < this.fieldCount; ++i) {
                this.tvd.writeVLong(this.fps[i] - this.fps[i - 1]);
            }
        }
    }

    public void startTerm(BytesRef term, int freq) throws IOException {
        int prefix = StringHelper.bytesDifference((BytesRef)this.lastTerm, (BytesRef)term);
        int suffix = term.length - prefix;
        this.tvf.writeVInt(prefix);
        this.tvf.writeVInt(suffix);
        this.tvf.writeBytes(term.bytes, term.offset + prefix, suffix);
        this.tvf.writeVInt(freq);
        this.lastTerm.copyBytes(term);
        this.lastOffset = 0;
        this.lastPosition = 0;
        if (this.offsets && this.positions) {
            this.offsetStartBuffer = ArrayUtil.grow((int[])this.offsetStartBuffer, (int)freq);
            this.offsetEndBuffer = ArrayUtil.grow((int[])this.offsetEndBuffer, (int)freq);
            this.offsetIndex = 0;
            this.offsetFreq = freq;
        }
    }

    public void addPosition(int position, int startOffset, int endOffset, BytesRef payload) throws IOException {
        assert (payload == null);
        if (this.positions && this.offsets) {
            this.tvf.writeVInt(position - this.lastPosition);
            this.lastPosition = position;
            this.offsetStartBuffer[this.offsetIndex] = startOffset;
            this.offsetEndBuffer[this.offsetIndex] = endOffset;
            ++this.offsetIndex;
            if (this.offsetIndex == this.offsetFreq) {
                for (int i = 0; i < this.offsetIndex; ++i) {
                    this.tvf.writeVInt(this.offsetStartBuffer[i] - this.lastOffset);
                    this.tvf.writeVInt(this.offsetEndBuffer[i] - this.offsetStartBuffer[i]);
                    this.lastOffset = this.offsetEndBuffer[i];
                }
            }
        } else if (this.positions) {
            this.tvf.writeVInt(position - this.lastPosition);
            this.lastPosition = position;
        } else if (this.offsets) {
            this.tvf.writeVInt(startOffset - this.lastOffset);
            this.tvf.writeVInt(endOffset - startOffset);
            this.lastOffset = endOffset;
        }
    }

    public void abort() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IOUtils.deleteFilesIgnoringExceptions((Directory)this.directory, (String[])new String[]{IndexFileNames.segmentFileName((String)this.segment, (String)"", (String)"tvx"), IndexFileNames.segmentFileName((String)this.segment, (String)"", (String)"tvd"), IndexFileNames.segmentFileName((String)this.segment, (String)"", (String)"tvf")});
    }

    public void finish(FieldInfos fis, int numDocs) throws IOException {
        if (4L + (long)numDocs * 16L != this.tvx.getFilePointer()) {
            throw new RuntimeException("tvx size mismatch: mergedDocs is " + numDocs + " but tvx size is " + this.tvx.getFilePointer() + " file=" + this.tvx.toString() + "; now aborting this merge to prevent index corruption");
        }
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.tvx, this.tvd, this.tvf});
        this.tvf = null;
        this.tvd = null;
        this.tvx = null;
    }

    public Comparator<BytesRef> getComparator() throws IOException {
        return BytesRef.getUTF8SortedAsUTF16Comparator();
    }
}

