/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.automaton.BasicAutomata;
import org.apache.lucene.util.automaton.BasicOperations;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public final class MockTokenFilter
extends TokenFilter {
    public static final CharacterRunAutomaton EMPTY_STOPSET = new CharacterRunAutomaton(BasicAutomata.makeEmpty());
    public static final CharacterRunAutomaton ENGLISH_STOPSET = new CharacterRunAutomaton(BasicOperations.union(Arrays.asList(BasicAutomata.makeString((String)"a"), BasicAutomata.makeString((String)"an"), BasicAutomata.makeString((String)"and"), BasicAutomata.makeString((String)"are"), BasicAutomata.makeString((String)"as"), BasicAutomata.makeString((String)"at"), BasicAutomata.makeString((String)"be"), BasicAutomata.makeString((String)"but"), BasicAutomata.makeString((String)"by"), BasicAutomata.makeString((String)"for"), BasicAutomata.makeString((String)"if"), BasicAutomata.makeString((String)"in"), BasicAutomata.makeString((String)"into"), BasicAutomata.makeString((String)"is"), BasicAutomata.makeString((String)"it"), BasicAutomata.makeString((String)"no"), BasicAutomata.makeString((String)"not"), BasicAutomata.makeString((String)"of"), BasicAutomata.makeString((String)"on"), BasicAutomata.makeString((String)"or"), BasicAutomata.makeString((String)"such"), BasicAutomata.makeString((String)"that"), BasicAutomata.makeString((String)"the"), BasicAutomata.makeString((String)"their"), BasicAutomata.makeString((String)"then"), BasicAutomata.makeString((String)"there"), BasicAutomata.makeString((String)"these"), BasicAutomata.makeString((String)"they"), BasicAutomata.makeString((String)"this"), BasicAutomata.makeString((String)"to"), BasicAutomata.makeString((String)"was"), BasicAutomata.makeString((String)"will"), BasicAutomata.makeString((String)"with"))));
    private final CharacterRunAutomaton filter;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private int skippedPositions;

    public MockTokenFilter(TokenStream input, CharacterRunAutomaton filter) {
        super(input);
        this.filter = filter;
    }

    public boolean incrementToken() throws IOException {
        this.skippedPositions = 0;
        while (this.input.incrementToken()) {
            if (!this.filter.run(this.termAtt.buffer(), 0, this.termAtt.length())) {
                this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
                return true;
            }
            this.skippedPositions += this.posIncrAtt.getPositionIncrement();
        }
        return false;
    }

    public void end() throws IOException {
        super.end();
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }

    public void reset() throws IOException {
        super.reset();
        this.skippedPositions = 0;
    }
}

