/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.FieldInfosWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

class PreFlexRWFieldInfosWriter
extends FieldInfosWriter {
    static final String FIELD_INFOS_EXTENSION = "fnm";
    static final int FORMAT_START = -2;
    static final int FORMAT_OMIT_POSITIONS = -3;
    static final int FORMAT_PREFLEX_RW = Integer.MIN_VALUE;
    static final int FORMAT_CURRENT = -3;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    static final byte OMIT_POSITIONS = -128;

    PreFlexRWFieldInfosWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Directory directory, String segmentName, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        block16: {
            IndexOutput output;
            block15: {
                String fileName = IndexFileNames.segmentFileName((String)segmentName, (String)"", (String)FIELD_INFOS_EXTENSION);
                output = directory.createOutput(fileName, context);
                boolean success = false;
                try {
                    output.writeVInt(Integer.MIN_VALUE);
                    output.writeVInt(infos.size());
                    for (FieldInfo fi : infos) {
                        byte bits = 0;
                        if (fi.hasVectors()) {
                            bits = (byte)(bits | 2);
                        }
                        if (fi.omitsNorms()) {
                            bits = (byte)(bits | 0x10);
                        }
                        if (fi.hasPayloads()) {
                            bits = (byte)(bits | 0x20);
                        }
                        if (fi.isIndexed()) {
                            bits = (byte)(bits | 1);
                            assert (fi.getIndexOptions() == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS || !fi.hasPayloads());
                            if (fi.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY) {
                                bits = (byte)(bits | 0x40);
                            } else if (fi.getIndexOptions() == FieldInfo.IndexOptions.DOCS_AND_FREQS) {
                                bits = (byte)(bits | 0xFFFFFF80);
                            }
                        }
                        output.writeString(fi.name);
                        output.writeInt(fi.number);
                        output.writeByte(bits);
                        if (fi.isIndexed() && !fi.omitsNorms()) {
                            output.writeByte((byte)(fi.getNormType() != null ? 1 : 0));
                        }
                        assert (fi.attributes() == null);
                    }
                    success = true;
                    if (!success) break block15;
                }
                catch (Throwable throwable) {
                    if (success) {
                        output.close();
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
                    }
                    throw throwable;
                }
                output.close();
                break block16;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
        }
    }
}

