/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene49.Lucene49DocValuesFormat;
import org.apache.lucene.index.AssertingAtomicReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LongBitSet;

public class AssertingDocValuesFormat
extends DocValuesFormat {
    private final DocValuesFormat in = new Lucene49DocValuesFormat();

    public AssertingDocValuesFormat() {
        super("Asserting");
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        DocValuesConsumer consumer = this.in.fieldsConsumer(state);
        assert (consumer != null);
        return new AssertingDocValuesConsumer(consumer, state.segmentInfo.getDocCount());
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        assert (state.fieldInfos.hasDocValues());
        DocValuesProducer producer = this.in.fieldsProducer(state);
        assert (producer != null);
        return new AssertingDocValuesProducer(producer, state.segmentInfo.getDocCount());
    }

    private static <T> void checkIterator(Iterator<T> iterator, long expectedSize, boolean allowNull) {
        for (long i = 0L; i < expectedSize; ++i) {
            boolean hasNext = iterator.hasNext();
            assert (hasNext);
            T v = iterator.next();
            assert (allowNull || v != null);
            try {
                iterator.remove();
                throw new AssertionError((Object)("broken iterator (supports remove): " + iterator));
            }
            catch (UnsupportedOperationException expected) {
                continue;
            }
        }
        assert (!iterator.hasNext());
        try {
            iterator.next();
            throw new AssertionError((Object)("broken iterator (allows next() when hasNext==false) " + iterator));
        }
        catch (NoSuchElementException expected) {
            return;
        }
    }

    static class AssertingDocValuesProducer
    extends DocValuesProducer {
        private final DocValuesProducer in;
        private final int maxDoc;

        AssertingDocValuesProducer(DocValuesProducer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public NumericDocValues getNumeric(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == FieldInfo.DocValuesType.NUMERIC || field.getNormType() == FieldInfo.DocValuesType.NUMERIC);
            NumericDocValues values = this.in.getNumeric(field);
            assert (values != null);
            return new AssertingAtomicReader.AssertingNumericDocValues(values, this.maxDoc);
        }

        public BinaryDocValues getBinary(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == FieldInfo.DocValuesType.BINARY);
            BinaryDocValues values = this.in.getBinary(field);
            assert (values != null);
            return new AssertingAtomicReader.AssertingBinaryDocValues(values, this.maxDoc);
        }

        public SortedDocValues getSorted(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == FieldInfo.DocValuesType.SORTED);
            SortedDocValues values = this.in.getSorted(field);
            assert (values != null);
            return new AssertingAtomicReader.AssertingSortedDocValues(values, this.maxDoc);
        }

        public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == FieldInfo.DocValuesType.SORTED_NUMERIC);
            SortedNumericDocValues values = this.in.getSortedNumeric(field);
            assert (values != null);
            return new AssertingAtomicReader.AssertingSortedNumericDocValues(values, this.maxDoc);
        }

        public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() == FieldInfo.DocValuesType.SORTED_SET);
            SortedSetDocValues values = this.in.getSortedSet(field);
            assert (values != null);
            return new AssertingAtomicReader.AssertingSortedSetDocValues(values, this.maxDoc);
        }

        public Bits getDocsWithField(FieldInfo field) throws IOException {
            assert (field.getDocValuesType() != null);
            Bits bits = this.in.getDocsWithField(field);
            assert (bits != null);
            assert (bits.length() == this.maxDoc);
            return new AssertingAtomicReader.AssertingBits(bits);
        }

        public void close() throws IOException {
            this.in.close();
        }

        public long ramBytesUsed() {
            return this.in.ramBytesUsed();
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }
    }

    static class AssertingNormsConsumer
    extends DocValuesConsumer {
        private final DocValuesConsumer in;
        private final int maxDoc;

        AssertingNormsConsumer(DocValuesConsumer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
            int count = 0;
            for (Number v : values) {
                assert (v != null);
                ++count;
            }
            assert (count == this.maxDoc);
            AssertingDocValuesFormat.checkIterator(values.iterator(), this.maxDoc, false);
            this.in.addNumericField(field, values);
        }

        public void close() throws IOException {
            this.in.close();
        }

        public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
            throw new IllegalStateException();
        }

        public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
            throw new IllegalStateException();
        }

        public void addSortedNumericField(FieldInfo field, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
            throw new IllegalStateException();
        }

        public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
            throw new IllegalStateException();
        }
    }

    static class AssertingDocValuesConsumer
    extends DocValuesConsumer {
        private final DocValuesConsumer in;
        private final int maxDoc;

        AssertingDocValuesConsumer(DocValuesConsumer in, int maxDoc) {
            this.in = in;
            this.maxDoc = maxDoc;
        }

        public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
            int count = 0;
            for (Number v : values) {
                ++count;
            }
            assert (count == this.maxDoc);
            AssertingDocValuesFormat.checkIterator(values.iterator(), this.maxDoc, true);
            this.in.addNumericField(field, values);
        }

        public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
            int count = 0;
            for (BytesRef b : values) {
                assert (b == null || b.isValid());
                ++count;
            }
            assert (count == this.maxDoc);
            AssertingDocValuesFormat.checkIterator(values.iterator(), this.maxDoc, true);
            this.in.addBinaryField(field, values);
        }

        public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
            int valueCount = 0;
            BytesRef lastValue = null;
            for (BytesRef b : values) {
                assert (b != null);
                assert (b.isValid());
                if (valueCount > 0) assert (b.compareTo(lastValue) > 0);
                lastValue = BytesRef.deepCopyOf((BytesRef)b);
                ++valueCount;
            }
            assert (valueCount <= this.maxDoc);
            FixedBitSet seenOrds = new FixedBitSet(valueCount);
            int count = 0;
            for (Number v : docToOrd) {
                assert (v != null);
                int ord = v.intValue();
                assert (ord >= -1 && ord < valueCount);
                if (ord >= 0) {
                    seenOrds.set(ord);
                }
                ++count;
            }
            assert (count == this.maxDoc);
            assert (seenOrds.cardinality() == valueCount);
            AssertingDocValuesFormat.checkIterator(values.iterator(), valueCount, false);
            AssertingDocValuesFormat.checkIterator(docToOrd.iterator(), this.maxDoc, false);
            this.in.addSortedField(field, values, docToOrd);
        }

        public void addSortedNumericField(FieldInfo field, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
            long valueCount = 0L;
            Iterator<Number> valueIterator = values.iterator();
            for (Number count : docToValueCount) {
                assert (count != null);
                assert (count.intValue() >= 0);
                valueCount += (long)count.intValue();
                long previous = Long.MIN_VALUE;
                for (int i = 0; i < count.intValue(); ++i) {
                    assert (valueIterator.hasNext());
                    Number next = valueIterator.next();
                    assert (next != null);
                    long nextValue = next.longValue();
                    assert (nextValue >= previous);
                    previous = nextValue;
                }
            }
            assert (!valueIterator.hasNext());
            AssertingDocValuesFormat.checkIterator(docToValueCount.iterator(), this.maxDoc, false);
            AssertingDocValuesFormat.checkIterator(values.iterator(), valueCount, false);
            this.in.addSortedNumericField(field, docToValueCount, values);
        }

        public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
            long valueCount = 0L;
            BytesRef lastValue = null;
            for (BytesRef b : values) {
                assert (b != null);
                assert (b.isValid());
                if (valueCount > 0L) assert (b.compareTo(lastValue) > 0);
                lastValue = BytesRef.deepCopyOf((BytesRef)b);
                ++valueCount;
            }
            int docCount = 0;
            long ordCount = 0L;
            LongBitSet seenOrds = new LongBitSet(valueCount);
            Iterator<Number> ordIterator = ords.iterator();
            for (Number v : docToOrdCount) {
                assert (v != null);
                int count = v.intValue();
                assert (count >= 0);
                ++docCount;
                ordCount += (long)count;
                long lastOrd = -1L;
                for (int i = 0; i < count; ++i) {
                    Number o = ordIterator.next();
                    assert (o != null);
                    long ord = o.longValue();
                    assert (ord >= 0L && ord < valueCount);
                    assert (ord > lastOrd) : "ord=" + ord + ",lastOrd=" + lastOrd;
                    seenOrds.set(ord);
                    lastOrd = ord;
                }
            }
            assert (!ordIterator.hasNext());
            assert (docCount == this.maxDoc);
            assert (seenOrds.cardinality() == valueCount);
            AssertingDocValuesFormat.checkIterator(values.iterator(), valueCount, false);
            AssertingDocValuesFormat.checkIterator(docToOrdCount.iterator(), this.maxDoc, false);
            AssertingDocValuesFormat.checkIterator(ords.iterator(), ordCount, false);
            this.in.addSortedSetField(field, values, docToOrdCount, ords);
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

