/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CannedTokenStream;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.asserting.AssertingCodec;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LineFileDocs;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.RamUsageTester;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.AutomatonTestUtil;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class BasePostingsFormatTestCase
extends BaseIndexFileFormatTestCase {
    private static Map<String, SortedMap<BytesRef, SeedAndOrd>> fields;
    private static FieldInfos fieldInfos;
    private static FixedBitSet globalLiveDocs;
    private static List<FieldAndTerm> allTerms;
    private static int maxDoc;
    private static long totalPostings;
    private static long totalPayloadBytes;
    private FieldInfos currentFieldInfos;

    private static SeedPostings getSeedPostings(String term, long seed, boolean withLiveDocs, IndexOptions options, boolean allowPayloads) {
        int maxDocFreq;
        int minDocFreq;
        if (term.startsWith("big_")) {
            minDocFreq = RANDOM_MULTIPLIER * 50000;
            maxDocFreq = RANDOM_MULTIPLIER * 70000;
        } else if (term.startsWith("medium_")) {
            minDocFreq = RANDOM_MULTIPLIER * 3000;
            maxDocFreq = RANDOM_MULTIPLIER * 6000;
        } else if (term.startsWith("low_")) {
            minDocFreq = RANDOM_MULTIPLIER;
            maxDocFreq = RANDOM_MULTIPLIER * 40;
        } else {
            minDocFreq = 1;
            maxDocFreq = 3;
        }
        return new SeedPostings(seed, minDocFreq, maxDocFreq, (Bits)(withLiveDocs ? globalLiveDocs : null), options, allowPayloads);
    }

    @BeforeClass
    public static void createPostings() throws IOException {
        totalPostings = 0L;
        totalPayloadBytes = 0L;
        fields = new TreeMap<String, SortedMap<BytesRef, SeedAndOrd>>();
        int numFields = TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, 5);
        if (VERBOSE) {
            System.out.println("TEST: " + numFields + " fields");
        }
        maxDoc = 0;
        FieldInfo[] fieldInfoArray = new FieldInfo[numFields];
        int fieldUpto = 0;
        while (fieldUpto < numFields) {
            String field = TestUtil.randomSimpleString(BasePostingsFormatTestCase.random());
            if (fields.containsKey(field)) continue;
            fieldInfoArray[fieldUpto] = new FieldInfo(field, fieldUpto, false, false, true, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, DocValuesType.NONE, -1L, new HashMap());
            ++fieldUpto;
            TreeMap<BytesRef, SeedAndOrd> postings = new TreeMap<BytesRef, SeedAndOrd>();
            fields.put(field, postings);
            HashSet<String> seenTerms = new HashSet<String>();
            int numTerms = BasePostingsFormatTestCase.random().nextInt(10) == 7 ? BasePostingsFormatTestCase.atLeast(50) : TestUtil.nextInt(BasePostingsFormatTestCase.random(), 2, 20);
            while (postings.size() < numTerms) {
                int doc;
                int termUpto = postings.size();
                String term = TestUtil.randomSimpleString(BasePostingsFormatTestCase.random());
                if (seenTerms.contains(term)) continue;
                seenTerms.add(term);
                term = TEST_NIGHTLY && termUpto == 0 && fieldUpto == 1 ? "big_" + term : (termUpto == 1 && fieldUpto == 1 ? "medium_" + term : (BasePostingsFormatTestCase.random().nextBoolean() ? "low_" + term : "verylow_" + term));
                long termSeed = BasePostingsFormatTestCase.random().nextLong();
                postings.put(new BytesRef((CharSequence)term), new SeedAndOrd(termSeed));
                SeedPostings postingsEnum = BasePostingsFormatTestCase.getSeedPostings(term, termSeed, false, IndexOptions.DOCS, true);
                int lastDoc = 0;
                while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                    lastDoc = doc;
                }
                maxDoc = Math.max(lastDoc, maxDoc);
            }
            long ord = 0L;
            for (SeedAndOrd ent : postings.values()) {
                ++ord;
                ent.ord = ent.ord;
            }
        }
        fieldInfos = new FieldInfos(fieldInfoArray);
        globalLiveDocs = new FixedBitSet(++maxDoc);
        double liveRatio = BasePostingsFormatTestCase.random().nextDouble();
        for (int i = 0; i < maxDoc; ++i) {
            if (!(BasePostingsFormatTestCase.random().nextDouble() <= liveRatio)) continue;
            globalLiveDocs.set(i);
        }
        allTerms = new ArrayList<FieldAndTerm>();
        for (Map.Entry<String, SortedMap<BytesRef, SeedAndOrd>> fieldEnt : fields.entrySet()) {
            String field = fieldEnt.getKey();
            long ord = 0L;
            for (Map.Entry<BytesRef, SeedAndOrd> termEnt : fieldEnt.getValue().entrySet()) {
                allTerms.add(new FieldAndTerm(field, termEnt.getKey(), ord++));
            }
        }
        if (VERBOSE) {
            System.out.println("TEST: done init postings; " + allTerms.size() + " total terms, across " + fieldInfos.size() + " fields");
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        allTerms = null;
        fieldInfos = null;
        fields = null;
        globalLiveDocs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldsProducer buildIndex(Directory dir, IndexOptions maxAllowed, boolean allowPayloads, boolean alwaysTestMax) throws IOException {
        FieldInfos newFieldInfos;
        SegmentInfo segmentInfo;
        Codec codec;
        block9: {
            FieldsConsumer consumer;
            block8: {
                codec = this.getCodec();
                segmentInfo = new SegmentInfo(dir, Version.LATEST, "_0", maxDoc, false, codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap());
                int maxIndexOption = Arrays.asList(IndexOptions.values()).indexOf(maxAllowed);
                if (VERBOSE) {
                    System.out.println("\nTEST: now build index");
                }
                FieldInfo[] newFieldInfoArray = new FieldInfo[fields.size()];
                for (int fieldUpto = 0; fieldUpto < fields.size(); ++fieldUpto) {
                    FieldInfo oldFieldInfo = fieldInfos.fieldInfo(fieldUpto);
                    IndexOptions indexOptions = IndexOptions.values()[alwaysTestMax ? maxIndexOption : TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, maxIndexOption)];
                    boolean doPayloads = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && allowPayloads;
                    newFieldInfoArray[fieldUpto] = new FieldInfo(oldFieldInfo.name, fieldUpto, false, false, doPayloads, indexOptions, DocValuesType.NONE, -1L, new HashMap());
                }
                newFieldInfos = new FieldInfos(newFieldInfoArray);
                long bytes = totalPostings * 8L + totalPayloadBytes;
                SegmentWriteState writeState = new SegmentWriteState(null, dir, segmentInfo, newFieldInfos, null, new IOContext(new FlushInfo(maxDoc, bytes)));
                SeedFields seedFields = new SeedFields(fields, newFieldInfos, maxAllowed, allowPayloads);
                consumer = codec.postingsFormat().fieldsConsumer(writeState);
                boolean success = false;
                try {
                    consumer.write((Fields)seedFields);
                    success = true;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{consumer});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{consumer});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{consumer});
                break block9;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{consumer});
        }
        if (VERBOSE) {
            System.out.println("TEST: after indexing: files=");
            for (String file : dir.listAll()) {
                System.out.println("  " + file + ": " + dir.fileLength(file) + " bytes");
            }
        }
        this.currentFieldInfos = newFieldInfos;
        SegmentReadState readState = new SegmentReadState(dir, segmentInfo, newFieldInfos, IOContext.READ);
        return codec.postingsFormat().fieldsProducer(readState);
    }

    private void verifyEnum(ThreadState threadState, String field, BytesRef term, TermsEnum termsEnum, IndexOptions maxTestOptions, IndexOptions maxIndexOptions, EnumSet<Option> options, boolean alwaysTestMax) throws IOException {
        double offsetCheckChance;
        int stopAt;
        PostingsEnum postingsEnum;
        int flags;
        FixedBitSet liveDocs;
        boolean useLiveDocs;
        if (VERBOSE) {
            System.out.println("  verifyEnum: options=" + options + " maxTestOptions=" + maxTestOptions);
        }
        BasePostingsFormatTestCase.assertEquals((Object)term, (Object)termsEnum.term());
        boolean bl = useLiveDocs = options.contains((Object)Option.LIVE_DOCS) && BasePostingsFormatTestCase.random().nextBoolean();
        if (useLiveDocs) {
            liveDocs = globalLiveDocs;
            if (VERBOSE) {
                System.out.println("  use liveDocs");
            }
        } else {
            liveDocs = null;
            if (VERBOSE) {
                System.out.println("  no liveDocs");
            }
        }
        FieldInfo fieldInfo = this.currentFieldInfos.fieldInfo(field);
        SeedPostings expected = BasePostingsFormatTestCase.getSeedPostings(term.utf8ToString(), ((SeedAndOrd)BasePostingsFormatTestCase.fields.get((Object)field).get((Object)term)).seed, useLiveDocs, maxIndexOptions, true);
        BasePostingsFormatTestCase.assertEquals((long)expected.docFreq, (long)termsEnum.docFreq());
        boolean allowFreqs = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0 && maxTestOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
        boolean doCheckFreqs = allowFreqs && (alwaysTestMax || BasePostingsFormatTestCase.random().nextInt(3) <= 2);
        boolean allowPositions = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && maxTestOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean doCheckPositions = allowPositions && (alwaysTestMax || BasePostingsFormatTestCase.random().nextInt(3) <= 2);
        boolean allowOffsets = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 && maxTestOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        boolean doCheckOffsets = allowOffsets && (alwaysTestMax || BasePostingsFormatTestCase.random().nextInt(3) <= 2);
        boolean doCheckPayloads = options.contains((Object)Option.PAYLOADS) && allowPositions && fieldInfo.hasPayloads() && (alwaysTestMax || BasePostingsFormatTestCase.random().nextInt(3) <= 2);
        PostingsEnum prevPostingsEnum = null;
        if (!doCheckPositions) {
            if (allowPositions && BasePostingsFormatTestCase.random().nextInt(10) == 7) {
                if (options.contains((Object)Option.REUSE_ENUMS) && BasePostingsFormatTestCase.random().nextInt(10) < 9) {
                    prevPostingsEnum = threadState.reusePostingsEnum;
                }
                flags = 24;
                if (alwaysTestMax || BasePostingsFormatTestCase.random().nextBoolean()) {
                    flags |= 0x38;
                }
                if (alwaysTestMax || BasePostingsFormatTestCase.random().nextBoolean()) {
                    flags |= 0x58;
                }
                if (VERBOSE) {
                    System.out.println("  get DocsEnum (but we won't check positions) flags=" + flags);
                }
                postingsEnum = threadState.reusePostingsEnum = termsEnum.postings((Bits)liveDocs, prevPostingsEnum, flags);
            } else {
                if (VERBOSE) {
                    System.out.println("  get DocsEnum");
                }
                if (options.contains((Object)Option.REUSE_ENUMS) && BasePostingsFormatTestCase.random().nextInt(10) < 9) {
                    prevPostingsEnum = threadState.reusePostingsEnum;
                }
                postingsEnum = threadState.reusePostingsEnum = termsEnum.postings((Bits)liveDocs, prevPostingsEnum, doCheckFreqs ? 8 : 0);
            }
        } else {
            if (options.contains((Object)Option.REUSE_ENUMS) && BasePostingsFormatTestCase.random().nextInt(10) < 9) {
                prevPostingsEnum = threadState.reusePostingsEnum;
            }
            flags = 24;
            if (alwaysTestMax || doCheckOffsets || BasePostingsFormatTestCase.random().nextInt(3) == 1) {
                flags |= 0x38;
            }
            if (alwaysTestMax || doCheckPayloads || BasePostingsFormatTestCase.random().nextInt(3) == 1) {
                flags |= 0x58;
            }
            if (VERBOSE) {
                System.out.println("  get DocsEnum flags=" + flags);
            }
            postingsEnum = threadState.reusePostingsEnum = termsEnum.postings((Bits)liveDocs, prevPostingsEnum, flags);
        }
        BasePostingsFormatTestCase.assertNotNull((String)"null DocsEnum", (Object)postingsEnum);
        int initialDocID = postingsEnum.docID();
        BasePostingsFormatTestCase.assertEquals((String)("inital docID should be -1" + postingsEnum), (long)-1L, (long)initialDocID);
        if (VERBOSE) {
            if (prevPostingsEnum == null) {
                System.out.println("  got enum=" + postingsEnum);
            } else if (prevPostingsEnum == postingsEnum) {
                System.out.println("  got reuse enum=" + postingsEnum);
            } else {
                System.out.println("  got enum=" + postingsEnum + " (reuse of " + prevPostingsEnum + " failed)");
            }
        }
        if (!alwaysTestMax && options.contains((Object)Option.PARTIAL_DOC_CONSUME) && expected.docFreq > 1 && BasePostingsFormatTestCase.random().nextInt(10) == 7) {
            stopAt = BasePostingsFormatTestCase.random().nextInt(expected.docFreq - 1);
            if (VERBOSE) {
                System.out.println("  will not consume all docs (" + stopAt + " vs " + expected.docFreq + ")");
            }
        } else {
            stopAt = expected.docFreq;
            if (VERBOSE) {
                System.out.println("  consume all docs");
            }
        }
        double skipChance = alwaysTestMax ? 0.5 : BasePostingsFormatTestCase.random().nextDouble();
        int numSkips = expected.docFreq < 3 ? 1 : TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, Math.min(20, expected.docFreq / 3));
        int skipInc = expected.docFreq / numSkips;
        int skipDocInc = maxDoc / numSkips;
        boolean doAllSkipping = options.contains((Object)Option.SKIPPING) && BasePostingsFormatTestCase.random().nextInt(7) == 1;
        double freqAskChance = alwaysTestMax ? 1.0 : BasePostingsFormatTestCase.random().nextDouble();
        double payloadCheckChance = alwaysTestMax ? 1.0 : BasePostingsFormatTestCase.random().nextDouble();
        double d = offsetCheckChance = alwaysTestMax ? 1.0 : BasePostingsFormatTestCase.random().nextDouble();
        if (VERBOSE) {
            if (options.contains((Object)Option.SKIPPING)) {
                System.out.println("  skipChance=" + skipChance + " numSkips=" + numSkips);
            } else {
                System.out.println("  no skipping");
            }
            if (doCheckFreqs) {
                System.out.println("  freqAskChance=" + freqAskChance);
            }
            if (doCheckPayloads) {
                System.out.println("  payloadCheckChance=" + payloadCheckChance);
            }
            if (doCheckOffsets) {
                System.out.println("  offsetCheckChance=" + offsetCheckChance);
            }
        }
        while (expected.upto <= stopAt) {
            int freq;
            if (expected.upto == stopAt) {
                if (stopAt != expected.docFreq) break;
                BasePostingsFormatTestCase.assertEquals((String)"DocsEnum should have ended but didn't", (long)Integer.MAX_VALUE, (long)postingsEnum.nextDoc());
                BasePostingsFormatTestCase.assertEquals((String)"DocsEnum should have ended but didn't", (long)Integer.MAX_VALUE, (long)postingsEnum.docID());
                break;
            }
            if (options.contains((Object)Option.SKIPPING) && (doAllSkipping || BasePostingsFormatTestCase.random().nextDouble() <= skipChance)) {
                int targetDocID = -1;
                if (expected.upto < stopAt && BasePostingsFormatTestCase.random().nextBoolean()) {
                    int skipCount = TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, skipInc);
                    for (int skip = 0; skip < skipCount && expected.nextDoc() != Integer.MAX_VALUE; ++skip) {
                    }
                } else {
                    int skipDocIDs = TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, skipDocInc);
                    if (skipDocIDs > 0) {
                        targetDocID = expected.docID() + skipDocIDs;
                        expected.advance(targetDocID);
                    }
                }
                if (expected.upto >= stopAt) {
                    int target;
                    int n = target = BasePostingsFormatTestCase.random().nextBoolean() ? maxDoc : Integer.MAX_VALUE;
                    if (VERBOSE) {
                        System.out.println("  now advance to end (target=" + target + ")");
                    }
                    BasePostingsFormatTestCase.assertEquals((String)"DocsEnum should have ended but didn't", (long)Integer.MAX_VALUE, (long)postingsEnum.advance(target));
                    break;
                }
                if (VERBOSE) {
                    if (targetDocID != -1) {
                        System.out.println("  now advance to random target=" + targetDocID + " (" + expected.upto + " of " + stopAt + ") current=" + postingsEnum.docID());
                    } else {
                        System.out.println("  now advance to known-exists target=" + expected.docID() + " (" + expected.upto + " of " + stopAt + ") current=" + postingsEnum.docID());
                    }
                }
                int docID = postingsEnum.advance(targetDocID != -1 ? targetDocID : expected.docID());
                BasePostingsFormatTestCase.assertEquals((String)"docID is wrong", (long)expected.docID(), (long)docID);
            } else {
                expected.nextDoc();
                if (VERBOSE) {
                    System.out.println("  now nextDoc to " + expected.docID() + " (" + expected.upto + " of " + stopAt + ")");
                }
                int docID = postingsEnum.nextDoc();
                BasePostingsFormatTestCase.assertEquals((String)"docID is wrong", (long)expected.docID(), (long)docID);
                if (docID == Integer.MAX_VALUE) break;
            }
            if (doCheckFreqs && BasePostingsFormatTestCase.random().nextDouble() <= freqAskChance) {
                if (VERBOSE) {
                    System.out.println("    now freq()=" + expected.freq());
                }
                freq = postingsEnum.freq();
                BasePostingsFormatTestCase.assertEquals((String)"freq is wrong", (long)expected.freq(), (long)freq);
            }
            if (!doCheckPositions) continue;
            freq = postingsEnum.freq();
            int numPosToConsume = !alwaysTestMax && options.contains((Object)Option.PARTIAL_POS_CONSUME) && BasePostingsFormatTestCase.random().nextInt(5) == 1 ? BasePostingsFormatTestCase.random().nextInt(freq) : freq;
            for (int i = 0; i < numPosToConsume; ++i) {
                int pos = expected.nextPosition();
                if (VERBOSE) {
                    System.out.println("    now nextPosition to " + pos);
                }
                BasePostingsFormatTestCase.assertEquals((String)"position is wrong", (long)pos, (long)postingsEnum.nextPosition());
                if (doCheckPayloads) {
                    BytesRef expectedPayload = expected.getPayload();
                    if (BasePostingsFormatTestCase.random().nextDouble() <= payloadCheckChance) {
                        if (VERBOSE) {
                            System.out.println("      now check expectedPayload length=" + (expectedPayload == null ? 0 : expectedPayload.length));
                        }
                        if (expectedPayload == null || expectedPayload.length == 0) {
                            BasePostingsFormatTestCase.assertNull((String)"should not have payload", (Object)postingsEnum.getPayload());
                        } else {
                            BytesRef payload = postingsEnum.getPayload();
                            BasePostingsFormatTestCase.assertNotNull((String)"should have payload but doesn't", (Object)payload);
                            BasePostingsFormatTestCase.assertEquals((String)"payload length is wrong", (long)expectedPayload.length, (long)payload.length);
                            for (int byteUpto = 0; byteUpto < expectedPayload.length; ++byteUpto) {
                                BasePostingsFormatTestCase.assertEquals((String)"payload bytes are wrong", (long)expectedPayload.bytes[expectedPayload.offset + byteUpto], (long)payload.bytes[payload.offset + byteUpto]);
                            }
                            payload = BytesRef.deepCopyOf((BytesRef)payload);
                            BasePostingsFormatTestCase.assertEquals((String)"2nd call to getPayload returns something different!", (Object)payload, (Object)postingsEnum.getPayload());
                        }
                    } else if (VERBOSE) {
                        System.out.println("      skip check payload length=" + (expectedPayload == null ? 0 : expectedPayload.length));
                    }
                }
                if (doCheckOffsets) {
                    if (BasePostingsFormatTestCase.random().nextDouble() <= offsetCheckChance) {
                        if (VERBOSE) {
                            System.out.println("      now check offsets: startOff=" + expected.startOffset() + " endOffset=" + expected.endOffset());
                        }
                        BasePostingsFormatTestCase.assertEquals((String)"startOffset is wrong", (long)expected.startOffset(), (long)postingsEnum.startOffset());
                        BasePostingsFormatTestCase.assertEquals((String)"endOffset is wrong", (long)expected.endOffset(), (long)postingsEnum.endOffset());
                        continue;
                    }
                    if (!VERBOSE) continue;
                    System.out.println("      skip check offsets");
                    continue;
                }
                if (fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0) continue;
                if (VERBOSE) {
                    System.out.println("      now check offsets are -1");
                }
                BasePostingsFormatTestCase.assertEquals((String)"startOffset isn't -1", (long)-1L, (long)postingsEnum.startOffset());
                BasePostingsFormatTestCase.assertEquals((String)"endOffset isn't -1", (long)-1L, (long)postingsEnum.endOffset());
            }
        }
    }

    private void testTerms(Fields fieldsSource, EnumSet<Option> options, IndexOptions maxTestOptions, IndexOptions maxIndexOptions, boolean alwaysTestMax) throws Exception {
        if (options.contains((Object)Option.THREADS)) {
            int threadUpto;
            int numThreads = TestUtil.nextInt(BasePostingsFormatTestCase.random(), 2, 5);
            Thread[] threads = new Thread[numThreads];
            for (threadUpto = 0; threadUpto < numThreads; ++threadUpto) {
                threads[threadUpto] = new TestThread(this, fieldsSource, options, maxTestOptions, maxIndexOptions, alwaysTestMax);
                threads[threadUpto].start();
            }
            for (threadUpto = 0; threadUpto < numThreads; ++threadUpto) {
                threads[threadUpto].join();
            }
        } else {
            this.testTermsOneThread(fieldsSource, options, maxTestOptions, maxIndexOptions, alwaysTestMax);
        }
    }

    private void testTermsOneThread(Fields fieldsSource, EnumSet<Option> options, IndexOptions maxTestOptions, IndexOptions maxIndexOptions, boolean alwaysTestMax) throws IOException {
        ThreadState threadState = new ThreadState();
        ArrayList<TermState> termStates = new ArrayList<TermState>();
        ArrayList<FieldAndTerm> termStateTerms = new ArrayList<FieldAndTerm>();
        boolean supportsOrds = true;
        Collections.shuffle(allTerms, BasePostingsFormatTestCase.random());
        int upto = 0;
        while (upto < allTerms.size()) {
            long termOrd;
            FieldAndTerm fieldAndTerm;
            boolean useTermState = termStates.size() != 0 && BasePostingsFormatTestCase.random().nextInt(5) == 1;
            boolean useTermOrd = supportsOrds && !useTermState && BasePostingsFormatTestCase.random().nextInt(5) == 1;
            TermState termState = null;
            if (!useTermState) {
                fieldAndTerm = allTerms.get(upto++);
                if (VERBOSE) {
                    if (useTermOrd) {
                        System.out.println("\nTEST: seek to term=" + fieldAndTerm.field + ":" + fieldAndTerm.term.utf8ToString() + " using ord=" + fieldAndTerm.ord);
                    } else {
                        System.out.println("\nTEST: seek to term=" + fieldAndTerm.field + ":" + fieldAndTerm.term.utf8ToString());
                    }
                }
            } else {
                int idx = BasePostingsFormatTestCase.random().nextInt(termStates.size());
                fieldAndTerm = (FieldAndTerm)termStateTerms.get(idx);
                if (VERBOSE) {
                    System.out.println("\nTEST: seek using TermState to term=" + fieldAndTerm.field + ":" + fieldAndTerm.term.utf8ToString());
                }
                termState = (TermState)termStates.get(idx);
            }
            Terms terms = fieldsSource.terms(fieldAndTerm.field);
            BasePostingsFormatTestCase.assertNotNull((Object)terms);
            TermsEnum termsEnum = terms.iterator(null);
            if (!useTermState) {
                if (useTermOrd) {
                    try {
                        termsEnum.seekExact(fieldAndTerm.ord);
                    }
                    catch (UnsupportedOperationException uoe) {
                        supportsOrds = false;
                        BasePostingsFormatTestCase.assertTrue((boolean)termsEnum.seekExact(fieldAndTerm.term));
                    }
                } else {
                    BasePostingsFormatTestCase.assertTrue((boolean)termsEnum.seekExact(fieldAndTerm.term));
                }
            } else {
                termsEnum.seekExact(fieldAndTerm.term, termState);
            }
            if (supportsOrds) {
                try {
                    termOrd = termsEnum.ord();
                }
                catch (UnsupportedOperationException uoe) {
                    supportsOrds = false;
                    termOrd = -1L;
                }
            } else {
                termOrd = -1L;
            }
            if (termOrd != -1L) {
                BasePostingsFormatTestCase.assertEquals((long)fieldAndTerm.ord, (long)termsEnum.ord());
            }
            boolean savedTermState = false;
            if (options.contains((Object)Option.TERM_STATE) && !useTermState && BasePostingsFormatTestCase.random().nextInt(5) == 1) {
                termStates.add(termsEnum.termState());
                termStateTerms.add(fieldAndTerm);
                savedTermState = true;
            }
            this.verifyEnum(threadState, fieldAndTerm.field, fieldAndTerm.term, termsEnum, maxTestOptions, maxIndexOptions, options, alwaysTestMax);
            if (options.contains((Object)Option.TERM_STATE) && !useTermState && !savedTermState && BasePostingsFormatTestCase.random().nextInt(5) == 1) {
                termStates.add(termsEnum.termState());
                termStateTerms.add(fieldAndTerm);
                useTermState = true;
            }
            if (!alwaysTestMax && BasePostingsFormatTestCase.random().nextInt(10) != 7) continue;
            if (VERBOSE) {
                System.out.println("TEST: try enum again on same term");
            }
            this.verifyEnum(threadState, fieldAndTerm.field, fieldAndTerm.term, termsEnum, maxTestOptions, maxIndexOptions, options, alwaysTestMax);
        }
        for (String field : fields.keySet()) {
            BytesRef term;
            BytesRef startTerm;
            CompiledAutomaton ca;
            while (true) {
                Automaton a = AutomatonTestUtil.randomAutomaton(BasePostingsFormatTestCase.random());
                ca = new CompiledAutomaton(a, null, true, Integer.MAX_VALUE, false);
                if (ca.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) continue;
                startTerm = null;
                if (!BasePostingsFormatTestCase.random().nextBoolean()) break;
                AutomatonTestUtil.RandomAcceptedStrings ras = new AutomatonTestUtil.RandomAcceptedStrings(a);
                for (int iter = 0; iter < 100; ++iter) {
                    int[] codePoints = ras.getRandomAcceptedString(BasePostingsFormatTestCase.random());
                    if (codePoints.length == 0) continue;
                    startTerm = new BytesRef((CharSequence)UnicodeUtil.newString((int[])codePoints, (int)0, (int)codePoints.length));
                    break;
                }
                if (startTerm != null) break;
            }
            TermsEnum intersected = fieldsSource.terms(field).intersect(ca, startTerm);
            HashSet<BytesRef> intersectedTerms = new HashSet<BytesRef>();
            while ((term = intersected.next()) != null) {
                if (startTerm != null) {
                    BasePostingsFormatTestCase.assertTrue((startTerm.compareTo(term) < 0 ? 1 : 0) != 0);
                }
                intersectedTerms.add(BytesRef.deepCopyOf((BytesRef)term));
                this.verifyEnum(threadState, field, term, intersected, maxTestOptions, maxIndexOptions, options, alwaysTestMax);
            }
            if (ca.runAutomaton == null) {
                BasePostingsFormatTestCase.assertTrue((boolean)intersectedTerms.isEmpty());
                continue;
            }
            for (BytesRef term2 : fields.get(field).keySet()) {
                boolean expected = startTerm != null && startTerm.compareTo(term2) >= 0 ? false : ca.runAutomaton.run(term2.bytes, term2.offset, term2.length);
                BasePostingsFormatTestCase.assertEquals((String)("term=" + term2), (Object)expected, (Object)intersectedTerms.contains(term2));
            }
        }
    }

    private void testFields(Fields fields) throws Exception {
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            try {
                iterator.remove();
                BasePostingsFormatTestCase.fail((String)"Fields.iterator() allows for removal");
            }
            catch (UnsupportedOperationException expected) {}
        }
        BasePostingsFormatTestCase.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            BasePostingsFormatTestCase.fail((String)"Fields.iterator() doesn't throw NoSuchElementException when past the end");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void testFull(IndexOptions options, boolean withPayloads) throws Exception {
        Path path = BasePostingsFormatTestCase.createTempDir("testPostingsFormat.testExact");
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newFSDirectory(path);
        FieldsProducer fieldsProducer = this.buildIndex((Directory)dir, options, withPayloads, true);
        this.testFields((Fields)fieldsProducer);
        IndexOptions[] allOptions = IndexOptions.values();
        int maxIndexOption = Arrays.asList(allOptions).indexOf(options);
        for (int i = 0; i <= maxIndexOption; ++i) {
            this.testTerms((Fields)fieldsProducer, EnumSet.allOf(Option.class), allOptions[i], options, true);
            if (!withPayloads) continue;
            this.testTerms((Fields)fieldsProducer, EnumSet.complementOf(EnumSet.of(Option.PAYLOADS)), allOptions[i], options, true);
        }
        fieldsProducer.close();
        dir.close();
        IOUtils.rm((Path[])new Path[]{path});
    }

    public void testDocsOnly() throws Exception {
        this.testFull(IndexOptions.DOCS, false);
    }

    public void testDocsAndFreqs() throws Exception {
        this.testFull(IndexOptions.DOCS_AND_FREQS, false);
    }

    public void testDocsAndFreqsAndPositions() throws Exception {
        this.testFull(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, false);
    }

    public void testDocsAndFreqsAndPositionsAndPayloads() throws Exception {
        this.testFull(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, true);
    }

    public void testDocsAndFreqsAndPositionsAndOffsets() throws Exception {
        this.testFull(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, false);
    }

    public void testDocsAndFreqsAndPositionsAndOffsetsAndPayloads() throws Exception {
        this.testFull(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, true);
    }

    public void testRandom() throws Exception {
        int iters = 5;
        for (int iter = 0; iter < iters; ++iter) {
            Path path = BasePostingsFormatTestCase.createTempDir("testPostingsFormat");
            BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newFSDirectory(path);
            boolean indexPayloads = BasePostingsFormatTestCase.random().nextBoolean();
            FieldsProducer fieldsProducer = this.buildIndex((Directory)dir, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, indexPayloads, false);
            this.testFields((Fields)fieldsProducer);
            this.testTerms((Fields)fieldsProducer, EnumSet.allOf(Option.class), IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, false);
            fieldsProducer.close();
            fieldsProducer = null;
            dir.close();
            IOUtils.rm((Path[])new Path[]{path});
        }
    }

    protected boolean isPostingsEnumReuseImplemented() {
        return true;
    }

    public void testPostingsEnumReuse() throws Exception {
        Path path = BasePostingsFormatTestCase.createTempDir("testPostingsEnumReuse");
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newFSDirectory(path);
        FieldsProducer fieldsProducer = this.buildIndex((Directory)dir, IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS, BasePostingsFormatTestCase.random().nextBoolean(), true);
        Collections.shuffle(allTerms, BasePostingsFormatTestCase.random());
        FieldAndTerm fieldAndTerm = allTerms.get(0);
        Terms terms = fieldsProducer.terms(fieldAndTerm.field);
        TermsEnum te = terms.iterator(null);
        te.seekExact(fieldAndTerm.term);
        BasePostingsFormatTestCase.checkReuse(te, 8, 120, false);
        if (this.isPostingsEnumReuseImplemented()) {
            BasePostingsFormatTestCase.checkReuse(te, 120, 120, true);
        }
        fieldsProducer.close();
        dir.close();
        IOUtils.rm((Path[])new Path[]{path});
    }

    protected static void checkReuse(TermsEnum termsEnum, int firstFlags, int secondFlags, boolean shouldReuse) throws IOException {
        PostingsEnum postings1 = termsEnum.postings(null, null, firstFlags);
        PostingsEnum postings2 = termsEnum.postings(null, postings1, secondFlags);
        if (shouldReuse) {
            BasePostingsFormatTestCase.assertSame((String)("Expected PostingsEnum " + postings1.getClass().getName() + " to be reused"), (Object)postings1, (Object)postings2);
        } else {
            BasePostingsFormatTestCase.assertNotSame((String)("Expected PostingsEnum " + postings1.getClass().getName() + " to not be reused"), (Object)postings1, (Object)postings2);
        }
    }

    public void testJustEmptyField() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(null);
        iwc.setCodec(this.getCodec());
        RandomIndexWriter iw = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)BasePostingsFormatTestCase.newStringField("", "something", Field.Store.NO));
        iw.addDocument(doc);
        DirectoryReader ir = iw.getReader();
        SegmentReader ar = BasePostingsFormatTestCase.getOnlySegmentReader(ir);
        Fields fields = ar.fields();
        int fieldCount = fields.size();
        BasePostingsFormatTestCase.assertTrue((fieldCount == 1 || fieldCount == -1 ? 1 : 0) != 0);
        Terms terms = ar.terms("");
        BasePostingsFormatTestCase.assertNotNull((Object)terms);
        TermsEnum termsEnum = terms.iterator(null);
        BasePostingsFormatTestCase.assertNotNull((Object)termsEnum.next());
        BasePostingsFormatTestCase.assertEquals((Object)termsEnum.term(), (Object)new BytesRef((CharSequence)"something"));
        BasePostingsFormatTestCase.assertNull((Object)termsEnum.next());
        ir.close();
        iw.close();
        dir.close();
    }

    public void testEmptyFieldAndEmptyTerm() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(null);
        iwc.setCodec(this.getCodec());
        RandomIndexWriter iw = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)BasePostingsFormatTestCase.newStringField("", "", Field.Store.NO));
        iw.addDocument(doc);
        DirectoryReader ir = iw.getReader();
        SegmentReader ar = BasePostingsFormatTestCase.getOnlySegmentReader(ir);
        Fields fields = ar.fields();
        int fieldCount = fields.size();
        BasePostingsFormatTestCase.assertTrue((fieldCount == 1 || fieldCount == -1 ? 1 : 0) != 0);
        Terms terms = ar.terms("");
        BasePostingsFormatTestCase.assertNotNull((Object)terms);
        TermsEnum termsEnum = terms.iterator(null);
        BasePostingsFormatTestCase.assertNotNull((Object)termsEnum.next());
        BasePostingsFormatTestCase.assertEquals((Object)termsEnum.term(), (Object)new BytesRef((CharSequence)""));
        BasePostingsFormatTestCase.assertNull((Object)termsEnum.next());
        ir.close();
        iw.close();
        dir.close();
    }

    public void testDidntWantFreqsButAskedAnyway() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BasePostingsFormatTestCase.random()));
        iwc.setCodec(this.getCodec());
        RandomIndexWriter iw = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)BasePostingsFormatTestCase.newTextField("field", "value", Field.Store.NO));
        iw.addDocument(doc);
        iw.addDocument(doc);
        DirectoryReader ir = iw.getReader();
        SegmentReader ar = BasePostingsFormatTestCase.getOnlySegmentReader(ir);
        TermsEnum termsEnum = ar.terms("field").iterator(null);
        BasePostingsFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"value")));
        PostingsEnum docsEnum = termsEnum.postings(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.freq());
        ir.close();
        iw.close();
        dir.close();
    }

    public void testAskForPositionsWhenNotThere() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(new MockAnalyzer(BasePostingsFormatTestCase.random()));
        iwc.setCodec(this.getCodec());
        RandomIndexWriter iw = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)BasePostingsFormatTestCase.newStringField("field", "value", Field.Store.NO));
        iw.addDocument(doc);
        iw.addDocument(doc);
        DirectoryReader ir = iw.getReader();
        SegmentReader ar = BasePostingsFormatTestCase.getOnlySegmentReader(ir);
        TermsEnum termsEnum = ar.terms("field").iterator(null);
        BasePostingsFormatTestCase.assertTrue((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"value")));
        PostingsEnum docsEnum = termsEnum.postings(null, null, 24);
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsEnum.freq());
        ir.close();
        iw.close();
        dir.close();
    }

    public void testGhosts() throws Exception {
        TermsEnum termsEnum;
        BytesRef term;
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(null);
        iwc.setCodec(this.getCodec());
        iwc.setMergePolicy((MergePolicy)BasePostingsFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iw = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        Document doc = new Document();
        iw.addDocument(doc);
        doc.add((IndexableField)BasePostingsFormatTestCase.newStringField("ghostField", "something", Field.Store.NO));
        iw.addDocument(doc);
        iw.forceMerge(1);
        iw.deleteDocuments(new Term("ghostField", "something"));
        iw.forceMerge(1);
        DirectoryReader ir = iw.getReader();
        SegmentReader ar = BasePostingsFormatTestCase.getOnlySegmentReader(ir);
        Fields fields = ar.fields();
        BasePostingsFormatTestCase.assertTrue((fields.size() <= 1 ? 1 : 0) != 0);
        Terms terms = fields.terms("ghostField");
        if (terms != null && (term = (termsEnum = terms.iterator(null)).next()) != null) {
            PostingsEnum postingsEnum = termsEnum.postings(null, null);
            BasePostingsFormatTestCase.assertTrue((postingsEnum.nextDoc() == Integer.MAX_VALUE ? 1 : 0) != 0);
        }
        ir.close();
        iw.close();
        dir.close();
    }

    public void testInvertedWrite() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BasePostingsFormatTestCase.random());
        analyzer.setMaxTokenLength(TestUtil.nextInt(BasePostingsFormatTestCase.random(), 1, 32766));
        IndexWriterConfig iwc = BasePostingsFormatTestCase.newIndexWriterConfig(analyzer);
        final ConcurrentHashMap termFreqs = new ConcurrentHashMap();
        final AtomicLong sumDocFreq = new AtomicLong();
        final AtomicLong sumTotalTermFreq = new AtomicLong();
        iwc.setCodec((Codec)new AssertingCodec(){

            @Override
            public PostingsFormat getPostingsFormatForField(String field) {
                PostingsFormat p = BasePostingsFormatTestCase.this.getCodec().postingsFormat();
                if (p instanceof PerFieldPostingsFormat) {
                    p = ((PerFieldPostingsFormat)p).getPostingsFormatForField(field);
                }
                final PostingsFormat defaultPostingsFormat = p;
                final Thread mainThread = Thread.currentThread();
                if (field.equals("body")) {
                    return new PostingsFormat(defaultPostingsFormat.getName()){

                        public FieldsConsumer fieldsConsumer(final SegmentWriteState state) throws IOException {
                            final FieldsConsumer fieldsConsumer = defaultPostingsFormat.fieldsConsumer(state);
                            return new FieldsConsumer(){

                                public void write(Fields fields) throws IOException {
                                    boolean isMerge;
                                    fieldsConsumer.write(fields);
                                    boolean bl = isMerge = state.context.context == IOContext.Context.MERGE;
                                    assert (isMerge || Thread.currentThread() == mainThread);
                                    boolean addOnSecondPass = LuceneTestCase.random().nextBoolean();
                                    Terms terms = fields.terms("body");
                                    assert (terms != null);
                                    TermsEnum termsEnum = terms.iterator(null);
                                    PostingsEnum docs = null;
                                    while (termsEnum.next() != null) {
                                        BytesRef term = termsEnum.term();
                                        boolean noPositions = LuceneTestCase.random().nextBoolean();
                                        docs = noPositions ? termsEnum.postings(null, docs, 8) : termsEnum.postings(null, null, 24);
                                        int docFreq = 0;
                                        long totalTermFreq = 0L;
                                        while (docs.nextDoc() != Integer.MAX_VALUE) {
                                            ++docFreq;
                                            totalTermFreq += (long)docs.freq();
                                            int limit = TestUtil.nextInt(LuceneTestCase.random(), 1, docs.freq());
                                            if (noPositions) continue;
                                            for (int i = 0; i < limit; ++i) {
                                                docs.nextPosition();
                                            }
                                        }
                                        String termString = term.utf8ToString();
                                        Assert.assertTrue((!isMerge || termFreqs.containsKey(termString) ? 1 : 0) != 0);
                                        if (isMerge) continue;
                                        if (!addOnSecondPass) {
                                            TermFreqs tf = (TermFreqs)termFreqs.get(termString);
                                            if (tf == null) {
                                                tf = new TermFreqs();
                                                termFreqs.put(termString, tf);
                                            }
                                            tf.docFreq += docFreq;
                                            tf.totalTermFreq += totalTermFreq;
                                            sumDocFreq.addAndGet(docFreq);
                                            sumTotalTermFreq.addAndGet(totalTermFreq);
                                            continue;
                                        }
                                        if (termFreqs.containsKey(termString)) continue;
                                        termFreqs.put(termString, new TermFreqs());
                                    }
                                    for (String term : termFreqs.keySet()) {
                                        if (!termsEnum.seekExact(new BytesRef((CharSequence)term))) continue;
                                        boolean noPositions = LuceneTestCase.random().nextBoolean();
                                        docs = noPositions ? termsEnum.postings(null, docs, 8) : termsEnum.postings(null, null, 24);
                                        int docFreq = 0;
                                        long totalTermFreq = 0L;
                                        while (docs.nextDoc() != Integer.MAX_VALUE) {
                                            ++docFreq;
                                            totalTermFreq += (long)docs.freq();
                                            int limit = TestUtil.nextInt(LuceneTestCase.random(), 1, docs.freq());
                                            if (noPositions) continue;
                                            for (int i = 0; i < limit; ++i) {
                                                docs.nextPosition();
                                            }
                                        }
                                        if (!isMerge && addOnSecondPass) {
                                            TermFreqs tf = (TermFreqs)termFreqs.get(term);
                                            assert (tf != null);
                                            tf.docFreq += docFreq;
                                            tf.totalTermFreq += totalTermFreq;
                                            sumDocFreq.addAndGet(docFreq);
                                            sumTotalTermFreq.addAndGet(totalTermFreq);
                                        }
                                        Assert.assertTrue((docFreq <= ((TermFreqs)termFreqs.get((Object)term)).docFreq ? 1 : 0) != 0);
                                        Assert.assertTrue((totalTermFreq <= ((TermFreqs)termFreqs.get((Object)term)).totalTermFreq ? 1 : 0) != 0);
                                    }
                                    for (int iter = 0; iter < 10; ++iter) {
                                        BytesRef term = new BytesRef((CharSequence)TestUtil.randomRealisticUnicodeString(LuceneTestCase.random()));
                                        TermsEnum.SeekStatus status = termsEnum.seekCeil(term);
                                        if (status != TermsEnum.SeekStatus.NOT_FOUND) continue;
                                        Assert.assertTrue((term.compareTo(termsEnum.term()) < 0 ? 1 : 0) != 0);
                                    }
                                }

                                public void close() throws IOException {
                                    fieldsConsumer.close();
                                }
                            };
                        }

                        public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
                            return defaultPostingsFormat.fieldsProducer(state);
                        }
                    };
                }
                return defaultPostingsFormat;
            }
        });
        RandomIndexWriter w = new RandomIndexWriter(BasePostingsFormatTestCase.random(), (Directory)dir, iwc);
        LineFileDocs docs = new LineFileDocs(BasePostingsFormatTestCase.random());
        int bytesToIndex = BasePostingsFormatTestCase.atLeast(100) * 1024;
        int bytesIndexed = 0;
        while (bytesIndexed < bytesToIndex) {
            Document doc = docs.nextDoc();
            w.addDocument(doc);
            bytesIndexed = (int)((long)bytesIndexed + RamUsageTester.sizeOf(doc));
        }
        DirectoryReader r = w.getReader();
        w.close();
        Terms terms = MultiFields.getTerms((IndexReader)r, (String)"body");
        BasePostingsFormatTestCase.assertEquals((long)sumDocFreq.get(), (long)terms.getSumDocFreq());
        BasePostingsFormatTestCase.assertEquals((long)sumTotalTermFreq.get(), (long)terms.getSumTotalTermFreq());
        TermsEnum termsEnum = terms.iterator(null);
        long termCount = 0L;
        boolean supportsOrds = true;
        while (termsEnum.next() != null) {
            BytesRef term = termsEnum.term();
            BasePostingsFormatTestCase.assertEquals((long)((TermFreqs)termFreqs.get((Object)term.utf8ToString())).docFreq, (long)termsEnum.docFreq());
            BasePostingsFormatTestCase.assertEquals((long)((TermFreqs)termFreqs.get((Object)term.utf8ToString())).totalTermFreq, (long)termsEnum.totalTermFreq());
            if (supportsOrds) {
                long ord;
                try {
                    ord = termsEnum.ord();
                }
                catch (UnsupportedOperationException uoe) {
                    supportsOrds = false;
                    ord = -1L;
                }
                if (ord != -1L) {
                    BasePostingsFormatTestCase.assertEquals((long)termCount, (long)ord);
                }
            }
            ++termCount;
        }
        BasePostingsFormatTestCase.assertEquals((long)termFreqs.size(), (long)termCount);
        r.close();
        dir.close();
    }

    protected void assertReused(String field, PostingsEnum p1, PostingsEnum p2) {
        if (!"Direct".equals(TestUtil.getPostingsFormat(field))) {
            BasePostingsFormatTestCase.assertSame((Object)p1, (Object)p2);
        }
    }

    public void testPostingsEnumDocsOnly() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("foo", "bar", Field.Store.NO));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        for (int flag : new int[]{0, 8, 24, 88, 56, 120}) {
            postings = termsEnum.postings(null, null, flag);
            BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
            BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
            BasePostingsFormatTestCase.assertEquals((long)1L, (long)postings.freq());
            BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
            postings2 = termsEnum.postings(null, postings, flag);
            BasePostingsFormatTestCase.assertNotNull((Object)postings2);
            this.assertReused("foo", postings, postings2);
            BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
            BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
            BasePostingsFormatTestCase.assertEquals((long)1L, (long)postings2.freq());
            BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        }
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumFreqs() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
        doc.add((IndexableField)new Field("foo", "bar bar", ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", docsOnly, docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        for (int flag : new int[]{0, 8, 24, 88, 56, 120}) {
            postings = termsEnum.postings(null, null, flag);
            BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
            BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
            if (flag != 0) {
                BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
            }
            BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
            postings2 = termsEnum.postings(null, postings, flag);
            BasePostingsFormatTestCase.assertNotNull((Object)postings2);
            this.assertReused("foo", postings, postings2);
            BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
            BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
            if (flag != 0) {
                BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
            }
            BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        }
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumPositions() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)new TextField("foo", "bar bar", Field.Store.NO));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", docsOnly, docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 24);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 24);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 88);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 88);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 56);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 56);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 120);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 120);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumOffsets() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        doc.add((IndexableField)new Field("foo", "bar bar", ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", docsOnly, docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 24);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 24);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 88);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 88);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 56);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 56);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 120);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 120);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumPayloads() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        Token token1 = new Token((CharSequence)"bar", 0, 3);
        token1.setPayload(new BytesRef((CharSequence)"pay1"));
        Token token2 = new Token((CharSequence)"bar", 4, 7);
        token2.setPayload(new BytesRef((CharSequence)"pay2"));
        doc.add((IndexableField)new TextField("foo", (TokenStream)new CannedTokenStream(token1, token2)));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", docsOnly, docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 24);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 24);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 88);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 88);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 56);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 56);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 120);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 120);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    public void testPostingsEnumAll() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        Token token1 = new Token((CharSequence)"bar", 0, 3);
        token1.setPayload(new BytesRef((CharSequence)"pay1"));
        Token token2 = new Token((CharSequence)"bar", 4, 7);
        token2.setPayload(new BytesRef((CharSequence)"pay2"));
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        doc.add((IndexableField)new Field("foo", (TokenStream)new CannedTokenStream(token1, token2), ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        PostingsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        PostingsEnum postings2 = termsEnum.postings(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", postings, postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        PostingsEnum docsOnly = termsEnum.postings(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        PostingsEnum docsOnly2 = termsEnum.postings(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", docsOnly, docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        PostingsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 24);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        PostingsEnum docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 24);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 88);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 88);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 56);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 56);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).postings(new Term("foo", "bar"), 120);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.postings(null, docsAndPositionsEnum, 120);
        this.assertReused("foo", docsAndPositionsEnum, docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    @Deprecated
    public void testLegacyEnumDocsOnly() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("foo", "bar", Field.Store.NO));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        DocsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termDocsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        DocsEnum postings2 = termsEnum.docs(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", (PostingsEnum)postings, (PostingsEnum)postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        DocsEnum docsOnly = termsEnum.docs(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsOnly.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        DocsEnum docsOnly2 = termsEnum.docs(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", (PostingsEnum)docsOnly, (PostingsEnum)docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsOnly2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        DocsAndPositionsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termPositionsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum);
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum);
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 2);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum);
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 1);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum);
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 3);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum);
        iw.close();
        reader.close();
        dir.close();
    }

    @Deprecated
    public void testLegacyEnumFreqs() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
        doc.add((IndexableField)new Field("foo", "bar bar", ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        DocsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termDocsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        DocsEnum postings2 = termsEnum.docs(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", (PostingsEnum)postings, (PostingsEnum)postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        DocsEnum docsOnly = termsEnum.docs(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        DocsEnum docsOnly2 = termsEnum.docs(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", (PostingsEnum)docsOnly, (PostingsEnum)docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        DocsAndPositionsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termPositionsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum);
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum);
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 2);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum);
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 1);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum);
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 3);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum);
        iw.close();
        reader.close();
        dir.close();
    }

    @Deprecated
    public void testLegacyEnumPositions() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        doc.add((IndexableField)new TextField("foo", "bar bar", Field.Store.NO));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        DocsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termDocsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        DocsEnum postings2 = termsEnum.docs(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", (PostingsEnum)postings, (PostingsEnum)postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        DocsEnum docsOnly = termsEnum.docs(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        DocsEnum docsOnly2 = termsEnum.docs(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", (PostingsEnum)docsOnly, (PostingsEnum)docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        DocsAndPositionsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termPositionsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        DocsAndPositionsEnum docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 2);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 2);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 1);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 1);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 3);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 3);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    @Deprecated
    public void testLegacyEnumOffsets() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer());
            }
        });
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        doc.add((IndexableField)new Field("foo", "bar bar", ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        DocsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termDocsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        DocsEnum postings2 = termsEnum.docs(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", (PostingsEnum)postings, (PostingsEnum)postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        DocsEnum docsOnly = termsEnum.docs(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        DocsEnum docsOnly2 = termsEnum.docs(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", (PostingsEnum)docsOnly, (PostingsEnum)docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        DocsAndPositionsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termPositionsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        DocsAndPositionsEnum docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 2);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 2);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 1);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 1);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 3);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 3);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertNull((Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    @Deprecated
    public void testLegacyEnumPayloads() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        Token token1 = new Token((CharSequence)"bar", 0, 3);
        token1.setPayload(new BytesRef((CharSequence)"pay1"));
        Token token2 = new Token((CharSequence)"bar", 4, 7);
        token2.setPayload(new BytesRef((CharSequence)"pay2"));
        doc.add((IndexableField)new TextField("foo", (TokenStream)new CannedTokenStream(token1, token2)));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        DocsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termDocsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        DocsEnum postings2 = termsEnum.docs(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", (PostingsEnum)postings, (PostingsEnum)postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        DocsEnum docsOnly = termsEnum.docs(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        DocsEnum docsOnly2 = termsEnum.docs(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", (PostingsEnum)docsOnly, (PostingsEnum)docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        DocsAndPositionsEnum docsAndPositionsEnum = termsEnum.docsAndPositions(null, null);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        DocsAndPositionsEnum docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 2);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 2);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 1);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 1);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 3);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 3);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    @Deprecated
    public void testLegacyEnumAll() throws Exception {
        BaseDirectoryWrapper dir = BasePostingsFormatTestCase.newDirectory();
        IndexWriterConfig iwc = new IndexWriterConfig(null);
        IndexWriter iw = new IndexWriter((Directory)dir, iwc);
        Document doc = new Document();
        Token token1 = new Token((CharSequence)"bar", 0, 3);
        token1.setPayload(new BytesRef((CharSequence)"pay1"));
        Token token2 = new Token((CharSequence)"bar", 4, 7);
        token2.setPayload(new BytesRef((CharSequence)"pay2"));
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        doc.add((IndexableField)new Field("foo", (TokenStream)new CannedTokenStream(token1, token2), ft));
        iw.addDocument((Iterable)doc);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)iw, (boolean)false);
        DocsEnum postings = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termDocsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings.nextDoc());
        TermsEnum termsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).terms("foo").iterator(null);
        termsEnum.seekExact(new BytesRef((CharSequence)"bar"));
        DocsEnum postings2 = termsEnum.docs(null, postings);
        BasePostingsFormatTestCase.assertNotNull((Object)postings2);
        this.assertReused("foo", (PostingsEnum)postings, (PostingsEnum)postings2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)postings2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)postings2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)postings2.freq());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)postings2.nextDoc());
        DocsEnum docsOnly = termsEnum.docs(null, null, 0);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly.freq() == 1 || docsOnly.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly.nextDoc());
        DocsEnum docsOnly2 = termsEnum.docs(null, docsOnly, 0);
        BasePostingsFormatTestCase.assertNotNull((Object)docsOnly2);
        this.assertReused("foo", (PostingsEnum)docsOnly, (PostingsEnum)docsOnly2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsOnly2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsOnly2.nextDoc());
        BasePostingsFormatTestCase.assertTrue((docsOnly2.freq() == 1 || docsOnly2.freq() == 2 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsOnly2.nextDoc());
        DocsAndPositionsEnum docsAndPositionsEnum = BasePostingsFormatTestCase.getOnlySegmentReader(reader).termPositionsEnum(new Term("foo", "bar"));
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        DocsAndPositionsEnum docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 2);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.startOffset() == -1 || docsAndPositionsEnum.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.endOffset() == -1 || docsAndPositionsEnum.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 2);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 0 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 3 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.startOffset() == -1 || docsAndPositionsEnum2.startOffset() == 4 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.endOffset() == -1 || docsAndPositionsEnum2.endOffset() == 7 ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 1);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 1);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay1").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertTrue((docsAndPositionsEnum2.getPayload() == null || new BytesRef((CharSequence)"pay2").equals((Object)docsAndPositionsEnum2.getPayload()) ? 1 : 0) != 0);
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        docsAndPositionsEnum = termsEnum.docsAndPositions(null, null, 3);
        BasePostingsFormatTestCase.assertNotNull((Object)docsAndPositionsEnum);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum.nextDoc());
        docsAndPositionsEnum2 = termsEnum.docsAndPositions(null, docsAndPositionsEnum, 3);
        this.assertReused("foo", (PostingsEnum)docsAndPositionsEnum, (PostingsEnum)docsAndPositionsEnum2);
        BasePostingsFormatTestCase.assertEquals((long)-1L, (long)docsAndPositionsEnum2.docID());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextDoc());
        BasePostingsFormatTestCase.assertEquals((long)2L, (long)docsAndPositionsEnum2.freq());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)0L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)3L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay1"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)1L, (long)docsAndPositionsEnum2.nextPosition());
        BasePostingsFormatTestCase.assertEquals((long)4L, (long)docsAndPositionsEnum2.startOffset());
        BasePostingsFormatTestCase.assertEquals((long)7L, (long)docsAndPositionsEnum2.endOffset());
        BasePostingsFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"pay2"), (Object)docsAndPositionsEnum2.getPayload());
        BasePostingsFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)docsAndPositionsEnum2.nextDoc());
        iw.close();
        reader.close();
        dir.close();
    }

    @Override
    protected void addRandomFields(Document doc) {
        for (IndexOptions opts : IndexOptions.values()) {
            if (opts == IndexOptions.NONE) continue;
            FieldType ft = new FieldType();
            ft.setIndexOptions(opts);
            ft.freeze();
            int numFields = BasePostingsFormatTestCase.random().nextInt(5);
            for (int j = 0; j < numFields; ++j) {
                doc.add((IndexableField)new Field("f_" + opts, TestUtil.randomSimpleString(BasePostingsFormatTestCase.random(), 2), ft));
            }
        }
    }

    private static class TermFreqs {
        long totalTermFreq;
        int docFreq;

        private TermFreqs() {
        }
    }

    private static class TestThread
    extends Thread {
        private Fields fieldsSource;
        private EnumSet<Option> options;
        private IndexOptions maxIndexOptions;
        private IndexOptions maxTestOptions;
        private boolean alwaysTestMax;
        private BasePostingsFormatTestCase testCase;

        public TestThread(BasePostingsFormatTestCase testCase, Fields fieldsSource, EnumSet<Option> options, IndexOptions maxTestOptions, IndexOptions maxIndexOptions, boolean alwaysTestMax) {
            this.fieldsSource = fieldsSource;
            this.options = options;
            this.maxTestOptions = maxTestOptions;
            this.maxIndexOptions = maxIndexOptions;
            this.alwaysTestMax = alwaysTestMax;
            this.testCase = testCase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    this.testCase.testTermsOneThread(this.fieldsSource, this.options, this.maxTestOptions, this.maxIndexOptions, this.alwaysTestMax);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            finally {
                this.fieldsSource = null;
                this.testCase = null;
            }
        }
    }

    private static class ThreadState {
        public PostingsEnum reusePostingsEnum;

        private ThreadState() {
        }
    }

    private static class SeedTermsEnum
    extends TermsEnum {
        final SortedMap<BytesRef, SeedAndOrd> terms;
        final IndexOptions maxAllowed;
        final boolean allowPayloads;
        private Iterator<Map.Entry<BytesRef, SeedAndOrd>> iterator;
        private Map.Entry<BytesRef, SeedAndOrd> current;

        public SeedTermsEnum(SortedMap<BytesRef, SeedAndOrd> terms, IndexOptions maxAllowed, boolean allowPayloads) {
            this.terms = terms;
            this.maxAllowed = maxAllowed;
            this.allowPayloads = allowPayloads;
        }

        void reset() {
            this.iterator = this.terms.entrySet().iterator();
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) {
            SortedMap<BytesRef, SeedAndOrd> tailMap = this.terms.tailMap(text);
            if (tailMap.isEmpty()) {
                return TermsEnum.SeekStatus.END;
            }
            this.iterator = tailMap.entrySet().iterator();
            if (tailMap.firstKey().equals((Object)text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        public BytesRef next() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return this.term();
            }
            return null;
        }

        public void seekExact(long ord) {
            throw new UnsupportedOperationException();
        }

        public BytesRef term() {
            return this.current.getKey();
        }

        public long ord() {
            return this.current.getValue().ord;
        }

        public int docFreq() {
            throw new UnsupportedOperationException();
        }

        public long totalTermFreq() {
            throw new UnsupportedOperationException();
        }

        public final PostingsEnum postings(Bits liveDocs, PostingsEnum reuse, int flags) throws IOException {
            if (liveDocs != null) {
                throw new IllegalArgumentException("liveDocs must be null");
            }
            if (PostingsEnum.featureRequested((int)flags, (short)24)) {
                if (this.maxAllowed.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    return null;
                }
                if (PostingsEnum.featureRequested((int)flags, (short)56) && this.maxAllowed.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) < 0) {
                    return null;
                }
                if (PostingsEnum.featureRequested((int)flags, (short)88) && !this.allowPayloads) {
                    return null;
                }
            }
            if (PostingsEnum.featureRequested((int)flags, (short)8) && this.maxAllowed.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) < 0) {
                return null;
            }
            return BasePostingsFormatTestCase.getSeedPostings(this.current.getKey().utf8ToString(), this.current.getValue().seed, false, this.maxAllowed, this.allowPayloads);
        }
    }

    private static class SeedTerms
    extends Terms {
        final SortedMap<BytesRef, SeedAndOrd> terms;
        final FieldInfo fieldInfo;
        final IndexOptions maxAllowed;
        final boolean allowPayloads;

        public SeedTerms(SortedMap<BytesRef, SeedAndOrd> terms, FieldInfo fieldInfo, IndexOptions maxAllowed, boolean allowPayloads) {
            this.terms = terms;
            this.fieldInfo = fieldInfo;
            this.maxAllowed = maxAllowed;
            this.allowPayloads = allowPayloads;
        }

        public TermsEnum iterator(TermsEnum reuse) {
            SeedTermsEnum termsEnum;
            if (reuse != null && reuse instanceof SeedTermsEnum) {
                termsEnum = (SeedTermsEnum)reuse;
                if (termsEnum.terms != this.terms) {
                    termsEnum = new SeedTermsEnum(this.terms, this.maxAllowed, this.allowPayloads);
                }
            } else {
                termsEnum = new SeedTermsEnum(this.terms, this.maxAllowed, this.allowPayloads);
            }
            termsEnum.reset();
            return termsEnum;
        }

        public long size() {
            return this.terms.size();
        }

        public long getSumTotalTermFreq() {
            throw new UnsupportedOperationException();
        }

        public long getSumDocFreq() {
            throw new UnsupportedOperationException();
        }

        public int getDocCount() {
            throw new UnsupportedOperationException();
        }

        public boolean hasFreqs() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        public boolean hasOffsets() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        public boolean hasPositions() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        public boolean hasPayloads() {
            return this.allowPayloads && this.fieldInfo.hasPayloads();
        }
    }

    private static class SeedFields
    extends Fields {
        final Map<String, SortedMap<BytesRef, SeedAndOrd>> fields;
        final FieldInfos fieldInfos;
        final IndexOptions maxAllowed;
        final boolean allowPayloads;

        public SeedFields(Map<String, SortedMap<BytesRef, SeedAndOrd>> fields, FieldInfos fieldInfos, IndexOptions maxAllowed, boolean allowPayloads) {
            this.fields = fields;
            this.fieldInfos = fieldInfos;
            this.maxAllowed = maxAllowed;
            this.allowPayloads = allowPayloads;
        }

        public Iterator<String> iterator() {
            return this.fields.keySet().iterator();
        }

        public Terms terms(String field) {
            SortedMap<BytesRef, SeedAndOrd> terms = this.fields.get(field);
            if (terms == null) {
                return null;
            }
            return new SeedTerms(terms, this.fieldInfos.fieldInfo(field), this.maxAllowed, this.allowPayloads);
        }

        public int size() {
            return this.fields.size();
        }
    }

    private static class SeedAndOrd {
        final long seed;
        long ord;

        public SeedAndOrd(long seed) {
            this.seed = seed;
        }
    }

    private static class FieldAndTerm {
        final String field;
        final BytesRef term;
        final long ord;

        public FieldAndTerm(String field, BytesRef term, long ord) {
            this.field = field;
            this.term = BytesRef.deepCopyOf((BytesRef)term);
            this.ord = ord;
        }
    }

    private static class SeedPostings
    extends PostingsEnum {
        private final Random docRandom;
        private final Random random;
        public int docFreq;
        private final int maxDocSpacing;
        private final int payloadSize;
        private final boolean fixedPayloads;
        private final Bits liveDocs;
        private final BytesRef payload;
        private final IndexOptions options;
        private final boolean doPositions;
        private final boolean allowPayloads;
        private int docID;
        private int freq;
        public int upto;
        private int pos;
        private int offset;
        private int startOffset;
        private int endOffset;
        private int posSpacing;
        private int posUpto;

        public SeedPostings(long seed, int minDocFreq, int maxDocFreq, Bits liveDocs, IndexOptions options, boolean allowPayloads) {
            this.random = new Random(seed);
            this.docRandom = new Random(this.random.nextLong());
            this.docFreq = TestUtil.nextInt(this.random, minDocFreq, maxDocFreq);
            this.liveDocs = liveDocs;
            this.allowPayloads = allowPayloads;
            this.maxDocSpacing = TestUtil.nextInt(this.random, 1, 100);
            this.payloadSize = this.random.nextInt(10) == 7 ? 1 + this.random.nextInt(3) : 1 + this.random.nextInt(1);
            this.fixedPayloads = this.random.nextBoolean();
            byte[] payloadBytes = new byte[this.payloadSize];
            this.payload = new BytesRef(payloadBytes);
            this.options = options;
            this.doPositions = IndexOptions.DOCS_AND_FREQS_AND_POSITIONS.compareTo((Enum)options) <= 0;
        }

        public int nextDoc() {
            do {
                this._nextDoc();
            } while (this.liveDocs != null && this.docID != Integer.MAX_VALUE && !this.liveDocs.get(this.docID));
            return this.docID;
        }

        private int _nextDoc() {
            while (this.posUpto < this.freq) {
                this.nextPosition();
            }
            if (this.upto < this.docFreq) {
                if (this.upto != 0 || !this.docRandom.nextBoolean()) {
                    this.docID = this.maxDocSpacing == 1 ? ++this.docID : (this.docID += TestUtil.nextInt(this.docRandom, 1, this.maxDocSpacing));
                }
                this.freq = this.random.nextInt(200) == 17 ? TestUtil.nextInt(this.random, 1, 1000) : (this.random.nextInt(10) == 17 ? TestUtil.nextInt(this.random, 1, 20) : TestUtil.nextInt(this.random, 1, 4));
                this.pos = 0;
                this.offset = 0;
                this.posUpto = 0;
                this.posSpacing = TestUtil.nextInt(this.random, 1, 100);
                ++this.upto;
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int docID() {
            return this.docID;
        }

        public int freq() {
            return this.freq;
        }

        public int nextPosition() {
            if (!this.doPositions) {
                this.posUpto = this.freq;
                return -1;
            }
            assert (this.posUpto < this.freq);
            if (this.posUpto != 0 || !this.random.nextBoolean()) {
                this.pos = this.posSpacing == 1 ? ++this.pos : (this.pos += TestUtil.nextInt(this.random, 1, this.posSpacing));
            }
            if (this.payloadSize != 0) {
                if (this.fixedPayloads) {
                    this.payload.length = this.payloadSize;
                    this.random.nextBytes(this.payload.bytes);
                } else {
                    int thisPayloadSize = this.random.nextInt(this.payloadSize);
                    if (thisPayloadSize != 0) {
                        this.payload.length = this.payloadSize;
                        this.random.nextBytes(this.payload.bytes);
                    } else {
                        this.payload.length = 0;
                    }
                }
            } else {
                this.payload.length = 0;
            }
            if (!this.allowPayloads) {
                this.payload.length = 0;
            }
            this.startOffset = this.offset + this.random.nextInt(5);
            this.offset = this.endOffset = this.startOffset + this.random.nextInt(10);
            ++this.posUpto;
            return this.pos;
        }

        public int startOffset() {
            return this.startOffset;
        }

        public int endOffset() {
            return this.endOffset;
        }

        public BytesRef getPayload() {
            return this.payload.length == 0 ? null : this.payload;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public long cost() {
            return this.docFreq;
        }
    }

    private static enum Option {
        SKIPPING,
        REUSE_ENUMS,
        LIVE_DOCS,
        TERM_STATE,
        PARTIAL_DOC_CONSUME,
        PARTIAL_POS_CONSUME,
        PAYLOADS,
        THREADS;

    }
}

