/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class PerThreadPKLookup {
    protected final TermsEnum[] termsEnums;
    protected final PostingsEnum[] postingsEnums;
    protected final Bits[] liveDocs;
    protected final int[] docBases;
    protected final int numSegs;
    protected final boolean hasDeletions;

    public PerThreadPKLookup(IndexReader r, String idFieldName) throws IOException {
        ArrayList leaves = new ArrayList(r.leaves());
        Collections.sort(leaves, new Comparator<LeafReaderContext>(){

            @Override
            public int compare(LeafReaderContext c1, LeafReaderContext c2) {
                return c2.reader().numDocs() - c1.reader().numDocs();
            }
        });
        this.termsEnums = new TermsEnum[leaves.size()];
        this.postingsEnums = new PostingsEnum[leaves.size()];
        this.liveDocs = new Bits[leaves.size()];
        this.docBases = new int[leaves.size()];
        int numSegs = 0;
        boolean hasDeletions = false;
        for (int i = 0; i < leaves.size(); ++i) {
            Terms terms = ((LeafReaderContext)leaves.get(i)).reader().terms(idFieldName);
            if (terms == null) continue;
            this.termsEnums[numSegs] = terms.iterator(null);
            assert (this.termsEnums[numSegs] != null);
            this.docBases[numSegs] = ((LeafReaderContext)leaves.get((int)i)).docBase;
            this.liveDocs[numSegs] = ((LeafReaderContext)leaves.get(i)).reader().getLiveDocs();
            hasDeletions |= ((LeafReaderContext)leaves.get(i)).reader().hasDeletions();
            ++numSegs;
        }
        this.numSegs = numSegs;
        this.hasDeletions = hasDeletions;
    }

    public int lookup(BytesRef id) throws IOException {
        for (int seg = 0; seg < this.numSegs; ++seg) {
            if (!this.termsEnums[seg].seekExact(id)) continue;
            this.postingsEnums[seg] = this.termsEnums[seg].postings(this.liveDocs[seg], this.postingsEnums[seg], 0);
            int docID = this.postingsEnums[seg].nextDoc();
            if (docID != Integer.MAX_VALUE) {
                return this.docBases[seg] + docID;
            }
            assert (this.hasDeletions);
        }
        return -1;
    }
}

