/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.IntsRefFSTEnum;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;
import org.junit.Assert;

public class FSTTester<T> {
    final Random random;
    final List<InputOutput<T>> pairs;
    final int inputMode;
    final Outputs<T> outputs;
    final Directory dir;
    final boolean doReverseLookup;

    public FSTTester(Random random, Directory dir, int inputMode, List<InputOutput<T>> pairs, Outputs<T> outputs, boolean doReverseLookup) {
        this.random = random;
        this.dir = dir;
        this.inputMode = inputMode;
        this.pairs = pairs;
        this.outputs = outputs;
        this.doReverseLookup = doReverseLookup;
    }

    static String inputToString(int inputMode, IntsRef term) {
        return FSTTester.inputToString(inputMode, term, true);
    }

    static String inputToString(int inputMode, IntsRef term, boolean isValidUnicode) {
        if (!isValidUnicode) {
            return term.toString();
        }
        if (inputMode == 0) {
            return FSTTester.toBytesRef(term).utf8ToString() + " " + term;
        }
        return UnicodeUtil.newString((int[])term.ints, (int)term.offset, (int)term.length) + " " + term;
    }

    private static BytesRef toBytesRef(IntsRef ir) {
        BytesRef br = new BytesRef(ir.length);
        for (int i = 0; i < ir.length; ++i) {
            int x = ir.ints[ir.offset + i];
            assert (x >= 0 && x <= 255);
            br.bytes[i] = (byte)x;
        }
        br.length = ir.length;
        return br;
    }

    static String getRandomString(Random random) {
        String term = random.nextBoolean() ? TestUtil.randomRealisticUnicodeString(random) : FSTTester.simpleRandomString(random);
        return term;
    }

    static String simpleRandomString(Random r) {
        int end = r.nextInt(10);
        if (end == 0) {
            return "";
        }
        char[] buffer = new char[end];
        for (int i = 0; i < end; ++i) {
            buffer[i] = (char)TestUtil.nextInt(r, 97, 102);
        }
        return new String(buffer, 0, end);
    }

    static IntsRef toIntsRef(String s, int inputMode) {
        return FSTTester.toIntsRef(s, inputMode, new IntsRefBuilder());
    }

    static IntsRef toIntsRef(String s, int inputMode, IntsRefBuilder ir) {
        if (inputMode == 0) {
            return FSTTester.toIntsRef(new BytesRef((CharSequence)s), ir);
        }
        return FSTTester.toIntsRefUTF32(s, ir);
    }

    static IntsRef toIntsRefUTF32(String s, IntsRefBuilder ir) {
        int charLength = s.length();
        int charIdx = 0;
        int intIdx = 0;
        ir.clear();
        while (charIdx < charLength) {
            ir.grow(intIdx + 1);
            int utf32 = s.codePointAt(charIdx);
            ir.append(utf32);
            charIdx += Character.charCount(utf32);
            ++intIdx;
        }
        return ir.get();
    }

    static IntsRef toIntsRef(BytesRef br, IntsRefBuilder ir) {
        ir.grow(br.length);
        ir.clear();
        for (int i = 0; i < br.length; ++i) {
            ir.append(br.bytes[br.offset + i] & 0xFF);
        }
        return ir.get();
    }

    public void doTest(boolean testPruning) throws IOException {
        this.doTest(0, 0, true);
        if (testPruning) {
            this.doTest(TestUtil.nextInt(this.random, 1, 1 + this.pairs.size()), 0, true);
            this.doTest(0, TestUtil.nextInt(this.random, 1, 1 + this.pairs.size()), true);
        }
    }

    private T run(FST<T> fst, IntsRef term, int[] prefixLength) throws IOException {
        Object NO_OUTPUT;
        assert (prefixLength == null || prefixLength.length == 1);
        FST.Arc arc = fst.getFirstArc(new FST.Arc());
        Object output = NO_OUTPUT = fst.outputs.getNoOutput();
        FST.BytesReader fstReader = fst.getBytesReader();
        for (int i = 0; i <= term.length; ++i) {
            int label = i == term.length ? -1 : term.ints[term.offset + i];
            if (fst.findTargetArc(label, arc, arc, fstReader) == null) {
                if (prefixLength != null) {
                    prefixLength[0] = i;
                    return (T)output;
                }
                return null;
            }
            output = fst.outputs.add(output, arc.output);
        }
        if (prefixLength != null) {
            prefixLength[0] = term.length;
        }
        return (T)output;
    }

    private T randomAcceptedWord(FST<T> fst, IntsRefBuilder in) throws IOException {
        Object NO_OUTPUT;
        FST.Arc arc = fst.getFirstArc(new FST.Arc());
        ArrayList<FST.Arc> arcs = new ArrayList<FST.Arc>();
        in.clear();
        Object output = NO_OUTPUT = fst.outputs.getNoOutput();
        FST.BytesReader fstReader = fst.getBytesReader();
        while (true) {
            fst.readFirstTargetArc(arc, arc, fstReader);
            arcs.add(new FST.Arc().copyFrom(arc));
            while (!arc.isLast()) {
                fst.readNextArc(arc, fstReader);
                arcs.add(new FST.Arc().copyFrom(arc));
            }
            arc = (FST.Arc)arcs.get(this.random.nextInt(arcs.size()));
            arcs.clear();
            output = fst.outputs.add(output, arc.output);
            if (arc.label == -1) break;
            in.append(arc.label);
        }
        return (T)output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FST<T> doTest(int prune1, int prune2, boolean allowRandomSuffixSharing) throws IOException {
        if (LuceneTestCase.VERBOSE) {
            System.out.println("\nTEST: prune1=" + prune1 + " prune2=" + prune2);
        }
        boolean willRewrite = this.random.nextBoolean();
        Builder builder = new Builder(this.inputMode == 0 ? FST.INPUT_TYPE.BYTE1 : FST.INPUT_TYPE.BYTE4, prune1, prune2, prune1 == 0 && prune2 == 0, allowRandomSuffixSharing ? this.random.nextBoolean() : true, allowRandomSuffixSharing ? TestUtil.nextInt(this.random, 1, 10) : Integer.MAX_VALUE, this.outputs, willRewrite, 0.25f, true, 15);
        if (LuceneTestCase.VERBOSE) {
            if (willRewrite) {
                System.out.println("TEST: packed FST");
            } else {
                System.out.println("TEST: non-packed FST");
            }
        }
        for (InputOutput<T> pair : this.pairs) {
            if (pair.output instanceof List) {
                List longValues = (List)pair.output;
                Builder builderObject = builder;
                for (Long value : longValues) {
                    builderObject.add(pair.input, (Object)value);
                }
                continue;
            }
            builder.add(pair.input, pair.output);
        }
        FST fst = builder.finish();
        if (this.random.nextBoolean() && fst != null && !willRewrite) {
            IOContext context = LuceneTestCase.newIOContext(this.random);
            IndexOutput out = this.dir.createOutput("fst.bin", context);
            fst.save((DataOutput)out);
            out.close();
            IndexInput in = this.dir.openInput("fst.bin", context);
            try {
                fst = new FST((DataInput)in, this.outputs);
            }
            finally {
                in.close();
                this.dir.deleteFile("fst.bin");
            }
        }
        if (LuceneTestCase.VERBOSE && this.pairs.size() <= 20 && fst != null) {
            BufferedWriter w = Files.newBufferedWriter(Paths.get("out.dot", new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
            Util.toDot((FST)fst, (Writer)w, (boolean)false, (boolean)false);
            ((Writer)w).close();
            System.out.println("SAVED out.dot");
        }
        if (LuceneTestCase.VERBOSE) {
            if (fst == null) {
                System.out.println("  fst has 0 nodes (fully pruned)");
            } else {
                System.out.println("  fst has " + fst.getNodeCount() + " nodes and " + fst.getArcCount() + " arcs");
            }
        }
        if (prune1 == 0 && prune2 == 0) {
            this.verifyUnPruned(this.inputMode, fst);
        } else {
            this.verifyPruned(this.inputMode, fst, prune1, prune2);
        }
        return fst;
    }

    protected boolean outputsEqual(T a, T b) {
        return a.equals(b);
    }

    private void verifyUnPruned(int inputMode, FST<T> fst) throws IOException {
        int iter;
        T output;
        HashSet<Long> validOutputs;
        FST<T> fstLong;
        long minLong = Long.MAX_VALUE;
        long maxLong = Long.MIN_VALUE;
        if (this.doReverseLookup) {
            FST<T> fstLong0;
            fstLong = fstLong0 = fst;
            validOutputs = new HashSet<Long>();
            for (InputOutput<T> pair : this.pairs) {
                Long output2 = (Long)pair.output;
                maxLong = Math.max(maxLong, output2);
                minLong = Math.min(minLong, output2);
                validOutputs.add(output2);
            }
        } else {
            fstLong = null;
            validOutputs = null;
        }
        if (this.pairs.size() == 0) {
            Assert.assertNull(fst);
            return;
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: now verify " + this.pairs.size() + " terms");
            for (InputOutput<T> pair : this.pairs) {
                Assert.assertNotNull(pair);
                Assert.assertNotNull((Object)pair.input);
                Assert.assertNotNull(pair.output);
                System.out.println("  " + FSTTester.inputToString(inputMode, pair.input) + ": " + this.outputs.outputToString(pair.output));
            }
        }
        Assert.assertNotNull(fst);
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: check valid terms/next()");
        }
        IntsRefFSTEnum fstEnum = new IntsRefFSTEnum(fst);
        for (InputOutput<T> pair : this.pairs) {
            IntsRef term = pair.input;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("TEST: check term=" + FSTTester.inputToString(inputMode, term) + " output=" + fst.outputs.outputToString(pair.output));
            }
            output = this.run(fst, term, null);
            Assert.assertNotNull((String)("term " + FSTTester.inputToString(inputMode, term) + " is not accepted"), output);
            Assert.assertTrue((boolean)this.outputsEqual(pair.output, output));
            IntsRefFSTEnum.InputOutput t = fstEnum.next();
            Assert.assertNotNull((Object)t);
            Assert.assertEquals((String)("expected input=" + FSTTester.inputToString(inputMode, term) + " but fstEnum returned " + FSTTester.inputToString(inputMode, t.input)), (Object)term, (Object)t.input);
            Assert.assertTrue((boolean)this.outputsEqual(pair.output, t.output));
        }
        Assert.assertNull((Object)fstEnum.next());
        HashMap termsMap = new HashMap();
        for (InputOutput<T> pair : this.pairs) {
            termsMap.put(pair.input, pair.output);
        }
        if (this.doReverseLookup && maxLong > minLong) {
            Assert.assertNull((Object)Util.getByOutput(fstLong, (long)(minLong - 7L)));
            Assert.assertNull((Object)Util.getByOutput(fstLong, (long)(maxLong + 7L)));
            int num = LuceneTestCase.atLeast(this.random, 100);
            for (int iter2 = 0; iter2 < num; ++iter2) {
                Long v = TestUtil.nextLong(this.random, minLong, maxLong);
                IntsRef input = Util.getByOutput(fstLong, (long)v);
                Assert.assertTrue((validOutputs.contains(v) || input == null ? 1 : 0) != 0);
            }
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: verify random accepted terms");
        }
        IntsRefBuilder scratch = new IntsRefBuilder();
        int num = LuceneTestCase.atLeast(this.random, 500);
        for (int iter3 = 0; iter3 < num; ++iter3) {
            output = this.randomAcceptedWord(fst, scratch);
            Assert.assertTrue((String)("accepted word " + FSTTester.inputToString(inputMode, scratch.get()) + " is not valid"), (boolean)termsMap.containsKey(scratch.get()));
            Assert.assertTrue((boolean)this.outputsEqual(termsMap.get(scratch.get()), output));
            if (!this.doReverseLookup) continue;
            IntsRef input = Util.getByOutput(fstLong, (long)((Long)output));
            Assert.assertNotNull((Object)input);
            Assert.assertEquals((Object)scratch.get(), (Object)input);
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: verify seek");
        }
        IntsRefFSTEnum fstEnum2 = new IntsRefFSTEnum(fst);
        num = LuceneTestCase.atLeast(this.random, 100);
        for (iter = 0; iter < num; ++iter) {
            IntsRefFSTEnum.InputOutput seekResult;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("  iter=" + iter);
            }
            if (this.random.nextBoolean()) {
                IntsRefFSTEnum.InputOutput seekResult2;
                IntsRef term;
                int pos;
                while ((pos = Collections.binarySearch(this.pairs, new InputOutput<Object>(term = FSTTester.toIntsRef(FSTTester.getRandomString(this.random), inputMode), null))) >= 0) {
                }
                pos = -(pos + 1);
                if (this.random.nextInt(3) == 0) {
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("  do non-exist seekExact term=" + FSTTester.inputToString(inputMode, term));
                    }
                    seekResult2 = fstEnum2.seekExact(term);
                    pos = -1;
                } else if (this.random.nextBoolean()) {
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("  do non-exist seekFloor term=" + FSTTester.inputToString(inputMode, term));
                    }
                    seekResult2 = fstEnum2.seekFloor(term);
                    --pos;
                } else {
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("  do non-exist seekCeil term=" + FSTTester.inputToString(inputMode, term));
                    }
                    seekResult2 = fstEnum2.seekCeil(term);
                }
                if (pos != -1 && pos < this.pairs.size()) {
                    Assert.assertNotNull((String)("got null but expected term=" + FSTTester.inputToString(inputMode, this.pairs.get((int)pos).input)), (Object)seekResult2);
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("    got " + FSTTester.inputToString(inputMode, seekResult2.input));
                    }
                    Assert.assertEquals((String)("expected " + FSTTester.inputToString(inputMode, this.pairs.get((int)pos).input) + " but got " + FSTTester.inputToString(inputMode, seekResult2.input)), (Object)this.pairs.get((int)pos).input, (Object)seekResult2.input);
                    Assert.assertTrue((boolean)this.outputsEqual(this.pairs.get((int)pos).output, seekResult2.output));
                    continue;
                }
                Assert.assertNull((String)("expected null but got " + (seekResult2 == null ? "null" : FSTTester.inputToString(inputMode, seekResult2.input))), (Object)seekResult2);
                if (!LuceneTestCase.VERBOSE) continue;
                System.out.println("    got null");
                continue;
            }
            InputOutput<T> pair = this.pairs.get(this.random.nextInt(this.pairs.size()));
            if (this.random.nextInt(3) == 2) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("  do exists seekExact term=" + FSTTester.inputToString(inputMode, pair.input));
                }
                seekResult = fstEnum2.seekExact(pair.input);
            } else if (this.random.nextBoolean()) {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("  do exists seekFloor " + FSTTester.inputToString(inputMode, pair.input));
                }
                seekResult = fstEnum2.seekFloor(pair.input);
            } else {
                if (LuceneTestCase.VERBOSE) {
                    System.out.println("  do exists seekCeil " + FSTTester.inputToString(inputMode, pair.input));
                }
                seekResult = fstEnum2.seekCeil(pair.input);
            }
            Assert.assertNotNull((Object)seekResult);
            Assert.assertEquals((String)("got " + FSTTester.inputToString(inputMode, seekResult.input) + " but expected " + FSTTester.inputToString(inputMode, pair.input)), (Object)pair.input, (Object)seekResult.input);
            Assert.assertTrue((boolean)this.outputsEqual(pair.output, seekResult.output));
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: mixed next/seek");
        }
        num = LuceneTestCase.atLeast(this.random, 100);
        for (iter = 0; iter < num; ++iter) {
            boolean isDone;
            if (LuceneTestCase.VERBOSE) {
                System.out.println("TEST: iter " + iter);
            }
            fstEnum2 = new IntsRefFSTEnum(fst);
            int upto = -1;
            while (true) {
                isDone = false;
                if (upto == this.pairs.size() - 1 || this.random.nextBoolean()) {
                    ++upto;
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("  do next");
                    }
                    isDone = fstEnum2.next() == null;
                } else if (upto != -1 && (double)upto < 0.75 * (double)this.pairs.size() && this.random.nextBoolean()) {
                    int attempt;
                    for (attempt = 0; attempt < 10; ++attempt) {
                        IntsRef term = FSTTester.toIntsRef(FSTTester.getRandomString(this.random), inputMode);
                        if (termsMap.containsKey(term) || term.compareTo(this.pairs.get((int)upto).input) <= 0) continue;
                        int pos = Collections.binarySearch(this.pairs, new InputOutput<Object>(term, null));
                        assert (pos < 0);
                        upto = -(pos + 1);
                        if (this.random.nextBoolean()) {
                            Assert.assertTrue((--upto != -1 ? 1 : 0) != 0);
                            if (LuceneTestCase.VERBOSE) {
                                System.out.println("  do non-exist seekFloor(" + FSTTester.inputToString(inputMode, term) + ")");
                            }
                            isDone = fstEnum2.seekFloor(term) == null;
                            break;
                        }
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("  do non-exist seekCeil(" + FSTTester.inputToString(inputMode, term) + ")");
                        }
                        isDone = fstEnum2.seekCeil(term) == null;
                        break;
                    }
                    if (attempt == 10) {
                        continue;
                    }
                } else {
                    int inc;
                    if ((upto += (inc = this.random.nextInt(this.pairs.size() - upto - 1))) == -1) {
                        upto = 0;
                    }
                    if (this.random.nextBoolean()) {
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("  do seekCeil(" + FSTTester.inputToString(inputMode, this.pairs.get((int)upto).input) + ")");
                        }
                        isDone = fstEnum2.seekCeil(this.pairs.get((int)upto).input) == null;
                    } else {
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("  do seekFloor(" + FSTTester.inputToString(inputMode, this.pairs.get((int)upto).input) + ")");
                        }
                        boolean bl = isDone = fstEnum2.seekFloor(this.pairs.get((int)upto).input) == null;
                    }
                }
                if (LuceneTestCase.VERBOSE) {
                    if (!isDone) {
                        System.out.println("    got " + FSTTester.inputToString(inputMode, fstEnum2.current().input));
                    } else {
                        System.out.println("    got null");
                    }
                }
                if (upto == this.pairs.size()) break;
                Assert.assertFalse((boolean)isDone);
                Assert.assertEquals((Object)this.pairs.get((int)upto).input, (Object)fstEnum2.current().input);
                Assert.assertTrue((boolean)this.outputsEqual(this.pairs.get((int)upto).output, fstEnum2.current().output));
            }
            Assert.assertTrue((boolean)isDone);
        }
    }

    private void verifyPruned(int inputMode, FST<T> fst, int prune1, int prune2) throws IOException {
        IntsRefFSTEnum.InputOutput current;
        CountMinOutput cmo;
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: now verify pruned " + this.pairs.size() + " terms; outputs=" + this.outputs);
            for (InputOutput<T> pair : this.pairs) {
                System.out.println("  " + FSTTester.inputToString(inputMode, pair.input) + ": " + this.outputs.outputToString(pair.output));
            }
        }
        HashMap<IntsRef, CountMinOutput> prefixes = new HashMap<IntsRef, CountMinOutput>();
        IntsRefBuilder scratch = new IntsRefBuilder();
        for (InputOutput<T> pair : this.pairs) {
            scratch.copyInts(pair.input);
            for (int idx = 0; idx <= pair.input.length; ++idx) {
                scratch.setLength(idx);
                cmo = (CountMinOutput)prefixes.get(scratch.get());
                if (cmo == null) {
                    cmo = new CountMinOutput();
                    cmo.count = 1;
                    cmo.output = pair.output;
                    prefixes.put(scratch.toIntsRef(), cmo);
                } else {
                    Object output2;
                    ++cmo.count;
                    Object output1 = cmo.output;
                    if (output1.equals(this.outputs.getNoOutput())) {
                        output1 = this.outputs.getNoOutput();
                    }
                    if ((output2 = pair.output).equals(this.outputs.getNoOutput())) {
                        output2 = this.outputs.getNoOutput();
                    }
                    cmo.output = this.outputs.common(output1, output2);
                }
                if (idx != pair.input.length) continue;
                cmo.isFinal = true;
                cmo.finalOutput = cmo.output;
            }
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: now prune");
        }
        Iterator it = prefixes.entrySet().iterator();
        while (it.hasNext()) {
            CountMinOutput cmo2;
            boolean keep;
            Map.Entry ent = it.next();
            IntsRef prefix = (IntsRef)ent.getKey();
            cmo = (CountMinOutput)ent.getValue();
            if (LuceneTestCase.VERBOSE) {
                System.out.println("  term prefix=" + FSTTester.inputToString(inputMode, prefix, false) + " count=" + cmo.count + " isLeaf=" + cmo.isLeaf + " output=" + this.outputs.outputToString(cmo.output) + " isFinal=" + cmo.isFinal);
            }
            if (prune1 > 0) {
                keep = cmo.count >= prune1;
            } else {
                assert (prune2 > 0);
                if (prune2 > 1 && cmo.count >= prune2) {
                    keep = true;
                } else if (prefix.length > 0) {
                    scratch.setLength(prefix.length - 1);
                    System.arraycopy(prefix.ints, prefix.offset, scratch.ints(), 0, scratch.length());
                    cmo2 = (CountMinOutput)prefixes.get(scratch.get());
                    keep = cmo2 != null && (prune2 > 1 && cmo2.count >= prune2 || prune2 == 1 && (cmo2.count >= 2 || prefix.length <= 1));
                } else {
                    keep = cmo.count >= prune2;
                }
            }
            if (!keep) {
                it.remove();
                continue;
            }
            scratch.copyInts(prefix);
            scratch.setLength(scratch.length() - 1);
            while (scratch.length() >= 0) {
                cmo2 = (CountMinOutput)prefixes.get(scratch.get());
                if (cmo2 != null) {
                    cmo2.isLeaf = false;
                }
                scratch.setLength(scratch.length() - 1);
            }
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: after prune");
            for (Map.Entry ent : prefixes.entrySet()) {
                System.out.println("  " + FSTTester.inputToString(inputMode, (IntsRef)ent.getKey(), false) + ": isLeaf=" + ((CountMinOutput)ent.getValue()).isLeaf + " isFinal=" + ((CountMinOutput)ent.getValue()).isFinal);
                if (!((CountMinOutput)ent.getValue()).isFinal) continue;
                System.out.println("    finalOutput=" + this.outputs.outputToString(((CountMinOutput)ent.getValue()).finalOutput));
            }
        }
        if (prefixes.size() <= 1) {
            Assert.assertNull(fst);
            return;
        }
        Assert.assertNotNull(fst);
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: check pruned enum");
        }
        IntsRefFSTEnum fstEnum = new IntsRefFSTEnum(fst);
        while ((current = fstEnum.next()) != null) {
            if (LuceneTestCase.VERBOSE) {
                System.out.println("  fstEnum.next prefix=" + FSTTester.inputToString(inputMode, current.input, false) + " output=" + this.outputs.outputToString(current.output));
            }
            cmo = (CountMinOutput)prefixes.get(current.input);
            Assert.assertNotNull((Object)cmo);
            Assert.assertTrue((cmo.isLeaf || cmo.isFinal ? 1 : 0) != 0);
            if (cmo.isFinal) {
                Assert.assertEquals(cmo.finalOutput, (Object)current.output);
                continue;
            }
            Assert.assertEquals(cmo.output, (Object)current.output);
        }
        if (LuceneTestCase.VERBOSE) {
            System.out.println("TEST: verify all prefixes");
        }
        int[] stopNode = new int[1];
        for (Map.Entry ent : prefixes.entrySet()) {
            if (((IntsRef)ent.getKey()).length <= 0) continue;
            CountMinOutput cmo2 = (CountMinOutput)ent.getValue();
            T output = this.run(fst, (IntsRef)ent.getKey(), stopNode);
            if (LuceneTestCase.VERBOSE) {
                System.out.println("TEST: verify prefix=" + FSTTester.inputToString(inputMode, (IntsRef)ent.getKey(), false) + " output=" + this.outputs.outputToString(cmo2.output));
            }
            if (cmo2.isFinal) {
                Assert.assertEquals(cmo2.finalOutput, output);
            } else {
                Assert.assertEquals(cmo2.output, output);
            }
            Assert.assertEquals((long)((IntsRef)ent.getKey()).length, (long)stopNode[0]);
        }
    }

    private static class CountMinOutput<T> {
        int count;
        T output;
        T finalOutput;
        boolean isLeaf = true;
        boolean isFinal;

        private CountMinOutput() {
        }
    }

    public static class InputOutput<T>
    implements Comparable<InputOutput<T>> {
        public final IntsRef input;
        public final T output;

        public InputOutput(IntsRef input, T output) {
            this.input = input;
            this.output = output;
        }

        @Override
        public int compareTo(InputOutput<T> other) {
            if (other instanceof InputOutput) {
                return this.input.compareTo(other.input);
            }
            throw new IllegalArgumentException();
        }
    }
}

