/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.BytesRef;

public final class CannedBinaryTokenStream
extends TokenStream {
    private final BinaryToken[] tokens;
    private int upto = 0;
    private final BytesTermAttribute termAtt = (BytesTermAttribute)this.addAttribute(BytesTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);

    public CannedBinaryTokenStream(BinaryToken ... tokens) {
        this.tokens = tokens;
    }

    public boolean incrementToken() {
        if (this.upto < this.tokens.length) {
            BinaryToken token = this.tokens[this.upto++];
            this.clearAttributes();
            this.termAtt.setBytesRef(token.term);
            this.posIncrAtt.setPositionIncrement(token.posInc);
            this.posLengthAtt.setPositionLength(token.posLen);
            this.offsetAtt.setOffset(token.startOffset, token.endOffset);
            return true;
        }
        return false;
    }

    public static final class BinaryToken {
        BytesRef term;
        int posInc;
        int posLen;
        int startOffset;
        int endOffset;

        public BinaryToken(BytesRef term) {
            this.term = term;
            this.posInc = 1;
            this.posLen = 1;
        }

        public BinaryToken(BytesRef term, int posInc, int posLen) {
            this.term = term;
            this.posInc = posInc;
            this.posLen = posLen;
        }
    }
}

