/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.mockfile;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.mockfile.FilterFileStore;
import org.apache.lucene.mockfile.FilterFileSystemProvider;
import org.apache.lucene.mockfile.FilterPath;

public class FilterFileSystem
extends FileSystem {
    protected final FilterFileSystemProvider parent;
    protected final FileSystem delegate;

    public FilterFileSystem(FilterFileSystemProvider parent, FileSystem delegate) {
        this.parent = Objects.requireNonNull(parent);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public FileSystemProvider provider() {
        return this.parent;
    }

    @Override
    public void close() throws IOException {
        if (this.delegate == FileSystems.getDefault()) {
            this.parent.onClose();
        } else {
            try (FileSystem d = this.delegate;){
                assert (d != null);
                this.parent.onClose();
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public String getSeparator() {
        return this.delegate.getSeparator();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        final Iterable<Path> roots = this.delegate.getRootDirectories();
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                final Iterator iterator = roots.iterator();
                return new Iterator<Path>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Path next() {
                        return new FilterPath((Path)iterator.next(), FilterFileSystem.this);
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        final Iterable<FileStore> fileStores = this.delegate.getFileStores();
        return new Iterable<FileStore>(){

            @Override
            public Iterator<FileStore> iterator() {
                final Iterator iterator = fileStores.iterator();
                return new Iterator<FileStore>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public FileStore next() {
                        return new FilterFileStore((FileStore)iterator.next(), FilterFileSystem.this.parent.getScheme());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.delegate.supportedFileAttributeViews();
    }

    @Override
    public Path getPath(String first, String ... more) {
        return new FilterPath(this.delegate.getPath(first, more), this);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        final PathMatcher matcher = this.delegate.getPathMatcher(syntaxAndPattern);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                if (path instanceof FilterPath) {
                    return matcher.matches(((FilterPath)path).delegate);
                }
                return false;
            }
        };
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.delegate.getUserPrincipalLookupService();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return this.delegate.newWatchService();
    }

    public FileSystem getDelegate() {
        return this.delegate;
    }

    public FileSystemProvider getParent() {
        return this.parent;
    }
}

