/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CheckHits;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanBoostQuery;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LuceneTestCase;

public class QueryUtils {
    public static void check(Query q) {
        QueryUtils.checkHashEquals(q);
        if (q instanceof FilteredQuery) {
            FilteredQuery filtered = (FilteredQuery)q;
            QueryUtils.check(filtered.getQuery());
            QueryUtils.check((Query)filtered.getFilter());
        }
        try {
            IndexSearcher dummySearcher = new IndexSearcher((IndexReader)new MultiReader(new IndexReader[0]));
            Query clone = q.clone();
            clone.setBoost((float)Math.PI);
            Query rewritten = dummySearcher.rewrite(clone);
            Assert.assertTrue((String)("Query " + clone.getClass() + " does not propagate Query.rewrite call to super.rewrite"), (rewritten instanceof BoostQuery || rewritten instanceof SpanBoostQuery ? 1 : 0) != 0);
        }
        catch (IOException ioe) {
            throw new AssertionError("Unexpected I/O error", ioe);
        }
    }

    public static void checkHashEquals(Query q) {
        QueryUtils.checkEqual(q, q);
        Query q2 = q.clone();
        QueryUtils.checkEqual(q, q2);
        Query q3 = q.clone();
        q3.setBoost(7.2179236f);
        QueryUtils.checkUnequal(q, q3);
        Query whacky = new Query(){

            public String toString(String field) {
                return "My Whacky Query";
            }
        };
        QueryUtils.checkUnequal(q, whacky);
        Assert.assertFalse((boolean)q.equals(null));
    }

    public static void checkEqual(Query q1, Query q2) {
        Assert.assertEquals((Object)q1, (Object)q2);
        Assert.assertEquals((int)q1.hashCode(), (int)q2.hashCode());
    }

    public static void checkUnequal(Query q1, Query q2) {
        Assert.assertFalse((String)(q1 + " equal to " + q2), (boolean)q1.equals((Object)q2));
        Assert.assertFalse((String)(q2 + " equal to " + q1), (boolean)q2.equals((Object)q1));
        Assert.assertTrue((q1.hashCode() != q2.hashCode() ? 1 : 0) != 0);
    }

    public static void checkExplanations(Query q, IndexSearcher s) throws IOException {
        CheckHits.checkExplanations(q, null, s, true);
    }

    public static void check(Random random, Query q1, IndexSearcher s) {
        QueryUtils.check(random, q1, s, true);
    }

    public static void check(Random random, Query q1, IndexSearcher s, boolean wrap) {
        try {
            QueryUtils.check(q1);
            if (s != null) {
                QueryUtils.checkFirstSkipTo(q1, s);
                QueryUtils.checkSkipTo(q1, s);
                QueryUtils.checkBulkScorerSkipTo(random, q1, s);
                if (wrap) {
                    QueryUtils.check(random, q1, QueryUtils.wrapUnderlyingReader(random, s, -1), false);
                    QueryUtils.check(random, q1, QueryUtils.wrapUnderlyingReader(random, s, 0), false);
                    QueryUtils.check(random, q1, QueryUtils.wrapUnderlyingReader(random, s, 1), false);
                }
                QueryUtils.checkExplanations(q1, s);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static IndexSearcher wrapUnderlyingReader(Random random, IndexSearcher s, int edge) throws IOException {
        IndexReader r = s.getIndexReader();
        IndexReader[] readers = new IndexReader[]{edge < 0 ? r : new MultiReader(new IndexReader[0]), new MultiReader(new IndexReader[0]), new FCInvisibleMultiReader(new IndexReader[]{edge < 0 ? QueryUtils.emptyReader(4) : new MultiReader(new IndexReader[0]), new MultiReader(new IndexReader[0]), 0 == edge ? r : new MultiReader(new IndexReader[0])}), 0 < edge ? new MultiReader(new IndexReader[0]) : QueryUtils.emptyReader(7), new MultiReader(new IndexReader[0]), new FCInvisibleMultiReader(new IndexReader[]{0 < edge ? new MultiReader(new IndexReader[0]) : QueryUtils.emptyReader(5), new MultiReader(new IndexReader[0]), 0 < edge ? r : new MultiReader(new IndexReader[0])})};
        IndexSearcher out = LuceneTestCase.newSearcher((IndexReader)new FCInvisibleMultiReader(readers));
        out.setSimilarity(s.getSimilarity(true));
        return out;
    }

    private static IndexReader emptyReader(final int maxDoc) {
        return new LeafReader(){
            final Bits liveDocs;
            {
                this.liveDocs = new Bits.MatchNoBits(maxDoc);
            }

            public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
            }

            public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
            }

            public Fields fields() throws IOException {
                return new Fields(){

                    public Iterator<String> iterator() {
                        return Collections.emptyList().iterator();
                    }

                    public Terms terms(String field) throws IOException {
                        return null;
                    }

                    public int size() {
                        return 0;
                    }
                };
            }

            public NumericDocValues getNumericDocValues(String field) throws IOException {
                return null;
            }

            public BinaryDocValues getBinaryDocValues(String field) throws IOException {
                return null;
            }

            public SortedDocValues getSortedDocValues(String field) throws IOException {
                return null;
            }

            public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
                return null;
            }

            public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
                return null;
            }

            public Bits getDocsWithField(String field) throws IOException {
                return null;
            }

            public NumericDocValues getNormValues(String field) throws IOException {
                return null;
            }

            public FieldInfos getFieldInfos() {
                return new FieldInfos(new FieldInfo[0]);
            }

            public Bits getLiveDocs() {
                return this.liveDocs;
            }

            public void checkIntegrity() throws IOException {
            }

            public Fields getTermVectors(int docID) throws IOException {
                return null;
            }

            public int numDocs() {
                return 0;
            }

            public int maxDoc() {
                return maxDoc;
            }

            public void document(int docID, StoredFieldVisitor visitor) throws IOException {
            }

            protected void doClose() throws IOException {
            }
        };
    }

    public static void checkSkipTo(final Query q, final IndexSearcher s) throws IOException {
        final List readerContextArray = s.getTopReaderContext().leaves();
        boolean skip_op = false;
        boolean next_op = true;
        int[][] orders = new int[][]{{1}, {0}, {0, 1}, {1, 0}, {0, 0, 1, 1}, {1, 1, 0, 0}, {0, 0, 0, 1, 1}};
        for (int k = 0; k < orders.length; ++k) {
            final int[] order = orders[k];
            final int[] opidx = new int[]{0};
            final int[] lastDoc = new int[]{-1};
            float maxDiff = 1.0E-5f;
            final LeafReader[] lastReader = new LeafReader[]{null};
            s.search(q, (Collector)new SimpleCollector(){
                private Scorer sc;
                private Scorer scorer;
                private int leafPtr;

                public void setScorer(Scorer scorer) {
                    this.sc = scorer;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void collect(int doc) throws IOException {
                    block8: {
                        float score = this.sc.score();
                        lastDoc[0] = doc;
                        try {
                            StringBuilder sbord;
                            if (this.scorer == null) {
                                Weight w = s.createNormalizedWeight(q, true);
                                LeafReaderContext context = (LeafReaderContext)readerContextArray.get(this.leafPtr);
                                this.scorer = w.scorer(context);
                            }
                            int n = opidx[0];
                            opidx[0] = n + 1;
                            int op = order[n % order.length];
                            boolean more = op == 0 ? this.scorer.advance(this.scorer.docID() + 1) != Integer.MAX_VALUE : this.scorer.nextDoc() != Integer.MAX_VALUE;
                            int scorerDoc = this.scorer.docID();
                            float scorerScore = this.scorer.score();
                            float scorerScore2 = this.scorer.score();
                            float scoreDiff = Math.abs(score - scorerScore);
                            float scorerDiff = Math.abs(scorerScore2 - scorerScore);
                            boolean success = false;
                            try {
                                Assert.assertTrue((boolean)more);
                                Assert.assertEquals((String)("scorerDoc=" + scorerDoc + ",doc=" + doc), (int)scorerDoc, (int)doc);
                                Assert.assertTrue((String)("score=" + score + ", scorerScore=" + scorerScore), (scoreDiff <= 1.0E-5f ? 1 : 0) != 0);
                                Assert.assertTrue((String)("scorerScorer=" + scorerScore + ", scorerScore2=" + scorerScore2), (scorerDiff <= 1.0E-5f ? 1 : 0) != 0);
                                success = true;
                                if (success || !LuceneTestCase.VERBOSE) break block8;
                                sbord = new StringBuilder();
                            }
                            catch (Throwable throwable) {
                                if (!success && LuceneTestCase.VERBOSE) {
                                    StringBuilder sbord2 = new StringBuilder();
                                    for (int i = 0; i < order.length; ++i) {
                                        sbord2.append(order[i] == 0 ? " skip()" : " next()");
                                    }
                                    System.out.println("ERROR matching docs:\n\t" + (doc != scorerDoc ? "--> " : "") + "doc=" + doc + ", scorerDoc=" + scorerDoc + "\n\t" + (!more ? "--> " : "") + "tscorer.more=" + more + "\n\t" + (scoreDiff > 1.0E-5f ? "--> " : "") + "scorerScore=" + scorerScore + " scoreDiff=" + scoreDiff + " maxDiff=" + 1.0E-5f + "\n\t" + (scorerDiff > 1.0E-5f ? "--> " : "") + "scorerScore2=" + scorerScore2 + " scorerDiff=" + scorerDiff + "\n\thitCollector.doc=" + doc + " score=" + score + "\n\t Scorer=" + this.scorer + "\n\t Query=" + q + "  " + q.getClass().getName() + "\n\t Searcher=" + s + "\n\t Order=" + sbord2 + "\n\t Op=" + (op == 0 ? " skip()" : " next()"));
                                }
                                throw throwable;
                            }
                            for (int i = 0; i < order.length; ++i) {
                                sbord.append(order[i] == 0 ? " skip()" : " next()");
                            }
                            System.out.println("ERROR matching docs:\n\t" + (doc != scorerDoc ? "--> " : "") + "doc=" + doc + ", scorerDoc=" + scorerDoc + "\n\t" + (!more ? "--> " : "") + "tscorer.more=" + more + "\n\t" + (scoreDiff > 1.0E-5f ? "--> " : "") + "scorerScore=" + scorerScore + " scoreDiff=" + scoreDiff + " maxDiff=" + 1.0E-5f + "\n\t" + (scorerDiff > 1.0E-5f ? "--> " : "") + "scorerScore2=" + scorerScore2 + " scorerDiff=" + scorerDiff + "\n\thitCollector.doc=" + doc + " score=" + score + "\n\t Scorer=" + this.scorer + "\n\t Query=" + q + "  " + q.getClass().getName() + "\n\t Searcher=" + s + "\n\t Order=" + sbord + "\n\t Op=" + (op == 0 ? " skip()" : " next()"));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }

                public boolean needsScores() {
                    return true;
                }

                protected void doSetNextReader(LeafReaderContext context) throws IOException {
                    if (lastReader[0] != null) {
                        LeafReader previousReader = lastReader[0];
                        IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader);
                        indexSearcher.setSimilarity(s.getSimilarity(true));
                        Weight w = indexSearcher.createNormalizedWeight(q, true);
                        LeafReaderContext ctx = (LeafReaderContext)indexSearcher.getTopReaderContext();
                        Scorer scorer = w.scorer(ctx);
                        if (scorer != null) {
                            boolean more = false;
                            Bits liveDocs = context.reader().getLiveDocs();
                            int d = scorer.advance(lastDoc[0] + 1);
                            while (d != Integer.MAX_VALUE) {
                                if (liveDocs == null || liveDocs.get(d)) {
                                    more = true;
                                    break;
                                }
                                d = scorer.nextDoc();
                            }
                            Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but advance(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
                        }
                        ++this.leafPtr;
                    }
                    lastReader[0] = context.reader();
                    assert (((LeafReaderContext)readerContextArray.get(this.leafPtr)).reader() == context.reader());
                    this.scorer = null;
                    lastDoc[0] = -1;
                }
            });
            if (lastReader[0] == null) continue;
            LeafReader previousReader = lastReader[0];
            IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader, false);
            indexSearcher.setSimilarity(s.getSimilarity(true));
            Weight w = indexSearcher.createNormalizedWeight(q, true);
            LeafReaderContext ctx = previousReader.getContext();
            Scorer scorer = w.scorer(ctx);
            if (scorer == null) continue;
            boolean more = false;
            Bits liveDocs = lastReader[0].getLiveDocs();
            int d = scorer.advance(lastDoc[0] + 1);
            while (d != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(d)) {
                    more = true;
                    break;
                }
                d = scorer.nextDoc();
            }
            Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but advance(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
        }
    }

    public static void checkFirstSkipTo(final Query q, final IndexSearcher s) throws IOException {
        float maxDiff = 0.001f;
        final int[] lastDoc = new int[]{-1};
        final LeafReader[] lastReader = new LeafReader[]{null};
        final List context = s.getTopReaderContext().leaves();
        s.search(q, (Collector)new SimpleCollector(){
            private Scorer scorer;
            private int leafPtr;

            public void setScorer(Scorer scorer) {
                this.scorer = scorer;
            }

            public void collect(int doc) throws IOException {
                float score = this.scorer.score();
                try {
                    long startMS = System.currentTimeMillis();
                    for (int i = lastDoc[0] + 1; i <= doc; ++i) {
                        Weight w = s.createNormalizedWeight(q, true);
                        Scorer scorer = w.scorer((LeafReaderContext)context.get(this.leafPtr));
                        Assert.assertTrue((String)("query collected " + doc + " but advance(" + i + ") says no more docs!"), (scorer.advance(i) != Integer.MAX_VALUE ? 1 : 0) != 0);
                        Assert.assertEquals((String)("query collected " + doc + " but advance(" + i + ") got to " + scorer.docID()), (int)doc, (int)scorer.docID());
                        float advanceScore = scorer.score();
                        Assert.assertEquals((String)("unstable advance(" + i + ") score!"), (float)advanceScore, (float)scorer.score(), (float)0.001f);
                        Assert.assertEquals((String)("query assigned doc " + doc + " a score of <" + score + "> but advance(" + i + ") has <" + advanceScore + ">!"), (float)score, (float)advanceScore, (float)0.001f);
                        if (i >= doc || System.currentTimeMillis() - startMS <= 5L) continue;
                        i = doc - 1;
                    }
                    lastDoc[0] = doc;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean needsScores() {
                return true;
            }

            protected void doSetNextReader(LeafReaderContext context2) throws IOException {
                if (lastReader[0] != null) {
                    LeafReader previousReader = lastReader[0];
                    IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader);
                    indexSearcher.setSimilarity(s.getSimilarity(true));
                    Weight w = indexSearcher.createNormalizedWeight(q, true);
                    Scorer scorer = w.scorer((LeafReaderContext)indexSearcher.getTopReaderContext());
                    if (scorer != null) {
                        boolean more = false;
                        Bits liveDocs = context2.reader().getLiveDocs();
                        int d = scorer.advance(lastDoc[0] + 1);
                        while (d != Integer.MAX_VALUE) {
                            if (liveDocs == null || liveDocs.get(d)) {
                                more = true;
                                break;
                            }
                            d = scorer.nextDoc();
                        }
                        Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but advance(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
                    }
                    ++this.leafPtr;
                }
                lastReader[0] = context2.reader();
                lastDoc[0] = -1;
            }
        });
        if (lastReader[0] != null) {
            LeafReader previousReader = lastReader[0];
            IndexSearcher indexSearcher = LuceneTestCase.newSearcher((IndexReader)previousReader);
            indexSearcher.setSimilarity(s.getSimilarity(true));
            Weight w = indexSearcher.createNormalizedWeight(q, true);
            Scorer scorer = w.scorer((LeafReaderContext)indexSearcher.getTopReaderContext());
            if (scorer != null) {
                boolean more = false;
                Bits liveDocs = lastReader[0].getLiveDocs();
                int d = scorer.advance(lastDoc[0] + 1);
                while (d != Integer.MAX_VALUE) {
                    if (liveDocs == null || liveDocs.get(d)) {
                        more = true;
                        break;
                    }
                    d = scorer.nextDoc();
                }
                Assert.assertFalse((String)("query's last doc was " + lastDoc[0] + " but advance(" + (lastDoc[0] + 1) + ") got to " + scorer.docID()), (boolean)more);
            }
        }
    }

    public static void checkBulkScorerSkipTo(Random r, Query query, IndexSearcher searcher) throws IOException {
        Weight weight = searcher.createNormalizedWeight(query, true);
        for (LeafReaderContext context : searcher.getIndexReader().leaves()) {
            final Scorer scorer = weight.scorer(context);
            BulkScorer bulkScorer = weight.bulkScorer(context);
            if (scorer == null && bulkScorer == null) continue;
            if (bulkScorer == null) {
                assert (scorer.nextDoc() == Integer.MAX_VALUE);
                continue;
            }
            int upTo = 0;
            do {
                final int min = upTo + r.nextInt(5);
                final int max = min + 1 + r.nextInt(r.nextBoolean() ? 10 : 5000);
                if (scorer.docID() < min) {
                    scorer.advance(min);
                }
                int next = bulkScorer.score(new LeafCollector(){
                    Scorer scorer2;

                    public void setScorer(Scorer scorer2) throws IOException {
                        this.scorer2 = scorer2;
                    }

                    public void collect(int doc) throws IOException {
                        assert (doc >= min);
                        assert (doc < max);
                        Assert.assertEquals((int)scorer.docID(), (int)doc);
                        Assert.assertEquals((float)scorer.score(), (float)this.scorer2.score(), (float)0.01f);
                        scorer.nextDoc();
                    }
                }, null, min, max);
                assert (max <= next);
                assert (next <= scorer.docID());
                upTo = max;
            } while (scorer.docID() != Integer.MAX_VALUE);
            bulkScorer.score(new LeafCollector(){

                public void setScorer(Scorer scorer) throws IOException {
                }

                public void collect(int doc) throws IOException {
                    assert (false);
                }
            }, null, upTo, Integer.MAX_VALUE);
        }
    }

    public static class FCInvisibleMultiReader
    extends MultiReader {
        private final Object cacheKey = new Object();

        public FCInvisibleMultiReader(IndexReader ... readers) throws IOException {
            super(readers);
        }

        public Object getCoreCacheKey() {
            return this.cacheKey;
        }

        public Object getCombinedCoreAndDeletesKey() {
            return this.cacheKey;
        }
    }
}

