/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.TestUtil;

public final class AssertingPointsFormat
extends PointsFormat {
    private final PointsFormat in;

    public AssertingPointsFormat() {
        this(TestUtil.getDefaultCodec().pointsFormat());
    }

    public AssertingPointsFormat(PointsFormat in) {
        this.in = in;
    }

    public PointsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new AssertingPointsWriter(state, this.in.fieldsWriter(state));
    }

    public PointsReader fieldsReader(SegmentReadState state) throws IOException {
        return new AssertingPointsReader(state.segmentInfo.maxDoc(), this.in.fieldsReader(state));
    }

    static class AssertingPointsWriter
    extends PointsWriter {
        private final PointsWriter in;

        AssertingPointsWriter(SegmentWriteState writeState, PointsWriter in) {
            this.in = in;
        }

        public void writeField(FieldInfo fieldInfo, PointsReader values) throws IOException {
            if (fieldInfo.getPointDimensionCount() == 0) {
                throw new IllegalArgumentException("writing field=\"" + fieldInfo.name + "\" but pointDimensionalCount is 0");
            }
            this.in.writeField(fieldInfo, values);
        }

        public void merge(MergeState mergeState) throws IOException {
            this.in.merge(mergeState);
        }

        public void finish() throws IOException {
            this.in.finish();
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }
    }

    static class AssertingPointsReader
    extends PointsReader {
        private final PointsReader in;
        private final int maxDoc;

        AssertingPointsReader(int maxDoc, PointsReader in) {
            this.in = in;
            this.maxDoc = maxDoc;
            assert (this.toString() != null);
            assert (this.ramBytesUsed() >= 0L);
            assert (this.getChildResources() != null);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }

        public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
            this.in.intersect(fieldName, (PointValues.IntersectVisitor)new AssertingIntersectVisitor(this.in.getNumDimensions(fieldName), this.in.getBytesPerDimension(fieldName), visitor));
        }

        public long ramBytesUsed() {
            long v = this.in.ramBytesUsed();
            assert (v >= 0L);
            return v;
        }

        public Collection<Accountable> getChildResources() {
            Collection res = this.in.getChildResources();
            TestUtil.checkReadOnly(res);
            return res;
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public PointsReader getMergeInstance() throws IOException {
            return new AssertingPointsReader(this.maxDoc, this.in.getMergeInstance());
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.in.toString() + ")";
        }

        public byte[] getMinPackedValue(String fieldName) throws IOException {
            this.assertStats(fieldName);
            return this.in.getMinPackedValue(fieldName);
        }

        public byte[] getMaxPackedValue(String fieldName) throws IOException {
            this.assertStats(fieldName);
            return this.in.getMaxPackedValue(fieldName);
        }

        public int getNumDimensions(String fieldName) throws IOException {
            this.assertStats(fieldName);
            return this.in.getNumDimensions(fieldName);
        }

        public int getBytesPerDimension(String fieldName) throws IOException {
            this.assertStats(fieldName);
            return this.in.getBytesPerDimension(fieldName);
        }

        public long size(String fieldName) {
            this.assertStats(fieldName);
            return this.in.size(fieldName);
        }

        public int getDocCount(String fieldName) {
            this.assertStats(fieldName);
            return this.in.getDocCount(fieldName);
        }

        private void assertStats(String fieldName) {
            assert (this.in.size(fieldName) >= 0L);
            assert (this.in.getDocCount(fieldName) >= 0);
            assert ((long)this.in.getDocCount(fieldName) <= this.in.size(fieldName));
            assert (this.in.getDocCount(fieldName) <= this.maxDoc);
        }
    }

    static class AssertingIntersectVisitor
    implements PointValues.IntersectVisitor {
        final PointValues.IntersectVisitor in;
        final int numDims;
        final int bytesPerDim;
        final byte[] lastDocValue;
        final byte[] lastMinPackedValue;
        final byte[] lastMaxPackedValue;
        private PointValues.Relation lastCompareResult;
        private int lastDocID = -1;

        public AssertingIntersectVisitor(int numDims, int bytesPerDim, PointValues.IntersectVisitor in) {
            this.in = in;
            this.numDims = numDims;
            this.bytesPerDim = bytesPerDim;
            this.lastMaxPackedValue = new byte[numDims * bytesPerDim];
            this.lastMinPackedValue = new byte[numDims * bytesPerDim];
            this.lastDocValue = (byte[])(numDims == 1 ? new byte[bytesPerDim] : null);
        }

        public void visit(int docID) throws IOException {
            assert (this.lastCompareResult == PointValues.Relation.CELL_INSIDE_QUERY);
            this.in.visit(docID);
        }

        public void visit(int docID, byte[] packedValue) throws IOException {
            assert (this.lastCompareResult == PointValues.Relation.CELL_CROSSES_QUERY);
            for (int dim = 0; dim < this.numDims; ++dim) {
                assert (StringHelper.compare((int)this.bytesPerDim, (byte[])this.lastMinPackedValue, (int)(dim * this.bytesPerDim), (byte[])packedValue, (int)(dim * this.bytesPerDim)) <= 0) : "dim=" + dim + " of " + this.numDims + " value=" + new BytesRef(packedValue);
                assert (StringHelper.compare((int)this.bytesPerDim, (byte[])this.lastMaxPackedValue, (int)(dim * this.bytesPerDim), (byte[])packedValue, (int)(dim * this.bytesPerDim)) >= 0) : "dim=" + dim + " of " + this.numDims + " value=" + new BytesRef(packedValue);
            }
            assert (packedValue.length == this.numDims * this.bytesPerDim);
            if (this.numDims == 1) {
                int cmp = StringHelper.compare((int)this.bytesPerDim, (byte[])this.lastDocValue, (int)0, (byte[])packedValue, (int)0);
                if (cmp >= 0) {
                    if (cmp == 0) {
                        assert (this.lastDocID <= docID) : "doc ids are out of order when point values are the same!";
                    } else assert (false) : "point values are out of order";
                }
                System.arraycopy(packedValue, 0, this.lastDocValue, 0, this.bytesPerDim);
            }
            this.in.visit(docID, packedValue);
        }

        public void grow(int count) {
            this.in.grow(count);
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            for (int dim = 0; dim < this.numDims; ++dim) {
                assert (StringHelper.compare((int)this.bytesPerDim, (byte[])minPackedValue, (int)(dim * this.bytesPerDim), (byte[])maxPackedValue, (int)(dim * this.bytesPerDim)) <= 0);
            }
            System.arraycopy(maxPackedValue, 0, this.lastMaxPackedValue, 0, this.numDims * this.bytesPerDim);
            System.arraycopy(minPackedValue, 0, this.lastMinPackedValue, 0, this.numDims * this.bytesPerDim);
            this.lastCompareResult = this.in.compare(minPackedValue, maxPackedValue);
            return this.lastCompareResult;
        }
    }
}

