/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.MismatchedLeafReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public class MockRandomMergePolicy
extends MergePolicy {
    private final Random random;
    boolean doNonBulkMerges = true;

    public MockRandomMergePolicy(Random random) {
        this.random = new Random(random.nextLong());
    }

    public void setDoNonBulkMerges(boolean v) {
        this.doNonBulkMerges = v;
    }

    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, IndexWriter writer) {
        MergePolicy.MergeSpecification mergeSpec = null;
        int numSegments = segmentInfos.size();
        ArrayList<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
        Collection merging = writer.getMergingSegments();
        for (SegmentCommitInfo sipc : segmentInfos) {
            if (merging.contains(sipc)) continue;
            segments.add(sipc);
        }
        numSegments = segments.size();
        if (numSegments > 1 && (numSegments > 30 || this.random.nextInt(5) == 3)) {
            Collections.shuffle(segments, this.random);
            mergeSpec = new MergePolicy.MergeSpecification();
            int segsToMerge = TestUtil.nextInt(this.random, 1, numSegments);
            if (this.doNonBulkMerges && this.random.nextBoolean()) {
                mergeSpec.add((MergePolicy.OneMerge)new MockRandomOneMerge(segments.subList(0, segsToMerge), this.random.nextLong()));
            } else {
                mergeSpec.add(new MergePolicy.OneMerge(segments.subList(0, segsToMerge)));
            }
        }
        return mergeSpec;
    }

    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer) throws IOException {
        ArrayList<SegmentCommitInfo> eligibleSegments = new ArrayList<SegmentCommitInfo>();
        for (SegmentCommitInfo info : segmentInfos) {
            if (!segmentsToMerge.containsKey(info)) continue;
            eligibleSegments.add(info);
        }
        MergePolicy.MergeSpecification mergeSpec = null;
        if (eligibleSegments.size() > 1 || eligibleSegments.size() == 1 && !this.isMerged(segmentInfos, (SegmentCommitInfo)eligibleSegments.get(0), writer)) {
            int inc;
            mergeSpec = new MergePolicy.MergeSpecification();
            Collections.shuffle(eligibleSegments, this.random);
            for (int upto = 0; upto < eligibleSegments.size(); upto += inc) {
                int max = Math.min(10, eligibleSegments.size() - upto);
                int n = inc = max <= 2 ? max : TestUtil.nextInt(this.random, 2, max);
                if (this.doNonBulkMerges && this.random.nextBoolean()) {
                    mergeSpec.add((MergePolicy.OneMerge)new MockRandomOneMerge(eligibleSegments.subList(upto, upto + inc), this.random.nextLong()));
                    continue;
                }
                mergeSpec.add(new MergePolicy.OneMerge(eligibleSegments.subList(upto, upto + inc)));
            }
        }
        if (mergeSpec != null) {
            for (MergePolicy.OneMerge merge : mergeSpec.merges) {
                for (SegmentCommitInfo info : merge.segments) {
                    assert (segmentsToMerge.containsKey(info));
                }
            }
        }
        return mergeSpec;
    }

    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.findMerges(null, segmentInfos, writer);
    }

    public boolean useCompoundFile(SegmentInfos infos, SegmentCommitInfo mergedInfo, IndexWriter writer) throws IOException {
        return this.random.nextInt(5) != 1;
    }

    static class MockRandomOneMerge
    extends MergePolicy.OneMerge {
        final Random r;
        ArrayList<CodecReader> readers;

        MockRandomOneMerge(List<SegmentCommitInfo> segments, long seed) {
            super(segments);
            this.r = new Random(seed);
        }

        public List<CodecReader> getMergeReaders() throws IOException {
            if (this.readers == null) {
                this.readers = new ArrayList(super.getMergeReaders());
                for (int i = 0; i < this.readers.size(); ++i) {
                    int thingToDo = this.r.nextInt(7);
                    if (thingToDo == 0) {
                        if (LuceneTestCase.VERBOSE) {
                            System.out.println("NOTE: MockRandomMergePolicy now swaps in a SlowCodecReaderWrapper for merging reader=" + this.readers.get(i));
                        }
                        this.readers.set(i, SlowCodecReaderWrapper.wrap((LeafReader)new FilterLeafReader((LeafReader)this.readers.get(i)){}));
                        continue;
                    }
                    if (thingToDo != 1) continue;
                    if (LuceneTestCase.VERBOSE) {
                        System.out.println("NOTE: MockRandomMergePolicy now swaps in a MismatchedLeafReader for merging reader=" + this.readers.get(i));
                    }
                    this.readers.set(i, SlowCodecReaderWrapper.wrap((LeafReader)new MismatchedLeafReader((LeafReader)this.readers.get(i), this.r)));
                }
            }
            return this.readers;
        }
    }
}

