/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.AssertingBulkScorer;
import org.apache.lucene.search.AssertingScorer;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class AssertingWeight
extends FilterWeight {
    final Random random;
    final boolean needsScores;

    AssertingWeight(Random random, Weight in, boolean needsScores) {
        super(in);
        this.random = random;
        this.needsScores = needsScores;
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        Scorer inScorer = this.in.scorer(context);
        assert (inScorer == null || inScorer.docID() == -1);
        return AssertingScorer.wrap(new Random(this.random.nextLong()), inScorer, this.needsScores);
    }

    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer inScorer = this.in.bulkScorer(context);
        if (inScorer == null) {
            return null;
        }
        return AssertingBulkScorer.wrap(new Random(this.random.nextLong()), inScorer, context.reader().maxDoc());
    }
}

