/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Locale;
import java.util.function.Predicate;

public final class TestSecurityManager
extends SecurityManager {
    private static final String JUNIT4_TEST_RUNNER_PACKAGE = "com.carrotsearch.ant.tasks.junit4.";
    private static final String ECLIPSE_TEST_RUNNER_PACKAGE = "org.eclipse.jdt.internal.junit.runner.";
    private static final String IDEA_TEST_RUNNER_PACKAGE = "com.intellij.rt.execution.junit.";
    private static final String GRADLE_TEST_RUNNER_PACKAGE = "worker.org.gradle.process.internal.worker.";
    private static final String SYSTEM_CLASS_NAME = System.class.getName();
    private static final String RUNTIME_CLASS_NAME = Runtime.class.getName();

    @Override
    public void checkExit(int status) {
        if (StackWalker.getInstance().walk(s -> s.dropWhile(Predicate.not(TestSecurityManager::isExitStackFrame)).dropWhile(TestSecurityManager::isExitStackFrame).limit(1L).map(StackWalker.StackFrame::getClassName).noneMatch(c -> c.startsWith(JUNIT4_TEST_RUNNER_PACKAGE) || c.startsWith(ECLIPSE_TEST_RUNNER_PACKAGE) || c.startsWith(IDEA_TEST_RUNNER_PACKAGE) || c.startsWith(GRADLE_TEST_RUNNER_PACKAGE))).booleanValue()) {
            throw new SecurityException(String.format(Locale.ENGLISH, "System/Runtime.exit(%1$d) or halt(%1$d) calls are not allowed because they terminate the test runner's JVM.", status));
        }
        super.checkExit(status);
    }

    private static boolean isExitStackFrame(StackWalker.StackFrame f) {
        String methodName = f.getMethodName();
        String className = f.getClassName();
        return !(!"exit".equals(methodName) && !"halt".equals(methodName) || !SYSTEM_CLASS_NAME.equals(className) && !RUNTIME_CLASS_NAME.equals(className));
    }
}

