/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;

public final class MockTokenFilter
extends TokenFilter {
    public static final CharacterRunAutomaton EMPTY_STOPSET = new CharacterRunAutomaton(Automata.makeEmpty());
    public static final CharacterRunAutomaton ENGLISH_STOPSET = new CharacterRunAutomaton(Operations.union(Arrays.asList(Automata.makeString((String)"a"), Automata.makeString((String)"an"), Automata.makeString((String)"and"), Automata.makeString((String)"are"), Automata.makeString((String)"as"), Automata.makeString((String)"at"), Automata.makeString((String)"be"), Automata.makeString((String)"but"), Automata.makeString((String)"by"), Automata.makeString((String)"for"), Automata.makeString((String)"if"), Automata.makeString((String)"in"), Automata.makeString((String)"into"), Automata.makeString((String)"is"), Automata.makeString((String)"it"), Automata.makeString((String)"no"), Automata.makeString((String)"not"), Automata.makeString((String)"of"), Automata.makeString((String)"on"), Automata.makeString((String)"or"), Automata.makeString((String)"such"), Automata.makeString((String)"that"), Automata.makeString((String)"the"), Automata.makeString((String)"their"), Automata.makeString((String)"then"), Automata.makeString((String)"there"), Automata.makeString((String)"these"), Automata.makeString((String)"they"), Automata.makeString((String)"this"), Automata.makeString((String)"to"), Automata.makeString((String)"was"), Automata.makeString((String)"will"), Automata.makeString((String)"with"))));
    private final CharacterRunAutomaton filter;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private int skippedPositions;

    public MockTokenFilter(TokenStream input, CharacterRunAutomaton filter) {
        super(input);
        this.filter = filter;
    }

    public boolean incrementToken() throws IOException {
        this.skippedPositions = 0;
        while (this.input.incrementToken()) {
            if (!this.filter.run(this.termAtt.buffer(), 0, this.termAtt.length())) {
                this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
                return true;
            }
            this.skippedPositions += this.posIncrAtt.getPositionIncrement();
        }
        return false;
    }

    public void end() throws IOException {
        super.end();
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }

    public void reset() throws IOException {
        super.reset();
        this.skippedPositions = 0;
    }
}

