/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class DisablingBulkScorerQuery
extends Query {
    private final Query query;

    public DisablingBulkScorerQuery(Query query) {
        this.query = query;
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.query.rewrite(indexSearcher);
        if (this.query != rewritten) {
            return new DisablingBulkScorerQuery(rewritten);
        }
        return super.rewrite(indexSearcher);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Weight in = this.query.createWeight(searcher, scoreMode, boost);
        return new FilterWeight(in){

            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                Scorer scorer = this.scorer(context);
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }
        };
    }

    public String toString(String field) {
        return this.query.toString(field);
    }

    public void visit(QueryVisitor visitor) {
        this.query.visit(visitor);
    }

    public boolean equals(Object obj) {
        return this.sameClassAs(obj) && this.query.equals((Object)((DisablingBulkScorerQuery)((Object)obj)).query);
    }

    public int hashCode() {
        return 31 * this.classHash() + this.query.hashCode();
    }
}

