/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.tests.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.store.MockDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public abstract class BaseSegmentInfoFormatTestCase
extends BaseIndexFileFormatTestCase {
    protected boolean supportsMinVersion() {
        return true;
    }

    public void testFiles() throws Exception {
        BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, Collections.emptyMap(), null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
        BaseSegmentInfoFormatTestCase.assertEquals((Object)info.files(), (Object)info2.files());
        dir.close();
    }

    public void testAddsSelfToFiles() throws Exception {
        BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, Collections.emptyMap(), null);
        Set<String> originalFiles = Collections.singleton("_123.a");
        info.setFiles(originalFiles);
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        Set modifiedFiles = info.files();
        BaseSegmentInfoFormatTestCase.assertTrue((boolean)modifiedFiles.containsAll(originalFiles));
        BaseSegmentInfoFormatTestCase.assertTrue((String)"did you forget to add yourself to files()", (modifiedFiles.size() > originalFiles.size() ? 1 : 0) != 0);
        SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
        BaseSegmentInfoFormatTestCase.assertEquals((Object)info.files(), (Object)info2.files());
        BaseSegmentInfoFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> info2.files().add("bogus"));
        dir.close();
    }

    public void testDiagnostics() throws Exception {
        BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        HashMap<String, String> diagnostics = new HashMap<String, String>();
        diagnostics.put("key1", "value1");
        diagnostics.put("key2", "value2");
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], this.getVersions()[0], "_123", 1, false, codec, diagnostics, id, Collections.emptyMap(), null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
        BaseSegmentInfoFormatTestCase.assertEquals(diagnostics, (Object)info2.getDiagnostics());
        BaseSegmentInfoFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> info2.getDiagnostics().put("bogus", "bogus"));
        dir.close();
    }

    public void testAttributes() throws Exception {
        BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("key1", "value1");
        attributes.put("key2", "value2");
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, attributes, null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
        BaseSegmentInfoFormatTestCase.assertEquals(attributes, (Object)info2.getAttributes());
        BaseSegmentInfoFormatTestCase.expectThrows(UnsupportedOperationException.class, () -> info2.getAttributes().put("bogus", "bogus"));
        dir.close();
    }

    public void testUniqueID() throws Exception {
        Codec codec = this.getCodec();
        BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, Collections.emptyMap(), null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
        BaseSegmentInfoFormatTestCase.assertArrayEquals((byte[])id, (byte[])info2.getId());
        dir.close();
    }

    public void testVersions() throws Exception {
        Codec codec = this.getCodec();
        for (Version v : this.getVersions()) {
            for (Version minV : new Version[]{v, null}) {
                BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
                byte[] id = StringHelper.randomId();
                SegmentInfo info = new SegmentInfo((Directory)dir, v, minV, "_123", 1, false, codec, Collections.emptyMap(), id, Collections.emptyMap(), null);
                info.setFiles(Collections.emptySet());
                codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
                SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
                BaseSegmentInfoFormatTestCase.assertEquals((Object)info2.getVersion(), (Object)v);
                if (this.supportsMinVersion()) {
                    BaseSegmentInfoFormatTestCase.assertEquals((Object)info2.getMinVersion(), (Object)minV);
                } else {
                    BaseSegmentInfoFormatTestCase.assertEquals((Object)info2.getMinVersion(), null);
                }
                dir.close();
            }
        }
    }

    protected boolean supportsIndexSort() {
        return true;
    }

    private SortField randomIndexSortField() {
        SortedSetSortField sortField;
        boolean reversed = BaseSegmentInfoFormatTestCase.random().nextBoolean();
        switch (BaseSegmentInfoFormatTestCase.random().nextInt(10)) {
            case 0: {
                sortField = new SortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), SortField.Type.INT, reversed);
                if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) break;
                sortField.setMissingValue((Object)BaseSegmentInfoFormatTestCase.random().nextInt());
                break;
            }
            case 1: {
                sortField = new SortedNumericSortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), SortField.Type.INT, reversed);
                if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) break;
                sortField.setMissingValue((Object)BaseSegmentInfoFormatTestCase.random().nextInt());
                break;
            }
            case 2: {
                sortField = new SortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), SortField.Type.LONG, reversed);
                if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) break;
                sortField.setMissingValue((Object)BaseSegmentInfoFormatTestCase.random().nextLong());
                break;
            }
            case 3: {
                sortField = new SortedNumericSortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), SortField.Type.LONG, reversed);
                if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) break;
                sortField.setMissingValue((Object)BaseSegmentInfoFormatTestCase.random().nextLong());
                break;
            }
            case 4: {
                sortField = new SortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), SortField.Type.FLOAT, reversed);
                if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) break;
                sortField.setMissingValue((Object)Float.valueOf(BaseSegmentInfoFormatTestCase.random().nextFloat()));
                break;
            }
            case 5: {
                sortField = new SortedNumericSortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), SortField.Type.FLOAT, reversed);
                if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) break;
                sortField.setMissingValue((Object)Float.valueOf(BaseSegmentInfoFormatTestCase.random().nextFloat()));
                break;
            }
            case 6: {
                sortField = new SortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), SortField.Type.DOUBLE, reversed);
                if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) break;
                sortField.setMissingValue((Object)BaseSegmentInfoFormatTestCase.random().nextDouble());
                break;
            }
            case 7: {
                sortField = new SortedNumericSortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), SortField.Type.DOUBLE, reversed);
                if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) break;
                sortField.setMissingValue((Object)BaseSegmentInfoFormatTestCase.random().nextDouble());
                break;
            }
            case 8: {
                sortField = new SortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), SortField.Type.STRING, reversed);
                if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) break;
                sortField.setMissingValue(SortField.STRING_LAST);
                break;
            }
            case 9: {
                sortField = new SortedSetSortField(TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random()), reversed);
                if (!BaseSegmentInfoFormatTestCase.random().nextBoolean()) break;
                sortField.setMissingValue(SortField.STRING_LAST);
                break;
            }
            default: {
                sortField = null;
                BaseSegmentInfoFormatTestCase.fail();
            }
        }
        return sortField;
    }

    public void testSort() throws IOException {
        BaseSegmentInfoFormatTestCase.assumeTrue("test requires a codec that can read/write index sort", this.supportsIndexSort());
        int iters = BaseSegmentInfoFormatTestCase.atLeast(5);
        for (int i = 0; i < iters; ++i) {
            Sort sort;
            if (i == 0) {
                sort = null;
            } else {
                int numSortFields = TestUtil.nextInt(BaseSegmentInfoFormatTestCase.random(), 1, 3);
                SortField[] sortFields = new SortField[numSortFields];
                for (int j = 0; j < numSortFields; ++j) {
                    sortFields[j] = this.randomIndexSortField();
                }
                sort = new Sort(sortFields);
            }
            BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
            Codec codec = this.getCodec();
            byte[] id = StringHelper.randomId();
            SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, Collections.emptyMap(), sort);
            info.setFiles(Collections.emptySet());
            codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
            SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT);
            BaseSegmentInfoFormatTestCase.assertEquals((Object)sort, (Object)info2.getIndexSort());
            dir.close();
        }
    }

    public void testExceptionOnCreateOutput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                if (this.doFail && LuceneTestCase.callStackContainsAnyOf("createOutput")) {
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, Collections.emptyMap(), null);
        info.setFiles(Collections.emptySet());
        fail.setDoFail();
        BaseSegmentInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnCloseOutput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                if (this.doFail && LuceneTestCase.callStackContainsAnyOf("close")) {
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, Collections.emptyMap(), null);
        info.setFiles(Collections.emptySet());
        fail.setDoFail();
        BaseSegmentInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnOpenInput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                if (this.doFail && LuceneTestCase.callStackContainsAnyOf("openInput")) {
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, Collections.emptyMap(), null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        fail.setDoFail();
        BaseSegmentInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testExceptionOnCloseInput() throws Exception {
        MockDirectoryWrapper.Failure fail = new MockDirectoryWrapper.Failure(){

            @Override
            public void eval(MockDirectoryWrapper dir) throws IOException {
                if (this.doFail && LuceneTestCase.callStackContainsAnyOf("close")) {
                    throw new MockDirectoryWrapper.FakeIOException();
                }
            }
        };
        MockDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newMockDirectory();
        dir.failOn(fail);
        Codec codec = this.getCodec();
        byte[] id = StringHelper.randomId();
        SegmentInfo info = new SegmentInfo((Directory)dir, this.getVersions()[0], this.getVersions()[0], "_123", 1, false, codec, Collections.emptyMap(), id, Collections.emptyMap(), null);
        info.setFiles(Collections.emptySet());
        codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
        fail.setDoFail();
        BaseSegmentInfoFormatTestCase.expectThrows(MockDirectoryWrapper.FakeIOException.class, () -> codec.segmentInfoFormat().read((Directory)dir, "_123", id, IOContext.DEFAULT));
        fail.clearDoFail();
        dir.close();
    }

    public void testRandom() throws Exception {
        Codec codec = this.getCodec();
        Version[] versions = this.getVersions();
        for (int i = 0; i < 10; ++i) {
            BaseDirectoryWrapper dir = BaseSegmentInfoFormatTestCase.newDirectory();
            Version version = versions[BaseSegmentInfoFormatTestCase.random().nextInt(versions.length)];
            long randomSegmentIndex = Math.abs(BaseSegmentInfoFormatTestCase.random().nextLong());
            String name = "_" + Long.toString(randomSegmentIndex != Long.MIN_VALUE ? randomSegmentIndex : (long)BaseSegmentInfoFormatTestCase.random().nextInt(Integer.MAX_VALUE), 36);
            int docCount = TestUtil.nextInt(BaseSegmentInfoFormatTestCase.random(), 1, 0x7FFFFF7F);
            boolean isCompoundFile = BaseSegmentInfoFormatTestCase.random().nextBoolean();
            HashSet<String> files = new HashSet<String>();
            int numFiles = BaseSegmentInfoFormatTestCase.random().nextInt(10);
            for (int j = 0; j < numFiles; ++j) {
                String file = IndexFileNames.segmentFileName((String)name, (String)"", (String)Integer.toString(j));
                files.add(file);
                dir.createOutput(file, IOContext.DEFAULT).close();
            }
            HashMap<String, String> diagnostics = new HashMap<String, String>();
            int numDiags = BaseSegmentInfoFormatTestCase.random().nextInt(10);
            for (int j = 0; j < numDiags; ++j) {
                diagnostics.put(TestUtil.randomUnicodeString(BaseSegmentInfoFormatTestCase.random()), TestUtil.randomUnicodeString(BaseSegmentInfoFormatTestCase.random()));
            }
            byte[] id = new byte[16];
            BaseSegmentInfoFormatTestCase.random().nextBytes(id);
            HashMap<String, String> attributes = new HashMap<String, String>();
            int numAttributes = BaseSegmentInfoFormatTestCase.random().nextInt(10);
            for (int j = 0; j < numAttributes; ++j) {
                attributes.put(TestUtil.randomUnicodeString(BaseSegmentInfoFormatTestCase.random()), TestUtil.randomUnicodeString(BaseSegmentInfoFormatTestCase.random()));
            }
            SegmentInfo info = new SegmentInfo((Directory)dir, version, null, name, docCount, isCompoundFile, codec, diagnostics, id, attributes, null);
            info.setFiles(files);
            codec.segmentInfoFormat().write((Directory)dir, info, IOContext.DEFAULT);
            SegmentInfo info2 = codec.segmentInfoFormat().read((Directory)dir, name, id, IOContext.DEFAULT);
            this.assertEquals(info, info2);
            dir.close();
        }
    }

    protected final void assertEquals(SegmentInfo expected, SegmentInfo actual) {
        BaseSegmentInfoFormatTestCase.assertSame((Object)expected.dir, (Object)actual.dir);
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.name, (Object)actual.name);
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.files(), (Object)actual.files());
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.getDiagnostics(), (Object)actual.getDiagnostics());
        BaseSegmentInfoFormatTestCase.assertEquals((long)expected.maxDoc(), (long)actual.maxDoc());
        BaseSegmentInfoFormatTestCase.assertArrayEquals((byte[])expected.getId(), (byte[])actual.getId());
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.getUseCompoundFile(), (Object)actual.getUseCompoundFile());
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.getVersion(), (Object)actual.getVersion());
        BaseSegmentInfoFormatTestCase.assertEquals((Object)expected.getAttributes(), (Object)actual.getAttributes());
    }

    protected abstract Version[] getVersions();

    @Override
    protected void addRandomFields(Document doc) {
        doc.add((IndexableField)new StoredField("foobar", TestUtil.randomSimpleString(BaseSegmentInfoFormatTestCase.random())));
    }
}

