/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.tests.search.AssertingWeight;

public final class AssertingQuery
extends Query {
    private final Random random;
    private final Query in;

    public AssertingQuery(Random random, Query in) {
        this.random = random;
        this.in = in;
    }

    public static Query wrap(Random random, Query query) {
        return query instanceof AssertingQuery ? query : new AssertingQuery(random, query);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        assert (boost >= 0.0f);
        return new AssertingWeight(new Random(this.random.nextLong()), this.in.createWeight(searcher, scoreMode, boost), scoreMode);
    }

    public String toString(String field) {
        return this.in.toString(field);
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.in.equals((Object)((AssertingQuery)((Object)other)).in);
    }

    public int hashCode() {
        return -this.in.hashCode();
    }

    public Random getRandom() {
        return this.random;
    }

    public Query getIn() {
        return this.in;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.in.rewrite(reader);
        if (rewritten == this.in) {
            return super.rewrite(reader);
        }
        return AssertingQuery.wrap(new Random(this.random.nextLong()), rewritten);
    }

    public void visit(QueryVisitor visitor) {
        this.in.visit(visitor);
    }
}

