/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.util;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.tests.util.AbstractBeforeAfterRule;
import org.apache.lucene.tests.util.TestRuleIgnoreTestSuites;

public class VerifyTestClassNamingConvention
extends AbstractBeforeAfterRule {
    private final String packagePrefix;
    private final Pattern namingConvention;

    public VerifyTestClassNamingConvention(String packagePrefix, Pattern namingConvention) {
        this.packagePrefix = packagePrefix;
        this.namingConvention = namingConvention;
    }

    @Override
    protected void before() throws Exception {
        if (TestRuleIgnoreTestSuites.isRunningNested()) {
            return;
        }
        String suiteName = RandomizedContext.current().getTargetClass().getName();
        Matcher matcher = this.namingConvention.matcher(suiteName);
        if (suiteName.startsWith(this.packagePrefix) && !matcher.matches()) {
            throw new AssertionError((Object)(this.packagePrefix + " suite must follow " + this.namingConvention + " naming convention: " + suiteName));
        }
    }
}

