/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ObjectByteProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.set.AbstractSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectByteMap<T>
extends AbstractSet {
    public boolean containsKey(final T key) {
        return !this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final byte value) {
        return !this.forEachPair(new ObjectByteProcedure<T>(){

            @Override
            public boolean apply(T iterKey, byte iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractObjectByteMap<T> copy() {
        return (AbstractObjectByteMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractObjectByteMap)) {
            return false;
        }
        final AbstractObjectByteMap other = (AbstractObjectByteMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ObjectByteProcedure<T>(){

            @Override
            public boolean apply(T key, byte value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ObjectByteProcedure<T>(){

            @Override
            public boolean apply(T key, byte value) {
                return AbstractObjectByteMap.this.containsKey(key) && AbstractObjectByteMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(ObjectProcedure<T> var1);

    public boolean forEachPair(final ObjectByteProcedure<T> procedure) {
        return this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                return procedure.apply(key, AbstractObjectByteMap.this.get(key));
            }
        });
    }

    public abstract byte get(T var1);

    public List<T> keys() {
        ArrayList list = new ArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final List<T> list) {
        list.clear();
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(List<T> keyList) {
        this.pairsSortedByValue(keyList, new ByteArrayList(this.size()));
    }

    public void pairsMatching(final ObjectByteProcedure<T> condition, final List<T> keyList, final ByteArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ObjectByteProcedure<T>(){

            @Override
            public boolean apply(T key, byte value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(List<T> keyList, ByteArrayList valueList) {
        this.keys(keyList);
        if (keyList.isEmpty()) {
            return;
        }
        T k = keyList.get(0);
        if (!(k instanceof Comparable)) {
            throw new UnsupportedOperationException("The key type for this map does not implement comparable");
        }
        Collections.sort(keyList);
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.get(i)));
        }
    }

    public void pairsSortedByValue(final List<T> keyList, ByteArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final byte[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                byte t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                Object t2 = keyList.get(a);
                keyList.set(a, keyList.get(b));
                keyList.set(b, t2);
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : 0);
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(T var1, byte var2);

    public abstract boolean removeKey(T var1);

    public String toString() {
        List<T> theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            T key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ArrayList theKeys = new ArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            Object key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public ByteArrayList values() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new ObjectProcedure<T>(){

            @Override
            public boolean apply(T key) {
                list.add(AbstractObjectByteMap.this.get(key));
                return true;
            }
        });
    }

    public byte adjustOrPutValue(T key, byte newValue, byte incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (byte)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

