/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.Arrays;
import java.util.List;
import org.apache.mahout.math.function.ObjectFloatProcedure;
import org.apache.mahout.math.function.ObjectProcedure;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.map.AbstractObjectFloatMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenObjectFloatHashMap<T>
extends AbstractObjectFloatMap<T> {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected static final Object NO_KEY_VALUE = null;
    private Object[] table;
    private float[] values;
    private byte[] state;
    private int freeEntries;

    public OpenObjectFloatHashMap() {
        this(277);
    }

    public OpenObjectFloatHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenObjectFloatHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.state, 0, this.state.length - 1, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public Object clone() {
        OpenObjectFloatHashMap copy = (OpenObjectFloatHashMap)super.clone();
        copy.table = (Object[])copy.table.clone();
        copy.values = (float[])copy.values.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    @Override
    public boolean containsKey(T key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public boolean containsValue(float value) {
        return this.indexOfValue(value) >= 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    @Override
    public boolean forEachKey(ObjectProcedure<T> procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachPair(ObjectFloatProcedure<T> procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public float get(T key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return 0.0f;
        }
        return this.values[i];
    }

    protected int indexOfInsertion(T key) {
        int length = this.table.length;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] == 1 && !OpenObjectFloatHashMap.equalsMindTheNull(this.table[i], key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 2) {
            int j = i;
            while (!(this.state[i] == 0 || this.state[i] != 2 && OpenObjectFloatHashMap.equalsMindTheNull(this.table[i], key))) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (this.state[i] == 0) {
                i = j;
            }
        }
        if (this.state[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(T key) {
        int length = this.table.length;
        int hash = key.hashCode() & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (!(this.state[i] == 0 || this.state[i] != 2 && OpenObjectFloatHashMap.equalsMindTheNull(this.table[i], key))) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 0) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(float value) {
        float[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || val[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void keys(List<T> list) {
        list.clear();
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            list.add(this.table[i]);
        }
    }

    @Override
    public void pairsMatching(ObjectFloatProcedure<T> condition, List<T> keyList, FloatArrayList valueList) {
        keyList.clear();
        valueList.clear();
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || !condition.apply(this.table[i], this.values[i])) continue;
            keyList.add(this.table[i]);
            valueList.add(this.values[i]);
        }
    }

    @Override
    public boolean put(T key, float value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    public float adjustOrPutValue(T key, float newValue, float incrValue) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            int n = i = -i - 1;
            this.values[n] = this.values[n] + incrValue;
            return this.values[i];
        }
        this.put(key, newValue);
        return newValue;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        Object[] oldTable = this.table;
        float[] oldValues = this.values;
        byte[] oldState = this.state;
        this.table = new Object[newCapacity];
        this.values = new float[newCapacity];
        this.state = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            Object element = oldTable[i];
            int index = this.indexOfInsertion(element);
            this.table[index] = element;
            this.values[index] = oldValues[i];
            this.state[index] = 1;
        }
    }

    @Override
    public boolean removeKey(T key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new Object[capacity];
        this.values = new float[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    @Override
    public void values(FloatArrayList list) {
        list.setSize(this.distinct);
        float[] elements = list.elements();
        int j = 0;
        int i = this.state.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.values[i];
        }
    }

    protected void getInternalFactors(int[] capacity, double[] minLoadFactor, double[] maxLoadFactor) {
        capacity[0] = this.table.length;
        minLoadFactor[0] = this.minLoadFactor;
        maxLoadFactor[0] = this.maxLoadFactor;
    }
}

