/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.Charsets;
import org.apache.mahout.cf.taste.example.kddcup.DataFileIterable;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.Pair;

public final class ToCSV {
    private ToCSV() {
    }

    public static void main(String[] args) throws Exception {
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        int columnsToOutput = 4;
        if (args.length >= 3) {
            columnsToOutput = Integer.parseInt(args[2]);
        }
        GZIPOutputStream outStream = new GZIPOutputStream(new FileOutputStream(outputFile));
        try (BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)outStream, Charsets.UTF_8));){
            for (Pair<PreferenceArray, long[]> user : new DataFileIterable(inputFile)) {
                PreferenceArray prefs = (PreferenceArray)user.getFirst();
                long[] timestamps = (long[])user.getSecond();
                for (int i = 0; i < prefs.length(); ++i) {
                    outWriter.write(String.valueOf(prefs.getUserID(i)));
                    ((Writer)outWriter).write(44);
                    outWriter.write(String.valueOf(prefs.getItemID(i)));
                    if (columnsToOutput > 2) {
                        ((Writer)outWriter).write(44);
                        outWriter.write(String.valueOf(prefs.getValue(i)));
                    }
                    if (columnsToOutput > 3) {
                        ((Writer)outWriter).write(44);
                        outWriter.write(String.valueOf(timestamps[i]));
                    }
                    ((Writer)outWriter).write(10);
                }
            }
        }
    }
}

