/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track2;

import java.util.regex.Pattern;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;

final class TrackData {
    private static final Pattern PIPE = Pattern.compile("\\|");
    private static final String NO_VALUE = "None";
    static final long NO_VALUE_ID = Long.MIN_VALUE;
    private static final FastIDSet NO_GENRES = new FastIDSet();
    private final long trackID;
    private final long albumID;
    private final long artistID;
    private final FastIDSet genreIDs;

    TrackData(CharSequence line) {
        String[] tokens = PIPE.split(line);
        this.trackID = Long.parseLong(tokens[0]);
        this.albumID = TrackData.parse(tokens[1]);
        this.artistID = TrackData.parse(tokens[2]);
        if (tokens.length > 3) {
            this.genreIDs = new FastIDSet(tokens.length - 3);
            for (int i = 3; i < tokens.length; ++i) {
                this.genreIDs.add(Long.parseLong(tokens[i]));
            }
        } else {
            this.genreIDs = NO_GENRES;
        }
    }

    private static long parse(String value) {
        return NO_VALUE.equals(value) ? Long.MIN_VALUE : Long.parseLong(value);
    }

    public long getTrackID() {
        return this.trackID;
    }

    public long getAlbumID() {
        return this.albumID;
    }

    public long getArtistID() {
        return this.artistID;
    }

    public FastIDSet getGenreIDs() {
        return this.genreIDs;
    }
}

