/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.mahout.classifier.NewsgroupHelper;
import org.apache.mahout.classifier.sgd.AdaptiveLogisticRegression;
import org.apache.mahout.classifier.sgd.CrossFoldLearner;
import org.apache.mahout.classifier.sgd.L1;
import org.apache.mahout.classifier.sgd.ModelSerializer;
import org.apache.mahout.classifier.sgd.OnlineLogisticRegression;
import org.apache.mahout.classifier.sgd.PriorFunction;
import org.apache.mahout.classifier.sgd.SGDHelper;
import org.apache.mahout.classifier.sgd.SGDInfo;
import org.apache.mahout.ep.State;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.Dictionary;

public final class TrainNewsGroups {
    private TrainNewsGroups() {
    }

    public static void main(String[] args) throws IOException {
        File base = new File(args[0]);
        HashMultiset overallCounts = HashMultiset.create();
        int leakType = 0;
        if (args.length > 1) {
            leakType = Integer.parseInt(args[1]);
        }
        Dictionary newsGroups = new Dictionary();
        NewsgroupHelper helper = new NewsgroupHelper();
        helper.getEncoder().setProbes(2);
        AdaptiveLogisticRegression learningAlgorithm = new AdaptiveLogisticRegression(20, 10000, (PriorFunction)new L1());
        learningAlgorithm.setInterval(800);
        learningAlgorithm.setAveragingWindow(500);
        ArrayList<File> files = new ArrayList<File>();
        for (File newsgroup : base.listFiles()) {
            if (!newsgroup.isDirectory()) continue;
            newsGroups.intern(newsgroup.getName());
            files.addAll(Arrays.asList(newsgroup.listFiles()));
        }
        Collections.shuffle(files);
        System.out.println(files.size() + " training files");
        SGDInfo info = new SGDInfo();
        int k = 0;
        for (File file : files) {
            String ng = file.getParentFile().getName();
            int actual = newsGroups.intern(ng);
            Vector v = helper.encodeFeatureVector(file, actual, leakType, (Multiset<String>)overallCounts);
            learningAlgorithm.train(actual, v);
            State best = learningAlgorithm.getBest();
            SGDHelper.analyzeState(info, leakType, ++k, (State<AdaptiveLogisticRegression.Wrapper, CrossFoldLearner>)best);
        }
        learningAlgorithm.close();
        SGDHelper.dissect(leakType, newsGroups, learningAlgorithm, files, (Multiset<String>)overallCounts);
        System.out.println("exiting main");
        File modelFile = new File(System.getProperty("java.io.tmpdir"), "news-group.model");
        ModelSerializer.writeBinary((String)modelFile.getAbsolutePath(), (OnlineLogisticRegression)((OnlineLogisticRegression)((AdaptiveLogisticRegression.Wrapper)learningAlgorithm.getBest().getPayload()).getLearner().getModels().get(0)));
        ArrayList<Integer> counts = new ArrayList<Integer>();
        System.out.println("Word counts");
        for (String count : overallCounts.elementSet()) {
            counts.add(overallCounts.count((Object)count));
        }
        Collections.sort(counts, Ordering.natural().reverse());
        k = 0;
        for (Integer count : counts) {
            System.out.println(k + "\t" + count);
            if (++k <= 1000) continue;
            break;
        }
    }
}

