/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.conversion.meanshift;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.meanshift.MeanShiftCanopy;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;

public class InputMapper
extends Mapper<LongWritable, Text, Text, ClusterWritable> {
    private static final Pattern SPACE = Pattern.compile(" ");
    private int nextCanopyId;
    private ClusterWritable cw = new ClusterWritable();

    protected void map(LongWritable key, Text values, Mapper.Context context) throws IOException, InterruptedException {
        String[] numbers = SPACE.split(values.toString());
        ArrayList doubles = Lists.newArrayList();
        for (String value : numbers) {
            if (value.isEmpty()) continue;
            doubles.add(Double.valueOf(value));
        }
        if (!doubles.isEmpty()) {
            DenseVector point = new DenseVector(doubles.size());
            int index = 0;
            for (Double d : doubles) {
                point.set(index++, d.doubleValue());
            }
            this.cw.setValue((Cluster)new MeanShiftCanopy((Vector)point, this.nextCanopyId++, (DistanceMeasure)new EuclideanDistanceMeasure()));
            context.write((Object)new Text(), (Object)this.cw);
        }
    }
}

