/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.arff;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.utils.vectors.arff.ARFFModel;
import org.apache.mahout.utils.vectors.arff.ARFFVectorIterable;
import org.apache.mahout.utils.vectors.arff.MapBackedARFFModel;
import org.apache.mahout.utils.vectors.io.SequenceFileVectorWriter;
import org.apache.mahout.utils.vectors.io.VectorWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Driver {
    private static final Logger log = LoggerFactory.getLogger(Driver.class);

    private Driver() {
    }

    public static void main(String[] args) throws IOException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputOpt = obuilder.withLongName("input").withRequired(true).withArgument(abuilder.withName("input").withMinimum(1).withMaximum(1).create()).withDescription("The file or directory containing the ARFF files.  If it is a directory, all .arff files will be converted").withShortName("d").create();
        DefaultOption outputOpt = obuilder.withLongName("output").withRequired(true).withArgument(abuilder.withName("output").withMinimum(1).withMaximum(1).create()).withDescription("The output directory.  Files will have the same name as the input, but with the extension .mvc").withShortName("o").create();
        DefaultOption maxOpt = obuilder.withLongName("max").withRequired(false).withArgument(abuilder.withName("max").withMinimum(1).withMaximum(1).create()).withDescription("The maximum number of vectors to output.  If not specified, then it will loop over all docs").withShortName("m").create();
        DefaultOption dictOutOpt = obuilder.withLongName("dictOut").withRequired(true).withArgument(abuilder.withName("dictOut").withMinimum(1).withMaximum(1).create()).withDescription("The file to output the label bindings").withShortName("t").create();
        DefaultOption delimiterOpt = obuilder.withLongName("delimiter").withRequired(false).withArgument(abuilder.withName("delimiter").withMinimum(1).withMaximum(1).create()).withDescription("The delimiter for outputing the dictionary").withShortName("l").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption((Option)inputOpt).withOption((Option)outputOpt).withOption((Option)maxOpt).withOption((Option)helpOpt).withOption((Option)dictOutOpt).withOption((Option)delimiterOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption((Option)helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            if (cmdLine.hasOption((Option)inputOpt)) {
                File input = new File(cmdLine.getValue((Option)inputOpt).toString());
                long maxDocs = Long.MAX_VALUE;
                if (cmdLine.hasOption((Option)maxOpt)) {
                    maxDocs = Long.parseLong(cmdLine.getValue((Option)maxOpt).toString());
                }
                if (maxDocs < 0L) {
                    throw new IllegalArgumentException("maxDocs must be >= 0");
                }
                String outDir = cmdLine.getValue((Option)outputOpt).toString();
                log.info("Output Dir: {}", (Object)outDir);
                String delimiter = cmdLine.hasOption((Option)delimiterOpt) ? cmdLine.getValue((Option)delimiterOpt).toString() : "\t";
                File dictOut = new File(cmdLine.getValue((Option)dictOutOpt).toString());
                MapBackedARFFModel model = new MapBackedARFFModel();
                if (input.exists() && input.isDirectory()) {
                    File[] files;
                    for (File file : files = input.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String name) {
                            return name.endsWith(".arff");
                        }
                    })) {
                        Driver.writeFile(outDir, file, maxDocs, model, dictOut, delimiter);
                    }
                } else {
                    Driver.writeFile(outDir, input, maxDocs, model, dictOut, delimiter);
                }
            }
        }
        catch (OptionException e) {
            log.error("Exception", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLabelBindings(File dictOut, ARFFModel arffModel, String delimiter) throws IOException {
        Map<String, Integer> labels = arffModel.getLabelBindings();
        Writer writer = (Writer)Files.newWriterSupplier((File)dictOut, (Charset)Charsets.UTF_8, (boolean)true).getOutput();
        try {
            writer.write("Label bindings for Relation " + arffModel.getRelation() + '\n');
            for (Map.Entry<String, Integer> entry : labels.entrySet()) {
                writer.write(entry.getKey());
                writer.write(delimiter);
                writer.write(String.valueOf(entry.getValue()));
                writer.write(10);
            }
            writer.write(10);
        }
        finally {
            Closeables.closeQuietly((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String outDir, File file, long maxDocs, ARFFModel arffModel, File dictOut, String delimiter) throws IOException {
        log.info("Converting File: {}", (Object)file);
        MapBackedARFFModel model = new MapBackedARFFModel(arffModel.getWords(), arffModel.getWordCount() + 1L, arffModel.getNominalMap());
        ARFFVectorIterable iteratable = new ARFFVectorIterable(file, (ARFFModel)model);
        String outFile = outDir + '/' + file.getName() + ".mvc";
        VectorWriter vectorWriter = Driver.getSeqFileWriter(outFile);
        try {
            long numDocs = vectorWriter.write(iteratable, maxDocs);
            Driver.writeLabelBindings(dictOut, model, delimiter);
            log.info("Wrote: {} vectors", (Object)numDocs);
        }
        finally {
            Closeables.closeQuietly((Closeable)vectorWriter);
        }
    }

    private static VectorWriter getSeqFileWriter(String outFile) throws IOException {
        Path path = new Path(outFile);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        SequenceFile.Writer seqWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, LongWritable.class, VectorWritable.class);
        return new SequenceFileVectorWriter(seqWriter);
    }
}

