/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.arff;

import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.mahout.utils.vectors.arff.ARFFModel;
import org.apache.mahout.utils.vectors.arff.ARFFType;

public class MapBackedARFFModel
implements ARFFModel {
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    private long wordCount = 1L;
    private String relation;
    private final Map<String, Integer> labelBindings;
    private final Map<Integer, String> idxLabel;
    private final Map<Integer, ARFFType> typeMap;
    private final Map<Integer, DateFormat> dateMap;
    private final Map<String, Map<String, Integer>> nominalMap;
    private final Map<String, Long> words;

    public MapBackedARFFModel() {
        this(new HashMap<String, Long>(), 1L, new HashMap<String, Map<String, Integer>>());
    }

    public MapBackedARFFModel(Map<String, Long> words, long wordCount, Map<String, Map<String, Integer>> nominalMap) {
        this.words = words;
        this.wordCount = wordCount;
        this.labelBindings = Maps.newHashMap();
        this.idxLabel = Maps.newHashMap();
        this.typeMap = Maps.newHashMap();
        this.dateMap = Maps.newHashMap();
        this.nominalMap = nominalMap;
    }

    @Override
    public String getRelation() {
        return this.relation;
    }

    @Override
    public void setRelation(String relation) {
        this.relation = relation;
    }

    @Override
    public double getValue(String data, int idx) {
        double result;
        ARFFType type = this.typeMap.get(idx);
        if (type == null) {
            throw new IllegalArgumentException("Attribute type cannot be NULL, attribute index was: " + idx);
        }
        data = QUOTE_PATTERN.matcher(data).replaceAll("");
        data = data.trim();
        switch (type) {
            case NUMERIC: {
                result = MapBackedARFFModel.processNumeric(data);
                break;
            }
            case DATE: {
                result = this.processDate(data, idx);
                break;
            }
            case STRING: {
                result = this.processString(data);
                break;
            }
            case NOMINAL: {
                String label = this.idxLabel.get(idx);
                result = this.processNominal(label, data);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + (Object)((Object)type));
            }
        }
        return result;
    }

    protected double processNominal(String label, String data) {
        Integer ord;
        Map<String, Integer> classes = this.nominalMap.get(label);
        if (classes != null) {
            ord = classes.get(data);
            if (ord == null) {
                throw new IllegalStateException("Invalid nominal: " + data + " for label: " + label);
            }
        } else {
            throw new IllegalArgumentException("Invalid nominal label: " + label + " Data: " + data);
        }
        double result = ord.intValue();
        return result;
    }

    protected double processString(String data) {
        Long theLong = this.words.get(data = QUOTE_PATTERN.matcher(data).replaceAll(""));
        if (theLong == null) {
            theLong = this.wordCount++;
            this.words.put(data, theLong);
        }
        return theLong.longValue();
    }

    protected static double processNumeric(String data) {
        return Double.parseDouble(data);
    }

    protected double processDate(String data, int idx) {
        double result;
        DateFormat format = this.dateMap.get(idx);
        if (format == null) {
            format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        }
        try {
            Date date = format.parse(data);
            result = date.getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    @Override
    public Map<String, Integer> getLabelBindings() {
        return Collections.unmodifiableMap(this.labelBindings);
    }

    public Map<Integer, ARFFType> getTypeMap() {
        return Collections.unmodifiableMap(this.typeMap);
    }

    public Map<Integer, DateFormat> getDateMap() {
        return Collections.unmodifiableMap(this.dateMap);
    }

    @Override
    public Map<String, Map<String, Integer>> getNominalMap() {
        return this.nominalMap;
    }

    @Override
    public Map<String, Long> getWords() {
        return this.words;
    }

    @Override
    public Integer getNominalValue(String label, String nominal) {
        return this.nominalMap.get(label).get(nominal);
    }

    @Override
    public void addNominal(String label, String nominal, int idx) {
        HashMap noms = this.nominalMap.get(label);
        if (noms == null) {
            noms = Maps.newHashMap();
            this.nominalMap.put(label, noms);
        }
        noms.put(nominal, idx);
    }

    @Override
    public DateFormat getDateFormat(Integer idx) {
        return this.dateMap.get(idx);
    }

    @Override
    public void addDateFormat(Integer idx, DateFormat format) {
        this.dateMap.put(idx, format);
    }

    @Override
    public Integer getLabelIndex(String label) {
        return this.labelBindings.get(label);
    }

    @Override
    public void addLabel(String label, Integer idx) {
        this.labelBindings.put(label, idx);
        this.idxLabel.put(idx, label);
    }

    @Override
    public ARFFType getARFFType(Integer idx) {
        return this.typeMap.get(idx);
    }

    @Override
    public void addType(Integer idx, ARFFType type) {
        this.typeMap.put(idx, type);
    }

    @Override
    public long getWordCount() {
        return this.wordCount;
    }

    @Override
    public int getLabelSize() {
        return this.labelBindings.size();
    }
}

