/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.lucene.LuceneIterator;
import org.apache.mahout.utils.vectors.lucene.VectorMapper;

public final class LuceneIterable
implements Iterable<Vector> {
    public static final double NO_NORMALIZING = -1.0;
    private final IndexReader indexReader;
    private final String field;
    private final String idField;
    private final VectorMapper mapper;
    private final double normPower;
    private final double maxPercentErrorDocs;

    public LuceneIterable(IndexReader reader, String idField, String field, VectorMapper mapper) {
        this(reader, idField, field, mapper, -1.0);
    }

    public LuceneIterable(IndexReader indexReader, String idField, String field, VectorMapper mapper, double normPower) {
        this(indexReader, idField, field, mapper, normPower, 0.0);
    }

    public LuceneIterable(IndexReader indexReader, String idField, String field, VectorMapper mapper, double normPower, double maxPercentErrorDocs) {
        this.indexReader = indexReader;
        this.idField = idField;
        this.field = field;
        this.mapper = mapper;
        this.normPower = normPower;
        this.maxPercentErrorDocs = maxPercentErrorDocs;
    }

    @Override
    public Iterator<Vector> iterator() {
        try {
            return new LuceneIterator(this.indexReader, this.idField, this.field, this.mapper, this.normPower, this.maxPercentErrorDocs);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

