/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Comparator;

public final class BinarySearch {
    private BinarySearch() {
    }

    public static int binarySearchFromTo(byte[] array, byte value, int from, int to) {
        int mid = -1;
        while (from <= to) {
            mid = from + to >>> 1;
            if (value > array[mid]) {
                from = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            to = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearchFromTo(char[] array, char value, int from, int to) {
        int mid = -1;
        while (from <= to) {
            mid = from + to >>> 1;
            if (value > array[mid]) {
                from = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            to = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearchFromTo(double[] array, double value, int from, int to) {
        long longBits = Double.doubleToLongBits(value);
        int mid = -1;
        while (from <= to) {
            mid = from + to >>> 1;
            if (BinarySearch.lessThan(array[mid], value)) {
                from = mid + 1;
                continue;
            }
            if (longBits == Double.doubleToLongBits(array[mid])) {
                return mid;
            }
            to = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (BinarySearch.lessThan(value, array[mid]) ? 1 : 2);
    }

    public static int binarySearchFromTo(float[] array, float value, int from, int to) {
        int intBits = Float.floatToIntBits(value);
        int mid = -1;
        while (from <= to) {
            mid = from + to >>> 1;
            if (BinarySearch.lessThan(array[mid], value)) {
                from = mid + 1;
                continue;
            }
            if (intBits == Float.floatToIntBits(array[mid])) {
                return mid;
            }
            to = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (BinarySearch.lessThan(value, array[mid]) ? 1 : 2);
    }

    public static int binarySearchFromTo(int[] array, int value, int from, int to) {
        int mid = -1;
        while (from <= to) {
            mid = from + to >>> 1;
            if (value > array[mid]) {
                from = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            to = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static int binarySearchFromTo(long[] array, long value, int from, int to) {
        int mid = -1;
        while (from <= to) {
            mid = from + to >>> 1;
            if (value > array[mid]) {
                from = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            to = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    public static <T extends Comparable<T>> int binarySearchFromTo(T[] array, T object, int from, int to) {
        if (array.length == 0) {
            return -1;
        }
        int mid = 0;
        int result = 0;
        while (from <= to) {
            mid = from + to >>> 1;
            result = array[mid].compareTo(object);
            if (result < 0) {
                from = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            to = mid - 1;
        }
        return -mid - (result >= 0 ? 1 : 2);
    }

    public static <T> int binarySearchFromTo(T[] array, T object, int from, int to, Comparator<? super T> comparator) {
        int mid = 0;
        int result = 0;
        while (from <= to) {
            mid = from + to >>> 1;
            result = comparator.compare(array[mid], object);
            if (result < 0) {
                from = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            to = mid - 1;
        }
        return -mid - (result >= 0 ? 1 : 2);
    }

    public static int binarySearchFromTo(short[] array, short value, int from, int to) {
        int mid = -1;
        while (from <= to) {
            mid = from + to >>> 1;
            if (value > array[mid]) {
                from = mid + 1;
                continue;
            }
            if (value == array[mid]) {
                return mid;
            }
            to = mid - 1;
        }
        if (mid < 0) {
            return -1;
        }
        return -mid - (value < array[mid] ? 1 : 2);
    }

    private static boolean lessThan(double double1, double double2) {
        long d2;
        if (double1 < double2) {
            return true;
        }
        if (double1 > double2) {
            return false;
        }
        if (double1 == double2 && double1 != 0.0) {
            return false;
        }
        if (Double.isNaN(double1)) {
            return false;
        }
        if (Double.isNaN(double2)) {
            return true;
        }
        long d1 = Double.doubleToRawLongBits(double1);
        return d1 < (d2 = Double.doubleToRawLongBits(double2));
    }

    private static boolean lessThan(float float1, float float2) {
        int f2;
        if (float1 < float2) {
            return true;
        }
        if (float1 > float2) {
            return false;
        }
        if (float1 == float2 && float1 != 0.0f) {
            return false;
        }
        if (Float.isNaN(float1)) {
            return false;
        }
        if (Float.isNaN(float2)) {
            return true;
        }
        int f1 = Float.floatToRawIntBits(float1);
        return f1 < (f2 = Float.floatToRawIntBits(float2));
    }
}

