/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.ConstantVector;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixTimesOps;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;

public class DiagonalMatrix
extends AbstractMatrix
implements MatrixTimesOps {
    private final Vector diagonal;

    public DiagonalMatrix(Vector values) {
        super(values.size(), values.size());
        this.diagonal = values;
    }

    public DiagonalMatrix(Matrix values) {
        this(values.viewDiagonal());
    }

    public DiagonalMatrix(double value, int size) {
        this(new ConstantVector(value, size));
    }

    public DiagonalMatrix(double[] values) {
        super(values.length, values.length);
        this.diagonal = new DenseVector(values);
    }

    public static DiagonalMatrix identity(int size) {
        return new DiagonalMatrix(1.0, size);
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        throw new UnsupportedOperationException("Can't assign a column to a diagonal matrix");
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        throw new UnsupportedOperationException("Can't assign a row to a diagonal matrix");
    }

    @Override
    public Vector viewRow(int row) {
        return new SingleElementVector(row);
    }

    @Override
    public Vector viewColumn(int row) {
        return new SingleElementVector(row);
    }

    @Override
    public Vector viewDiagonal() {
        return this.diagonal;
    }

    @Override
    public double getQuick(int row, int column) {
        if (row == column) {
            return this.diagonal.get(row);
        }
        return 0.0;
    }

    @Override
    public Matrix like() {
        return new SparseRowMatrix(this.rowSize(), this.columnSize());
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new SparseRowMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        if (row != column) {
            throw new UnsupportedOperationException("Can't set off-diagonal element");
        }
        this.diagonal.set(row, value);
    }

    @Override
    public int[] getNumNondefaultElements() {
        throw new UnsupportedOperationException("Don't understand how to implement this");
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        return new MatrixView(this, offset, size);
    }

    @Override
    public Matrix times(Matrix other) {
        return this.timesRight(other);
    }

    @Override
    public Matrix timesRight(Matrix that) {
        if (that.numRows() != this.diagonal.size()) {
            throw new IllegalArgumentException("Incompatible number of rows in the right operand of matrix multiplication.");
        }
        Matrix m = that.like();
        for (int row = 0; row < this.diagonal.size(); ++row) {
            m.assignRow(row, that.viewRow(row).times(this.diagonal.getQuick(row)));
        }
        return m;
    }

    @Override
    public Matrix timesLeft(Matrix that) {
        if (that.numCols() != this.diagonal.size()) {
            throw new IllegalArgumentException("Incompatible number of rows in the left operand of matrix-matrix multiplication.");
        }
        Matrix m = that.like();
        for (int col = 0; col < this.diagonal.size(); ++col) {
            m.assignColumn(col, that.viewColumn(col).times(this.diagonal.getQuick(col)));
        }
        return m;
    }

    public class SingleElementVector
    extends AbstractVector {
        private int index;

        public SingleElementVector(int index) {
            super(DiagonalMatrix.this.diagonal.size());
            this.index = index;
        }

        @Override
        public double getQuick(int index) {
            if (index == this.index) {
                return DiagonalMatrix.this.diagonal.get(index);
            }
            return 0.0;
        }

        @Override
        public void set(int index, double value) {
            if (index != this.index) {
                throw new IllegalArgumentException("Can't set off-diagonal element of diagonal matrix");
            }
            DiagonalMatrix.this.diagonal.set(index, value);
        }

        @Override
        protected Iterator<Vector.Element> iterateNonZero() {
            return new Iterator<Vector.Element>(){
                boolean more = true;

                @Override
                public boolean hasNext() {
                    return this.more;
                }

                @Override
                public Vector.Element next() {
                    if (this.more) {
                        this.more = false;
                        return new Vector.Element(){

                            @Override
                            public double get() {
                                return DiagonalMatrix.this.diagonal.get(SingleElementVector.this.index);
                            }

                            @Override
                            public int index() {
                                return SingleElementVector.this.index;
                            }

                            @Override
                            public void set(double value) {
                                DiagonalMatrix.this.diagonal.set(SingleElementVector.this.index, value);
                            }
                        };
                    }
                    throw new NoSuchElementException("Only one non-zero element in a row or column of a diagonal matrix");
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Can't remove from vector view");
                }
            };
        }

        @Override
        protected Iterator<Vector.Element> iterator() {
            return new Iterator<Vector.Element>(){
                int i = 0;
                Vector.Element r = new Vector.Element(){

                    @Override
                    public double get() {
                        if (i == SingleElementVector.this.index) {
                            return DiagonalMatrix.this.diagonal.get(SingleElementVector.this.index);
                        }
                        return 0.0;
                    }

                    @Override
                    public int index() {
                        return i;
                    }

                    @Override
                    public void set(double value) {
                        if (i != SingleElementVector.this.index) {
                            throw new IllegalArgumentException("Can't set any element but diagonal");
                        }
                        DiagonalMatrix.this.diagonal.set(SingleElementVector.this.index, value);
                    }
                };

                @Override
                public boolean hasNext() {
                    return this.i < DiagonalMatrix.this.diagonal.size() - 1;
                }

                @Override
                public Vector.Element next() {
                    if (this.i < SingleElementVector.this.size() - 1) {
                        ++this.i;
                        return this.r;
                    }
                    throw new NoSuchElementException("Attempted to access passed last element of vector");
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Default operation");
                }
            };
        }

        @Override
        protected Matrix matrixLike(int rows, int columns) {
            return new DiagonalMatrix((double)rows, columns);
        }

        @Override
        public boolean isDense() {
            return false;
        }

        @Override
        public boolean isSequentialAccess() {
            return true;
        }

        @Override
        public void mergeUpdates(OrderedIntDoubleMapping updates) {
            throw new UnsupportedOperationException("Default operation");
        }

        @Override
        public Vector like() {
            return new DenseVector(this.size());
        }

        @Override
        public void setQuick(int index, double value) {
            if (index != this.index) {
                throw new IllegalArgumentException("Can't set off-diagonal element of DiagonalMatrix");
            }
            DiagonalMatrix.this.diagonal.set(this.index, value);
        }

        @Override
        public int getNumNondefaultElements() {
            return 1;
        }

        @Override
        public double getLookupCost() {
            return 0.0;
        }

        @Override
        public double getIteratorAdvanceCost() {
            return 1.0;
        }

        @Override
        public boolean isAddConstantTime() {
            return false;
        }
    }
}

