/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.DelegatingVector;
import org.apache.mahout.math.Vector;

public class WeightedVector
extends DelegatingVector {
    private static final int INVALID_INDEX = -1;
    private double weight;
    private int index;

    protected WeightedVector(double weight, int index) {
        this.weight = weight;
        this.index = index;
    }

    public WeightedVector(Vector v, double weight, int index) {
        super(v);
        this.weight = weight;
        this.index = index;
    }

    public WeightedVector(Vector v, Vector projection, int index) {
        super(v);
        this.index = index;
        this.weight = v.dot(projection);
    }

    public static WeightedVector project(Vector v, Vector projection) {
        return WeightedVector.project(v, projection, -1);
    }

    public static WeightedVector project(Vector v, Vector projection, int index) {
        return new WeightedVector(v, projection, index);
    }

    public double getWeight() {
        return this.weight;
    }

    public int getIndex() {
        return this.index;
    }

    public void setWeight(double newWeight) {
        this.weight = newWeight;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Vector like() {
        return new WeightedVector(this.getVector().like(), this.weight, this.index);
    }

    @Override
    public String toString() {
        return String.format("index=%d, weight=%.2f, v=%s", this.index, this.weight, this.getVector());
    }

    @Override
    public WeightedVector clone() {
        WeightedVector v = (WeightedVector)super.clone();
        v.weight = this.weight;
        v.index = this.index;
        return v;
    }
}

