/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import org.apache.mahout.math.Arrays;
import org.apache.mahout.math.list.AbstractLongList;

public class SimpleLongArrayList
extends AbstractLongList {
    private long[] elements;

    public SimpleLongArrayList() {
        this(10);
    }

    public SimpleLongArrayList(long[] elements) {
        this.elements(elements);
    }

    private SimpleLongArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elements(new long[initialCapacity]);
        this.size = 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        this.elements = Arrays.ensureCapacity(this.elements, minCapacity);
    }

    @Override
    protected long getQuick(int index) {
        return this.elements[index];
    }

    @Override
    protected void setQuick(int index, long element) {
        this.elements[index] = element;
    }

    @Override
    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

