/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.LengthCachingVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;

public class DelegatingVector
implements Vector,
LengthCachingVector {
    protected Vector delegate;

    public DelegatingVector(Vector v) {
        this.delegate = v;
    }

    protected DelegatingVector() {
    }

    public Vector getVector() {
        return this.delegate;
    }

    @Override
    public double aggregate(DoubleDoubleFunction aggregator, DoubleFunction map) {
        return this.delegate.aggregate(aggregator, map);
    }

    @Override
    public double aggregate(Vector other, DoubleDoubleFunction aggregator, DoubleDoubleFunction combiner) {
        return this.delegate.aggregate(other, aggregator, combiner);
    }

    @Override
    public Vector viewPart(int offset, int length) {
        return this.delegate.viewPart(offset, length);
    }

    @Override
    public Vector clone() {
        DelegatingVector r;
        try {
            r = (DelegatingVector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone not supported for DelegatingVector, shouldn't be possible");
        }
        r.delegate = this.delegate.clone();
        return r;
    }

    @Override
    public Iterable<Vector.Element> all() {
        return this.delegate.all();
    }

    @Override
    public Iterable<Vector.Element> nonZeroes() {
        return this.delegate.nonZeroes();
    }

    @Override
    public Vector divide(double x) {
        return this.delegate.divide(x);
    }

    @Override
    public double dot(Vector x) {
        return this.delegate.dot(x);
    }

    @Override
    public double get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public Vector.Element getElement(int index) {
        return this.delegate.getElement(index);
    }

    @Override
    public void mergeUpdates(OrderedIntDoubleMapping updates) {
        this.delegate.mergeUpdates(updates);
    }

    @Override
    public Vector minus(Vector that) {
        return this.delegate.minus(that);
    }

    @Override
    public Vector normalize() {
        return this.delegate.normalize();
    }

    @Override
    public Vector normalize(double power) {
        return this.delegate.normalize(power);
    }

    @Override
    public Vector logNormalize() {
        return this.delegate.logNormalize();
    }

    @Override
    public Vector logNormalize(double power) {
        return this.delegate.logNormalize(power);
    }

    @Override
    public double norm(double power) {
        return this.delegate.norm(power);
    }

    @Override
    public double getLengthSquared() {
        return this.delegate.getLengthSquared();
    }

    @Override
    public void invalidateCachedLength() {
        if (this.delegate instanceof LengthCachingVector) {
            ((LengthCachingVector)((Object)this.delegate)).invalidateCachedLength();
        }
    }

    @Override
    public double getDistanceSquared(Vector v) {
        return this.delegate.getDistanceSquared(v);
    }

    @Override
    public double getLookupCost() {
        return this.delegate.getLookupCost();
    }

    @Override
    public double getIteratorAdvanceCost() {
        return this.delegate.getIteratorAdvanceCost();
    }

    @Override
    public boolean isAddConstantTime() {
        return this.delegate.isAddConstantTime();
    }

    @Override
    public double maxValue() {
        return this.delegate.maxValue();
    }

    @Override
    public int maxValueIndex() {
        return this.delegate.maxValueIndex();
    }

    @Override
    public double minValue() {
        return this.delegate.minValue();
    }

    @Override
    public int minValueIndex() {
        return this.delegate.minValueIndex();
    }

    @Override
    public Vector plus(double x) {
        return this.delegate.plus(x);
    }

    @Override
    public Vector plus(Vector x) {
        return this.delegate.plus(x);
    }

    @Override
    public void set(int index, double value) {
        this.delegate.set(index, value);
    }

    @Override
    public Vector times(double x) {
        return this.delegate.times(x);
    }

    @Override
    public Vector times(Vector x) {
        return this.delegate.times(x);
    }

    @Override
    public double zSum() {
        return this.delegate.zSum();
    }

    @Override
    public Vector assign(double value) {
        this.delegate.assign(value);
        return this;
    }

    @Override
    public Vector assign(double[] values) {
        this.delegate.assign(values);
        return this;
    }

    @Override
    public Vector assign(Vector other) {
        this.delegate.assign(other);
        return this;
    }

    @Override
    public Vector assign(DoubleDoubleFunction f, double y) {
        this.delegate.assign(f, y);
        return this;
    }

    @Override
    public Vector assign(DoubleFunction function) {
        this.delegate.assign(function);
        return this;
    }

    @Override
    public Vector assign(Vector other, DoubleDoubleFunction function) {
        this.delegate.assign(other, function);
        return this;
    }

    @Override
    public Matrix cross(Vector other) {
        return this.delegate.cross(other);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public String asFormatString() {
        return this.delegate.asFormatString();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean isDense() {
        return this.delegate.isDense();
    }

    @Override
    public boolean isSequentialAccess() {
        return this.delegate.isSequentialAccess();
    }

    @Override
    public double getQuick(int index) {
        return this.delegate.getQuick(index);
    }

    @Override
    public Vector like() {
        return new DelegatingVector(this.delegate.like());
    }

    @Override
    public Vector like(int cardinality) {
        return new DelegatingVector(this.delegate.like(cardinality));
    }

    @Override
    public void setQuick(int index, double value) {
        this.delegate.setQuick(index, value);
    }

    @Override
    public void incrementQuick(int index, double increment) {
        this.delegate.incrementQuick(index, increment);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.delegate.getNumNondefaultElements();
    }

    @Override
    public int getNumNonZeroElements() {
        return this.delegate.getNumNonZeroElements();
    }
}

