/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.function.IntProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractIntSet
extends AbstractSet {
    public boolean contains(final int key) {
        return !this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int iterKey) {
                return key != iterKey;
            }
        });
    }

    public AbstractIntSet copy() {
        return (AbstractIntSet)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractIntSet)) {
            return false;
        }
        final AbstractIntSet other = (AbstractIntSet)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                return other.contains(key);
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachKey(new IntProcedure(){
            int i = 0;

            @Override
            public boolean apply(int iterKey) {
                buf[this.i++] = HashUtils.hash(iterKey);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public IntArrayList keys() {
        IntArrayList list = new IntArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                list.add(key);
                return true;
            }
        });
    }

    public abstract boolean add(int var1);

    public abstract boolean remove(int var1);

    public String toString() {
        IntArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }
}

