/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.flavor;

import org.apache.mahout.math.flavor.BackEnum;
import org.apache.mahout.math.flavor.TraversingStructureEnum;

public interface MatrixFlavor {
    public static final MatrixFlavor DENSELIKE = new FlavorImpl(BackEnum.JVMMEM, TraversingStructureEnum.ROWWISE, true);
    public static final MatrixFlavor SPARSELIKE = new FlavorImpl(BackEnum.JVMMEM, TraversingStructureEnum.ROWWISE, false);
    public static final MatrixFlavor SPARSEROWLIKE = new FlavorImpl(BackEnum.JVMMEM, TraversingStructureEnum.SPARSEROWWISE, false);
    public static final MatrixFlavor DIAGONALLIKE = new FlavorImpl(BackEnum.JVMMEM, TraversingStructureEnum.VECTORBACKED, false);

    public BackEnum getBacking();

    public TraversingStructureEnum getStructure();

    public boolean isDense();

    public static final class FlavorImpl
    implements MatrixFlavor {
        private BackEnum pBacking;
        private TraversingStructureEnum pStructure;
        private boolean pDense;

        public FlavorImpl(BackEnum backing, TraversingStructureEnum structure, boolean dense) {
            this.pBacking = backing;
            this.pStructure = structure;
            this.pDense = dense;
        }

        @Override
        public BackEnum getBacking() {
            return this.pBacking;
        }

        @Override
        public TraversingStructureEnum getStructure() {
            return this.pStructure;
        }

        @Override
        public boolean isDense() {
            return this.pDense;
        }
    }
}

