/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.Vector;

public final class FileBasedMatrix
extends AbstractMatrix {
    private final int rowsPerBlock;
    private final List<DoubleBuffer> content = Lists.newArrayList();

    public FileBasedMatrix(int rows, int columns) {
        super(rows, columns);
        long maxRows = Integer.MAX_VALUE / (long)(columns * 8);
        this.rowsPerBlock = (long)rows > maxRows ? (int)maxRows : rows;
    }

    private void addData(DoubleBuffer content) {
        this.content.add(content);
    }

    public void setData(File f, boolean loadNow) throws IOException {
        Preconditions.checkArgument((f.length() == (long)(this.rows * this.columns) * 8L ? 1 : 0) != 0, (Object)("File " + f + " is wrong length"));
        for (int i = 0; i < (this.rows + this.rowsPerBlock - 1) / this.rowsPerBlock; ++i) {
            long start = (long)(i * this.rowsPerBlock * this.columns) * 8L;
            long size = (long)(this.rowsPerBlock * this.columns) * 8L;
            MappedByteBuffer buf = new FileInputStream(f).getChannel().map(FileChannel.MapMode.READ_ONLY, start, Math.min(f.length() - start, size));
            if (loadNow) {
                buf.load();
            }
            this.addData(buf.asDoubleBuffer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMatrix(File f, Matrix m) throws IOException {
        Preconditions.checkArgument((boolean)f.canWrite(), (Object)"Can't write to output file");
        try (FileOutputStream fos = new FileOutputStream(f);){
            ByteBuffer buf = ByteBuffer.allocate(m.columnSize() * 8);
            for (MatrixSlice row : m) {
                buf.clear();
                for (Vector.Element element : row.vector().all()) {
                    buf.putDouble(element.get());
                }
                buf.flip();
                fos.write(buf.array());
            }
        }
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        throw new UnsupportedOperationException("Default operation");
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        throw new UnsupportedOperationException("Default operation");
    }

    @Override
    public double getQuick(int row, int column) {
        int block = row / this.rowsPerBlock;
        return this.content.get(block).get(row % this.rowsPerBlock * this.columns + column);
    }

    @Override
    public Matrix like() {
        throw new UnsupportedOperationException("Default operation");
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        throw new UnsupportedOperationException("Default operation");
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        throw new UnsupportedOperationException("Default operation");
    }
}

