/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Locale;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.QR;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

public class QRDecomposition
implements QR {
    private final Matrix q;
    private final Matrix r;
    private final Matrix mType;
    private final boolean fullRank;
    private final int rows;
    private final int columns;

    public QRDecomposition(Matrix a) {
        this.rows = a.rowSize();
        int min = Math.min(a.rowSize(), a.columnSize());
        this.columns = a.columnSize();
        this.mType = a.like(1, 1);
        Matrix qTmp = a.clone();
        boolean fullRank = true;
        this.r = new DenseMatrix(min, this.columns);
        for (int i = 0; i < min; ++i) {
            Vector qi = qTmp.viewColumn(i);
            double alpha = qi.norm(2.0);
            if (Math.abs(alpha) > Double.MIN_VALUE) {
                qi.assign(Functions.div(alpha));
            } else {
                if (Double.isInfinite(alpha) || Double.isNaN(alpha)) {
                    throw new ArithmeticException("Invalid intermediate result");
                }
                fullRank = false;
            }
            this.r.set(i, i, alpha);
            for (int j = i + 1; j < this.columns; ++j) {
                Vector qj = qTmp.viewColumn(j);
                double norm = qj.norm(2.0);
                if (Math.abs(norm) > Double.MIN_VALUE) {
                    double beta = qi.dot(qj);
                    this.r.set(i, j, beta);
                    if (j >= min) continue;
                    qj.assign(qi, Functions.plusMult(-beta));
                    continue;
                }
                if (!Double.isInfinite(norm) && !Double.isNaN(norm)) continue;
                throw new ArithmeticException("Invalid intermediate result");
            }
        }
        this.q = this.columns > min ? qTmp.viewPart(0, this.rows, 0, min).clone() : qTmp;
        this.fullRank = fullRank;
    }

    @Override
    public Matrix getQ() {
        return this.q;
    }

    @Override
    public Matrix getR() {
        return this.r;
    }

    @Override
    public boolean hasFullRank() {
        return this.fullRank;
    }

    @Override
    public Matrix solve(Matrix B) {
        if (B.numRows() != this.rows) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        int cols = B.numCols();
        Matrix x = this.mType.like(this.columns, cols);
        Matrix qt = this.getQ().transpose();
        Matrix y = qt.times(B);
        Matrix r = this.getR();
        for (int k = Math.min(this.columns, this.rows) - 1; k >= 0; --k) {
            x.viewRow(k).assign(y.viewRow(k), Functions.plusMult(1.0 / r.get(k, k)));
            Vector rColumn = r.viewColumn(k).viewPart(0, k);
            for (int c = 0; c < cols; ++c) {
                y.viewColumn(c).viewPart(0, k).assign(rColumn, Functions.plusMult(-x.get(k, c)));
            }
        }
        return x;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "QR(%d x %d,fullRank=%s)", this.rows, this.columns, this.hasFullRank());
    }
}

