/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.doublealgo;

import org.apache.mahout.math.function.BinaryFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.jet.random.engine.MersenneTwister;
import org.apache.mahout.math.jet.random.engine.RandomEngine;
import org.apache.mahout.math.jet.random.sampling.RandomSampler;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.DoubleMatrix3D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;

@Deprecated
public class Statistic {
    public static final VectorVectorFunction EUCLID = new VectorVectorFunction(){

        public double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            return Math.sqrt(a.aggregate(b, Functions.plus, Functions.chain(Functions.square, Functions.minus)));
        }
    };
    public static final VectorVectorFunction BRAY_CURTIS = new VectorVectorFunction(){

        public double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            return a.aggregate(b, Functions.plus, Functions.chain(Functions.abs, Functions.minus)) / a.aggregate(b, Functions.plus, Functions.plus);
        }
    };
    public static final VectorVectorFunction CANBERRA = new VectorVectorFunction(){
        private final BinaryFunction fun = new BinaryFunction(){

            public double apply(double a, double b) {
                return Math.abs(a - b) / Math.abs(a + b);
            }
        };

        public double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            return a.aggregate(b, Functions.plus, this.fun);
        }
    };
    public static final VectorVectorFunction MAXIMUM = new VectorVectorFunction(){

        public double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            return a.aggregate(b, Functions.max, Functions.chain(Functions.abs, Functions.minus));
        }
    };
    public static final VectorVectorFunction MANHATTAN = new VectorVectorFunction(){

        public double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            return a.aggregate(b, Functions.plus, Functions.chain(Functions.abs, Functions.minus));
        }
    };

    private Statistic() {
    }

    public static DoubleMatrix2D correlation(DoubleMatrix2D covariance) {
        int i = covariance.columns();
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                double stdDev1 = Math.sqrt(covariance.getQuick(i, i));
                double stdDev2 = Math.sqrt(covariance.getQuick(j, j));
                double cov = covariance.getQuick(i, j);
                double corr = cov / (stdDev1 * stdDev2);
                covariance.setQuick(i, j, corr);
                covariance.setQuick(j, i, corr);
            }
        }
        i = covariance.columns();
        while (--i >= 0) {
            covariance.setQuick(i, i, 1.0);
        }
        return covariance;
    }

    public static DoubleMatrix2D covariance(DoubleMatrix2D matrix) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        DenseDoubleMatrix2D covariance = new DenseDoubleMatrix2D(columns, columns);
        double[] sums = new double[columns];
        DoubleMatrix1D[] cols = new DoubleMatrix1D[columns];
        int i = columns;
        while (--i >= 0) {
            cols[i] = matrix.viewColumn(i);
            sums[i] = cols[i].zSum();
        }
        i = columns;
        while (--i >= 0) {
            int j = i + 1;
            while (--j >= 0) {
                double sumOfProducts = cols[i].zDotProduct(cols[j]);
                double cov = (sumOfProducts - sums[i] * sums[j] / (double)rows) / (double)rows;
                ((DoubleMatrix2D)covariance).setQuick(i, j, cov);
                ((DoubleMatrix2D)covariance).setQuick(j, i, cov);
            }
        }
        return covariance;
    }

    public static DoubleMatrix2D distance(DoubleMatrix2D matrix, VectorVectorFunction distanceFunction) {
        int columns = matrix.columns();
        DenseDoubleMatrix2D distance = new DenseDoubleMatrix2D(columns, columns);
        DoubleMatrix1D[] cols = new DoubleMatrix1D[columns];
        int i = columns;
        while (--i >= 0) {
            cols[i] = matrix.viewColumn(i);
        }
        i = columns;
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                double d = distanceFunction.apply(cols[i], cols[j]);
                ((DoubleMatrix2D)distance).setQuick(i, j, d);
                ((DoubleMatrix2D)distance).setQuick(j, i, d);
            }
        }
        return distance;
    }

    public static DoubleMatrix1D viewSample(DoubleMatrix1D matrix, double fraction, RandomEngine randomGenerator) {
        int ncols;
        double epsilon = 1.0E-9;
        if (fraction < 0.0 - epsilon || fraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (fraction < 0.0) {
            fraction = 0.0;
        }
        if (fraction > 1.0) {
            fraction = 1.0;
        }
        if (randomGenerator == null) {
            randomGenerator = new MersenneTwister((int)System.currentTimeMillis());
        }
        int max = ncols = (int)Math.round((double)matrix.size() * fraction);
        long[] selected = new long[max];
        int n = ncols;
        int N = matrix.size();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedCols[i] = (int)selected[i];
        }
        return matrix.viewSelection(selectedCols);
    }

    public static DoubleMatrix2D viewSample(DoubleMatrix2D matrix, double rowFraction, double columnFraction, RandomEngine randomGenerator) {
        double epsilon = 1.0E-9;
        if (rowFraction < 0.0 - epsilon || rowFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (rowFraction < 0.0) {
            rowFraction = 0.0;
        }
        if (rowFraction > 1.0) {
            rowFraction = 1.0;
        }
        if (columnFraction < 0.0 - epsilon || columnFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (columnFraction < 0.0) {
            columnFraction = 0.0;
        }
        if (columnFraction > 1.0) {
            columnFraction = 1.0;
        }
        if (randomGenerator == null) {
            randomGenerator = new MersenneTwister((int)System.currentTimeMillis());
        }
        int nrows = (int)Math.round((double)matrix.rows() * rowFraction);
        int ncols = (int)Math.round((double)matrix.columns() * columnFraction);
        int max = Math.max(nrows, ncols);
        long[] selected = new long[max];
        int n = nrows;
        int N = matrix.rows();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedRows = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedRows[i] = (int)selected[i];
        }
        n = ncols;
        N = matrix.columns();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedCols[i] = (int)selected[i];
        }
        return matrix.viewSelection(selectedRows, selectedCols);
    }

    public static DoubleMatrix3D viewSample(DoubleMatrix3D matrix, double sliceFraction, double rowFraction, double columnFraction, RandomEngine randomGenerator) {
        double epsilon = 1.0E-9;
        if (sliceFraction < 0.0 - epsilon || sliceFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (sliceFraction < 0.0) {
            sliceFraction = 0.0;
        }
        if (sliceFraction > 1.0) {
            sliceFraction = 1.0;
        }
        if (rowFraction < 0.0 - epsilon || rowFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (rowFraction < 0.0) {
            rowFraction = 0.0;
        }
        if (rowFraction > 1.0) {
            rowFraction = 1.0;
        }
        if (columnFraction < 0.0 - epsilon || columnFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (columnFraction < 0.0) {
            columnFraction = 0.0;
        }
        if (columnFraction > 1.0) {
            columnFraction = 1.0;
        }
        if (randomGenerator == null) {
            randomGenerator = new MersenneTwister((int)System.currentTimeMillis());
        }
        int nslices = (int)Math.round((double)matrix.slices() * sliceFraction);
        int nrows = (int)Math.round((double)matrix.rows() * rowFraction);
        int ncols = (int)Math.round((double)matrix.columns() * columnFraction);
        int max = Math.max(nslices, Math.max(nrows, ncols));
        long[] selected = new long[max];
        int n = nslices;
        int N = matrix.slices();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedSlices = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedSlices[i] = (int)selected[i];
        }
        n = nrows;
        N = matrix.rows();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedRows = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedRows[i] = (int)selected[i];
        }
        n = ncols;
        N = matrix.columns();
        RandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedCols[i] = (int)selected[i];
        }
        return matrix.viewSelection(selectedSlices, selectedRows, selectedCols);
    }

    @Deprecated
    public static interface VectorVectorFunction {
        public double apply(DoubleMatrix1D var1, DoubleMatrix1D var2);
    }
}

