/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;

public final class DevURandomSeedGenerator
implements SeedGenerator {
    private static final File DEV_URANDOM = new File("/dev/urandom");

    public byte[] generateSeed(int length) throws SeedException {
        FileInputStream file = null;
        try {
            int bytesRead;
            file = new FileInputStream(DEV_URANDOM);
            byte[] randomSeed = new byte[length];
            for (int count = 0; count < length; count += bytesRead) {
                bytesRead = file.read(randomSeed, count, length - count);
                if (bytesRead != -1) continue;
                throw new SeedException("EOF encountered reading random data.");
            }
            byte[] byArray = randomSeed;
            return byArray;
        }
        catch (IOException ex) {
            throw new SeedException("Failed reading from " + DEV_URANDOM.getName(), (Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new SeedException("SecurityManager prevented access to " + DEV_URANDOM.getName(), (Throwable)ex);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public String toString() {
        return "/dev/urandom";
    }
}

