/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.apache.mahout.common.RandomWrapper;

public final class RandomUtils {
    public static final int MAX_INT_SMALLER_TWIN_PRIME = 2147482949;
    private static final Map<RandomWrapper, Boolean> INSTANCES = Collections.synchronizedMap(new WeakHashMap());

    private RandomUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useTestSeed() {
        RandomWrapper.useTestSeed();
        Map<RandomWrapper, Boolean> map = INSTANCES;
        synchronized (map) {
            for (RandomWrapper rng : INSTANCES.keySet()) {
                rng.reset();
            }
        }
    }

    public static Random getRandom() {
        RandomWrapper random = new RandomWrapper();
        INSTANCES.put(random, Boolean.TRUE);
        return random;
    }

    public static Random getRandom(long seed) {
        RandomWrapper random = new RandomWrapper(seed);
        INSTANCES.put(random, Boolean.TRUE);
        return random;
    }

    public static byte[] longSeedtoBytes(long seed) {
        byte[] seedBytes = new byte[16];
        seedBytes[0] = (byte)(seed >>> 56);
        seedBytes[1] = (byte)(seed >>> 48);
        seedBytes[2] = (byte)(seed >>> 40);
        seedBytes[3] = (byte)(seed >>> 32);
        seedBytes[4] = (byte)(seed >>> 24);
        seedBytes[5] = (byte)(seed >>> 16);
        seedBytes[6] = (byte)(seed >>> 8);
        seedBytes[7] = (byte)seed;
        System.arraycopy(seedBytes, 0, seedBytes, 8, 8);
        return seedBytes;
    }

    public static long seedBytesToLong(byte[] seed) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result |= ((long)seed[i] & 0xFFL) << 8 * (7 - i);
        }
        return result;
    }

    public static int hashDouble(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    public static int hashFloat(float value) {
        return Float.floatToIntBits(value);
    }

    public static int hashLong(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static int nextTwinPrime(int n) {
        if (n > 2147482949) {
            throw new IllegalArgumentException();
        }
        if (n <= 3) {
            return 5;
        }
        int next = RandomUtils.nextPrime(n);
        while (RandomUtils.isNotPrime(next + 2)) {
            next = RandomUtils.nextPrime(next + 4);
        }
        return next + 2;
    }

    public static int nextPrime(int n) {
        if (n <= 2) {
            return 2;
        }
        n |= 1;
        while (RandomUtils.isNotPrime(n)) {
            n += 2;
        }
        return n;
    }

    public static boolean isNotPrime(int n) {
        if (n < 2 || (n & 1) == 0) {
            return n != 2;
        }
        int max = 1 + (int)Math.sqrt(n);
        for (int d = 3; d <= max; d += 2) {
            if (n % d != 0) continue;
            return true;
        }
        return false;
    }
}

