/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.nio.charset.Charset;
import java.util.Random;
import org.apache.mahout.common.FastRandomSeedGenerator;
import org.apache.mahout.common.RandomUtils;
import org.uncommons.maths.random.MersenneTwisterRNG;
import org.uncommons.maths.random.RepeatableRNG;
import org.uncommons.maths.random.SeedException;
import org.uncommons.maths.random.SeedGenerator;

public final class RandomWrapper
extends Random {
    private static final byte[] STANDARD_SEED = "Mahout=Hadoop+ML".getBytes(Charset.forName("US-ASCII"));
    private static final SeedGenerator SEED_GENERATOR = new FastRandomSeedGenerator();
    private static boolean testSeed;
    private Random random;
    private final Long fixedSeed;

    RandomWrapper() {
        this.fixedSeed = null;
        this.random = this.buildRandom();
    }

    RandomWrapper(long fixedSeed) {
        this.fixedSeed = fixedSeed;
        this.random = this.buildRandom();
    }

    static void useTestSeed() {
        testSeed = true;
    }

    private Random buildRandom() {
        if (testSeed) {
            return new MersenneTwisterRNG(STANDARD_SEED);
        }
        if (this.fixedSeed == null) {
            try {
                return new MersenneTwisterRNG(SEED_GENERATOR);
            }
            catch (SeedException se) {
                throw new IllegalStateException(se);
            }
        }
        return new MersenneTwisterRNG(RandomUtils.longSeedtoBytes(this.fixedSeed));
    }

    public Random getRandom() {
        return this.random;
    }

    void reset() {
        this.random = this.buildRandom();
    }

    public long getSeed() {
        return RandomUtils.seedBytesToLong(((RepeatableRNG)this.random).getSeed());
    }

    public void setSeed(long seed) {
        if (this.random != null) {
            this.random.setSeed(seed);
        }
    }

    protected int next(int bits) {
        throw new UnsupportedOperationException();
    }

    public void nextBytes(byte[] bytes) {
        this.random.nextBytes(bytes);
    }

    public int nextInt() {
        return this.random.nextInt();
    }

    public int nextInt(int n) {
        return this.random.nextInt(n);
    }

    public long nextLong() {
        return this.random.nextLong();
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public double nextGaussian() {
        return this.random.nextGaussian();
    }
}

